/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor;

import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeType;
import org.netbeans.modules.css.lib.api.NodeUtil;
import org.netbeans.modules.web.common.api.LexerUtils;

public class CssDeclarationContext {
    private static final String IE_HACK_POSTFIX = "\\9";
    private static final String IE_STAR_HACK_PREFIX = "*";
    private Node declaration;
    private Node propertyName;
    private Node propertyValue;

    public CssDeclarationContext(Node declaration) {
        this.declaration = declaration;
        this.propertyName = NodeUtil.getChildByType((Node)declaration, (NodeType)NodeType.property);
        this.propertyValue = NodeUtil.getChildByType((Node)declaration, (NodeType)NodeType.propertyValue);
    }

    public Node getDeclaration() {
        return this.declaration;
    }

    public Node getProperty() {
        return this.propertyName;
    }

    public Node getPropertyValue() {
        return this.propertyValue;
    }

    public String getPropertyNameImage() {
        return this.propertyName == null ? null : ((Object)this.propertyName.image()).toString().trim();
    }

    public String getPropertyValueImage() {
        return this.propertyValue == null ? null : ((Object)this.propertyValue.image()).toString().trim();
    }

    public boolean containsIEStarHack() {
        Node sibling = NodeUtil.getSibling((Node)this.propertyName, (boolean)true);
        return sibling != null && LexerUtils.equals((CharSequence)IE_STAR_HACK_PREFIX, (CharSequence)sibling.image(), (boolean)false, (boolean)false);
    }

    public boolean containsIEBS9Hack() {
        return this.getPropertyValueImage() != null && this.getPropertyValueImage().endsWith(IE_HACK_POSTFIX);
    }
}

