/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClassIndexListener;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.RootsEvent;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TypesEvent;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.method.MethodModel;
import org.netbeans.modules.j2ee.common.method.MethodModelSupport;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.ComponentMethodViewStrategy;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.MethodNode;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public abstract class ComponentMethodModel
extends Children.Keys<MethodModel> {
    private final ClasspathInfo cpInfo;
    private final String homeInterface;
    private Collection<String> interfaces;
    private String implBean;
    private EjbJar ejbModule;
    private final ClassIndexListener classIndexListener;

    public ComponentMethodModel(ClasspathInfo cpInfo, EjbJar ejbModule, String implBean, Collection<String> interfaces, String homeInterface) {
        this.cpInfo = cpInfo;
        this.homeInterface = homeInterface;
        this.implBean = implBean;
        this.ejbModule = ejbModule;
        this.interfaces = interfaces;
        this.classIndexListener = new ClassIndexListenerImpl();
    }

    private void updateKeys() {
        ComponentMethodViewStrategy viewStrategy = this.createViewStrategy();
        final ArrayList keys = new ArrayList();
        try {
            JavaSource javaSource = JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[0]);
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    Elements elements = controller.getElements();
                    final ElementUtilities elementUtilities = controller.getElementUtilities();
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    for (String className : ComponentMethodModel.this.getInterfaces()) {
                        MethodModel methodModel;
                        Iterable methods;
                        final TypeElement intf = elements.getTypeElement(className);
                        if (intf == null) continue;
                        if (className.equals(ComponentMethodModel.this.homeInterface)) {
                            for (ExecutableElement executableElement : ElementFilter.methodsIn(intf.getEnclosedElements())) {
                                MethodModel methodModel2 = MethodModelSupport.createMethodModel((CompilationController)controller, (ExecutableElement)executableElement);
                                if (methodModel2 == null) continue;
                                keys.add(methodModel2);
                            }
                            continue;
                        }
                        if (intf.getKind() == ElementKind.CLASS) {
                            if (!ComponentMethodModel.this.hasNoInterfaceView(intf)) continue;
                            methods = elementUtilities.getMembers(intf.asType(), new ElementUtilities.ElementAcceptor(){

                                public boolean accept(Element e, TypeMirror type) {
                                    TypeElement parent = elementUtilities.enclosingTypeElement(e);
                                    return ElementKind.METHOD == e.getKind() && ((Object)e.getEnclosingElement()).equals(intf) && e.getModifiers().contains((Object)Modifier.PUBLIC);
                                }
                            });
                            for (Element method : methods) {
                                methodModel = MethodModelSupport.createMethodModel((CompilationController)controller, (ExecutableElement)((ExecutableElement)method));
                                if (methodModel == null || keys.contains(methodModel)) continue;
                                keys.add(methodModel);
                            }
                            continue;
                        }
                        methods = elementUtilities.getMembers(intf.asType(), new ElementUtilities.ElementAcceptor(){

                            public boolean accept(Element e, TypeMirror type) {
                                TypeElement parent = elementUtilities.enclosingTypeElement(e);
                                boolean isInInterface = ElementKind.INTERFACE == parent.getKind();
                                boolean isFromJavaxEjb = parent.getQualifiedName().toString().startsWith("javax.ejb.");
                                return isInInterface && !isFromJavaxEjb && ElementKind.METHOD == e.getKind();
                            }
                        });
                        for (Element method : methods) {
                            methodModel = MethodModelSupport.createMethodModel((CompilationController)controller, (ExecutableElement)((ExecutableElement)method));
                            if (methodModel == null) continue;
                            keys.add(methodModel);
                        }
                    }
                }
            }, true);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComponentMethodModel.this.setKeys(keys);
            }
        });
    }

    private boolean hasNoInterfaceView(final TypeElement intf) {
        try {
            boolean hasNoInterfaceView = (Boolean)this.ejbModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Boolean>(){

                public Boolean run(EjbJarMetadata metadata) throws Exception {
                    Session session = (Session)metadata.findByEjbClass(ComponentMethodModel.this.implBean);
                    if (session != null) {
                        if (session.isLocalBean()) {
                            return true;
                        }
                        if (session.getLocal() == null && session.getRemote() == null && session.getLocalHome() == null && session.getHome() == null) {
                            for (TypeMirror typeMirror : intf.getInterfaces()) {
                                String ifaceFqn = ((Object)typeMirror).toString();
                                if (ifaceFqn.equals("java.io.Serializable") || ifaceFqn.equals("java.io.Externalizable") || ifaceFqn.startsWith("javax.ejb.")) continue;
                                return false;
                            }
                            return true;
                        }
                    }
                    return false;
                }
            });
            return hasNoInterfaceView;
        }
        catch (MetadataModelException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return false;
    }

    protected void addNotify() {
        if (this.interfaces == null) {
            this.interfaces = this.getInterfaces();
        }
        assert (this.interfaces != null);
        if (this.implBean == null) {
            this.implBean = this.getImplBean();
        }
        super.addNotify();
        this.registerListeners();
        this.updateKeys();
    }

    private void registerListeners() {
        try {
            JavaSource javaSource = JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[0]);
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    ClassIndex classIndex = controller.getClasspathInfo().getClassIndex();
                    classIndex.addClassIndexListener(ComponentMethodModel.this.classIndexListener);
                }
            }, true);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    private void removeListeners() {
        if (this.interfaces == null) {
            return;
        }
        try {
            JavaSource javaSource = JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[0]);
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    ClassIndex classIndex = controller.getClasspathInfo().getClassIndex();
                    classIndex.removeClassIndexListener(ComponentMethodModel.this.classIndexListener);
                }
            }, true);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    protected void removeNotify() {
        if (this.interfaces == null) {
            return;
        }
        this.setKeys(Collections.emptySet());
        this.removeListeners();
        super.removeNotify();
    }

    protected Collection<String> getInterfaces() {
        return this.interfaces;
    }

    protected String getImplBean() {
        return null;
    }

    public abstract ComponentMethodViewStrategy createViewStrategy();

    protected Node[] createNodes(MethodModel key) {
        ComponentMethodViewStrategy cmvs = this.createViewStrategy();
        return new Node[]{new MethodNode(this.cpInfo, key, this.implBean, this.getInterfaces(), cmvs)};
    }

    private class ClassIndexListenerImpl
    implements ClassIndexListener {
        private ClassIndexListenerImpl() {
        }

        public void typesAdded(TypesEvent event) {
            this.handleTypes(event);
        }

        public void typesRemoved(TypesEvent event) {
            this.handleTypes(event);
        }

        public void typesChanged(TypesEvent event) {
            this.handleTypes(event);
        }

        public void rootsAdded(RootsEvent event) {
        }

        public void rootsRemoved(RootsEvent event) {
        }

        private void handleTypes(TypesEvent event) {
            for (ElementHandle elementHandle : event.getTypes()) {
                if (!ComponentMethodModel.this.interfaces.contains(elementHandle.getQualifiedName())) continue;
                ComponentMethodModel.this.updateKeys();
                return;
            }
        }
    }
}

