/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.entity;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EntityMethodController;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.entity.CMPFieldsNode;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.entity.MethodChildren;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.EjbViewController;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.MethodsNode;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class EntityChildren
extends Children.Keys<KEY>
implements PropertyChangeListener {
    private static final int REMOTE = 0;
    private static final int LOCAL = 1;
    private static final int CMP = 2;
    private final ClasspathInfo cpInfo;
    private final String ejbClass;
    private final EjbJar ejbModule;
    private final EntityMethodController controller;
    private final Entity model;

    public EntityChildren(EjbViewController ejbViewController) throws IOException {
        this.cpInfo = ejbViewController.getClasspathInfo();
        this.ejbClass = ejbViewController.getEjbClass();
        this.ejbModule = ejbViewController.getEjbModule();
        this.controller = new EntityMethodController(this.ejbClass, (MetadataModel<EjbJarMetadata>)this.ejbModule.getMetadataModel());
        this.model = (Entity)this.ejbModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Entity>(){

            public Entity run(EjbJarMetadata metadata) throws Exception {
                return (Entity)metadata.findByEjbClass(EntityChildren.this.ejbClass);
            }
        });
    }

    protected void addNotify() {
        super.addNotify();
        try {
            this.updateKeys();
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    private void updateKeys() throws IOException {
        final boolean[] results = new boolean[]{false, false, false};
        this.ejbModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Void>(){

            public Void run(EjbJarMetadata metadata) throws Exception {
                Entity entity = (Entity)metadata.findByEjbClass(EntityChildren.this.ejbClass);
                if (entity != null) {
                    results[0] = entity.getRemote() != null;
                    results[1] = entity.getLocal() != null;
                    results[2] = "Container".equals(entity.getPersistenceType());
                }
                return null;
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ArrayList<KEY> keys = new ArrayList<KEY>();
                if (results[0]) {
                    keys.add(KEY.REMOTE);
                }
                if (results[1]) {
                    keys.add(KEY.LOCAL);
                }
                if (results[2]) {
                    keys.add(KEY.CMP_FIELDS);
                }
                EntityChildren.this.setKeys(keys);
            }
        });
    }

    protected void removeNotify() {
        this.setKeys(Collections.emptySet());
        super.removeNotify();
    }

    protected Node[] createNodes(KEY key) {
        if (key == KEY.LOCAL) {
            MethodChildren children = new MethodChildren(this.cpInfo, this.ejbModule, this.controller, this.model, this.controller.getLocalInterfaces(), true, this.ejbModule.getDeploymentDescriptor());
            MethodsNode n = new MethodsNode(this.ejbClass, this.ejbModule, (Children)children, MethodsNode.ViewType.LOCAL);
            n.setIconBaseWithExtension("org/netbeans/modules/j2ee/ejbcore/resources/LocalMethodContainerIcon.gif");
            n.setDisplayName(NbBundle.getMessage(EjbViewController.class, (String)"LBL_LocalMethods"));
            return new Node[]{n};
        }
        if (key == KEY.REMOTE) {
            MethodChildren children = new MethodChildren(this.cpInfo, this.ejbModule, this.controller, this.model, this.controller.getRemoteInterfaces(), false, this.ejbModule.getDeploymentDescriptor());
            MethodsNode n = new MethodsNode(this.ejbClass, this.ejbModule, (Children)children, MethodsNode.ViewType.REMOTE);
            n.setIconBaseWithExtension("org/netbeans/modules/j2ee/ejbcore/resources/RemoteMethodContainerIcon.gif");
            n.setDisplayName(NbBundle.getMessage(EjbViewController.class, (String)"LBL_RemoteMethods"));
            return new Node[]{n};
        }
        if (key == KEY.CMP_FIELDS) {
            try {
                CMPFieldsNode n = new CMPFieldsNode(this.controller, this.model, this.ejbModule.getDeploymentDescriptor());
                n.setIconBaseWithExtension("org/netbeans/modules/j2ee/ejbcore/resources/CMFieldContainerIcon.gif");
                n.setDisplayName(NbBundle.getMessage(EntityChildren.class, (String)"LBL_CMPFields"));
                return new Node[]{n};
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    EntityChildren.this.updateKeys();
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
        });
    }

    protected static enum KEY {
        REMOTE,
        LOCAL,
        CMP_FIELDS;

    }
}

