/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ejb.wizard.session;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.J2eeProjectCapabilities;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.session.SessionEJBWizardPanel;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.session.TimerOptions;
import org.netbeans.modules.j2ee.ejbcore.naming.EJBNameOptions;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class SessionEJBWizardDescriptor
implements WizardDescriptor.FinishablePanel,
ChangeListener {
    private SessionEJBWizardPanel wizardPanel;
    private final EJBNameOptions ejbNames;
    private final Project project;
    private final TimerOptions timerOptions;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private WizardDescriptor wizardDescriptor;

    public SessionEJBWizardDescriptor(Project project, TimerOptions timerOptions) {
        this.ejbNames = new EJBNameOptions();
        this.timerOptions = timerOptions;
        this.project = project;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public Component getComponent() {
        if (this.wizardPanel == null) {
            this.wizardPanel = new SessionEJBWizardPanel(this.project, this, this.timerOptions);
        }
        return this.wizardPanel;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(SessionEJBWizardDescriptor.class);
    }

    public boolean isValid() {
        if (this.wizardDescriptor == null) {
            return true;
        }
        boolean isLocal = this.wizardPanel.isLocal();
        boolean isRemote = this.wizardPanel.isRemote();
        if (!(isLocal || isRemote || J2eeProjectCapabilities.forProject((Project)this.project).isEjb31LiteSupported())) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(SessionEJBWizardDescriptor.class, (String)"ERR_RemoteOrLocal_MustBeSelected"));
            return false;
        }
        if (isRemote && this.wizardPanel.getRemoteInterfaceProject() == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)(SessionEJBWizardPanel.isMaven(this.project) ? NbBundle.getMessage(SessionEJBWizardDescriptor.class, (String)"ERR_NoRemoteInterfaceProjectMaven") : NbBundle.getMessage(SessionEJBWizardDescriptor.class, (String)"ERR_NoRemoteInterfaceProject")));
            return false;
        }
        FileObject targetFolder = (FileObject)this.wizardDescriptor.getProperty("MultiTargetChooserPanel.TARGET_FOLDER");
        if (targetFolder != null) {
            String targetName = (String)this.wizardDescriptor.getProperty("MultiTargetChooserPanel.TARGET_NAME");
            ArrayList<String> proposedNames = new ArrayList<String>();
            proposedNames.add(this.ejbNames.getSessionEjbClassPrefix() + targetName + this.ejbNames.getSessionEjbClassSuffix());
            if (isLocal) {
                proposedNames.add(this.ejbNames.getSessionLocalPrefix() + targetName + this.ejbNames.getSessionLocalSuffix());
                proposedNames.add(this.ejbNames.getSessionLocalHomePrefix() + targetName + this.ejbNames.getSessionLocalHomeSuffix());
            }
            if (isRemote) {
                proposedNames.add(this.ejbNames.getSessionRemotePrefix() + targetName + this.ejbNames.getSessionRemoteSuffix());
                proposedNames.add(this.ejbNames.getSessionRemoteHomePrefix() + targetName + this.ejbNames.getSessionRemoteHomeSuffix());
            }
            for (String name : proposedNames) {
                if (targetFolder.getFileObject(name + ".java") == null) continue;
                this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(SessionEJBWizardDescriptor.class, (String)"ERR_FileAlreadyExists", (Object)(name + ".java")));
                return false;
            }
        }
        if (isRemote && this.hasCyclicDependency(this.wizardPanel.getRemoteInterfaceProject())) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(SessionEJBWizardDescriptor.class, (String)"ERR_CyclicDependency"));
            return false;
        }
        String timerOptionsError = this.wizardPanel.getTimerOptionsError();
        if (timerOptionsError != null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)timerOptionsError);
            return false;
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)" ");
        return true;
    }

    public void readSettings(Object settings) {
        this.wizardDescriptor = (WizardDescriptor)settings;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void storeSettings(Object settings) {
    }

    public boolean hasRemote() {
        return this.wizardPanel.isRemote();
    }

    public boolean hasLocal() {
        return this.wizardPanel.isLocal();
    }

    public Project getRemoteInterfaceProject() {
        if (this.hasRemote() && !this.wizardPanel.getRemoteInterfaceProject().equals(this.project)) {
            return this.wizardPanel.getRemoteInterfaceProject();
        }
        return null;
    }

    public String getSessionType() {
        return this.wizardPanel.getSessionType();
    }

    public TimerOptions getTimerOptions() {
        return this.wizardPanel.getTimerOptions();
    }

    public boolean exposeTimerMethod() {
        return this.wizardPanel.exposeTimerMethod();
    }

    public boolean isFinishPanel() {
        return this.isValid();
    }

    protected final void fireChangeEvent() {
        this.changeSupport.fireChange();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChangeEvent();
    }

    private boolean hasCyclicDependency(Project projectToCheck) {
        if (projectToCheck == null) {
            return false;
        }
        SubprojectProvider subprojectProvider = (SubprojectProvider)projectToCheck.getLookup().lookup(SubprojectProvider.class);
        if (subprojectProvider != null) {
            Set subprojects = subprojectProvider.getSubprojects();
            if (subprojects.contains(this.project)) {
                return true;
            }
            for (Project subproject : subprojects) {
                if (!this.hasCyclicDependency(subproject)) continue;
                return true;
            }
        }
        return false;
    }
}

