/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.api.methodcontroller;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.common.method.MethodModel;
import org.netbeans.modules.j2ee.common.method.MethodModelSupport;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.j2ee.ejbcore.Utils;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EjbMethodController;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.MethodType;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public abstract class AbstractMethodController
extends EjbMethodController {
    private static final int LOCAL = 0;
    private static final int REMOTE = 1;
    private static final int LOCAL_HOME = 2;
    private static final int REMOTE_HOME = 3;
    private final String ejbClass;
    private final MetadataModel<EjbJarMetadata> model;
    protected Set classesForSave;
    private final boolean simplified;
    private final String local;
    private final String remote;
    private final String localHome;
    private final String remoteHome;

    public AbstractMethodController(final String ejbClass, MetadataModel<EjbJarMetadata> model) {
        this.ejbClass = ejbClass;
        this.model = model;
        final String[] results = new String[4];
        BigDecimal version = null;
        try {
            version = (BigDecimal)model.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, BigDecimal>(){

                public BigDecimal run(EjbJarMetadata metadata) throws Exception {
                    EntityAndSession model = (EntityAndSession)metadata.findByEjbClass(ejbClass);
                    if (model != null) {
                        results[0] = model.getLocal();
                        results[1] = model.getRemote();
                        results[2] = model.getLocalHome();
                        results[3] = model.getHome();
                    }
                    return metadata.getRoot().getVersion();
                }
            });
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        this.simplified = version == null ? true : version.doubleValue() > 2.1;
        this.local = results[0];
        this.remote = results[1];
        this.localHome = results[2];
        this.remoteHome = results[3];
    }

    public abstract GenerateFromImpl createGenerateFromImpl();

    public abstract GenerateFromIntf createGenerateFromIntf();

    @Override
    public final MethodModel createAndAdd(MethodModel clientView, boolean isLocal, boolean isComponent) {
        String home = null;
        String component = null;
        if (isLocal) {
            home = this.localHome;
            component = this.findBusinessInterface(this.local);
        } else {
            home = this.remoteHome;
            component = this.findBusinessInterface(this.remote);
        }
        if (isComponent) {
            try {
                this.addMethodToClass(component, clientView);
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        } else {
            try {
                this.addMethodToClass(home, clientView);
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        if (this.hasJavaImplementation(clientView)) {
            for (MethodModel me : this.getImplementationMethods(clientView)) {
                try {
                    if (this.findInClass(this.ejbClass, me)) continue;
                    this.addMethodToClass(this.ejbClass, me);
                }
                catch (IOException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        }
        MethodModel result = clientView;
        if (!isLocal && !this.simplified) {
            result = this.addExceptionIfNecessary(clientView, RemoteException.class.getName());
        }
        return result;
    }

    @Override
    public final void createAndAddInterface(MethodModel beanImpl, boolean isLocal) {
        MethodType methodType = this.getMethodTypeFromImpl(beanImpl);
        GenerateFromImpl generateFromImpl = this.createGenerateFromImpl();
        String home = null;
        String component = null;
        if (isLocal) {
            home = this.localHome;
            component = this.findBusinessInterface(this.local);
        } else {
            home = this.remoteHome;
            component = this.findBusinessInterface(this.remote);
        }
        generateFromImpl.getInterfaceMethodFromImpl(methodType, home, component);
        MethodModel method = generateFromImpl.getInterfaceMethod();
        if (!isLocal && !this.simplified) {
            method = this.addExceptionIfNecessary(method, RemoteException.class.getName());
        }
        method = MethodModel.create((String)method.getName(), (String)method.getReturnType(), (String)method.getBody(), (List)method.getParameters(), (List)method.getExceptions(), Collections.emptySet());
        String destinationInterface = generateFromImpl.getDestinationInterface();
        try {
            this.addMethodToClass(destinationInterface, method);
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    @Override
    public final void createAndAddImpl(MethodModel intfView) {
        MethodType methodType = this.getMethodTypeFromInterface(intfView);
        GenerateFromIntf generateFromIntf = this.createGenerateFromIntf();
        generateFromIntf.getInterfaceMethodFromImpl(methodType);
        MethodModel method = generateFromIntf.getImplMethod();
        try {
            this.addMethodToClass(this.ejbClass, method);
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    private List<MethodModel> getImplementationMethods(MethodModel intfView) {
        MethodType methodType = this.getMethodTypeFromInterface(intfView);
        GenerateFromIntf generateFromIntf = this.createGenerateFromIntf();
        generateFromIntf.getInterfaceMethodFromImpl(methodType);
        MethodModel primary = generateFromIntf.getImplMethod();
        MethodModel secondary = generateFromIntf.getSecondaryMethod();
        List<MethodModel> methods = null;
        methods = secondary != null ? Arrays.asList(primary, secondary) : Collections.singletonList(primary);
        return methods;
    }

    @Override
    public final List<MethodModel> getImplementation(MethodModel intfView) {
        List<MethodModel> methods = this.getImplementationMethods(intfView);
        ArrayList<MethodModel> result = new ArrayList<MethodModel>(methods.size());
        for (MethodModel method : methods) {
            boolean exists = this.findInClass(this.getBeanClass(), method);
            if (!exists) continue;
            result.add(method);
        }
        return result;
    }

    @Override
    public final EjbMethodController.ClassMethodPair getInterface(MethodModel beanImpl, boolean isLocal) {
        MethodType methodType = this.getMethodTypeFromImpl(beanImpl);
        assert (methodType != null) : "method cannot be used in interface";
        GenerateFromImpl generateFromImpl = this.createGenerateFromImpl();
        String home = null;
        String component = null;
        if (isLocal) {
            home = this.localHome;
            component = this.findBusinessInterface(this.local);
        } else {
            home = this.remoteHome;
            component = this.findBusinessInterface(this.remote);
        }
        generateFromImpl.getInterfaceMethodFromImpl(methodType, home, component);
        MethodModel interfaceMethodModel = generateFromImpl.getInterfaceMethod();
        String destinationInterface = generateFromImpl.getDestinationInterface();
        boolean exists = this.findInClass(destinationInterface, interfaceMethodModel);
        return exists ? new EjbMethodController.ClassMethodPair(destinationInterface, interfaceMethodModel) : null;
    }

    @Override
    public boolean hasMethodInInterface(MethodModel method, MethodType methodType, boolean isLocal) {
        String intf = null;
        MethodModel methodCopy = method;
        if (methodType.getKind() == MethodType.Kind.BUSINESS) {
            intf = this.findBusinessInterface(isLocal ? this.local : this.remote);
        } else if (methodType.getKind() == MethodType.Kind.CREATE) {
            String name = this.chopAndUpper(methodCopy.getName(), "ejb");
            String type = isLocal ? this.local : this.remote;
            methodCopy = MethodModel.create((String)name, (String)type, (String)methodCopy.getBody(), (List)methodCopy.getParameters(), (List)methodCopy.getExceptions(), (Set)methodCopy.getModifiers());
            String string = intf = isLocal ? this.localHome : this.remoteHome;
        }
        if (methodCopy.getName() == null || intf == null || methodCopy.getReturnType() == null) {
            return true;
        }
        return this.findInClass(intf, methodCopy);
    }

    private String chopAndUpper(String fullName, String chop) {
        StringBuffer stringBuffer = new StringBuffer(fullName);
        stringBuffer.delete(0, chop.length());
        stringBuffer.setCharAt(0, Character.toLowerCase(stringBuffer.charAt(0)));
        return stringBuffer.toString();
    }

    private MethodModel addExceptionIfNecessary(MethodModel method, String exceptionName) {
        if (!method.getExceptions().contains(exceptionName)) {
            ArrayList<String> exceptions = new ArrayList<String>(method.getExceptions());
            exceptions.add(exceptionName);
            return MethodModel.create((String)method.getName(), (String)method.getReturnType(), (String)method.getBody(), (List)method.getParameters(), exceptions, (Set)method.getModifiers());
        }
        return method;
    }

    private String findBusinessInterface(String compInterfaceName) {
        if (compInterfaceName == null || this.ejbClass == null) {
            return null;
        }
        List<Object> beanInterfaces = new ArrayList();
        try {
            beanInterfaces = this.getInterfaces(this.ejbClass);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        List<Object> compInterfaces = new ArrayList();
        try {
            compInterfaces = this.getInterfaces(compInterfaceName);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        compInterfaces.retainAll(beanInterfaces);
        if (compInterfaces.isEmpty()) {
            return compInterfaceName;
        }
        String business = (String)compInterfaces.get(0);
        return business == null ? compInterfaceName : business;
    }

    private List<String> getInterfaces(final String className) throws IOException {
        FileObject ejbClassFO = (FileObject)this.model.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, FileObject>(){

            public FileObject run(EjbJarMetadata metadata) throws Exception {
                return metadata.findResource(Utils.toResourceName(AbstractMethodController.this.ejbClass));
            }
        });
        final ArrayList<String> result = new ArrayList<String>();
        if (ejbClassFO != null) {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)ejbClassFO);
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController controller) throws IOException {
                        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TypeElement typeElement = controller.getElements().getTypeElement(className);
                        if (typeElement != null) {
                            Types types = controller.getTypes();
                            for (TypeMirror typeMirror : typeElement.getInterfaces()) {
                                Element element = types.asElement(typeMirror);
                                String interfaceFqn = ((TypeElement)element).getQualifiedName().toString();
                                result.add(interfaceFqn);
                            }
                        }
                    }
                }, true);
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        return result;
    }

    @Override
    public final String getBeanClass() {
        return this.ejbClass;
    }

    public final List<String> getBeanSuperclasses() {
        final ArrayList<String> result = new ArrayList<String>();
        result.add(this.ejbClass);
        FileObject ejbClassFO = null;
        try {
            ejbClassFO = (FileObject)this.model.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, FileObject>(){

                public FileObject run(EjbJarMetadata metadata) throws Exception {
                    return metadata.findResource(Utils.toResourceName(AbstractMethodController.this.ejbClass));
                }
            });
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        if (ejbClassFO != null) {
            JavaSource javaSource = JavaSource.forFileObject(ejbClassFO);
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController controller) throws IOException {
                        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        Types types = controller.getTypes();
                        TypeElement typeElement = controller.getElements().getTypeElement(AbstractMethodController.this.ejbClass);
                        if (typeElement != null) {
                            TypeMirror superCls = typeElement.getSuperclass();
                            TypeMirror objectCls = controller.getElements().getTypeElement("java.lang.Object").asType();
                            while (superCls != null && superCls instanceof DeclaredType && !types.isSameType(superCls, objectCls)) {
                                TypeElement superElem = (TypeElement)((DeclaredType)superCls).asElement();
                                result.add(superElem.getQualifiedName().toString());
                                superCls = superElem.getSuperclass();
                            }
                        }
                    }
                }, true);
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        return result;
    }

    public final List<String> getLocalInterfaces() {
        if (!this.hasLocal()) {
            return Collections.emptyList();
        }
        ArrayList<String> resultList = new ArrayList<String>(2);
        if (this.localHome != null) {
            resultList.add(this.localHome);
        }
        if (this.local != null) {
            resultList.add(this.findBusinessInterface(this.local));
        }
        return resultList;
    }

    public final List<String> getRemoteInterfaces() {
        if (!this.hasRemote()) {
            return Collections.emptyList();
        }
        ArrayList<String> resultList = new ArrayList<String>(2);
        if (this.remoteHome != null) {
            resultList.add(this.remoteHome);
        }
        if (this.remote != null) {
            resultList.add(this.findBusinessInterface(this.remote));
        }
        return resultList;
    }

    @Override
    public final void delete(MethodModel classMethod) {
        EjbMethodController.ClassMethodPair classMethodPair_remote;
        EjbMethodController.ClassMethodPair classMethodPair_local;
        if (this.hasLocal() && (classMethodPair_local = this.getInterface(classMethod, true)) != null) {
            try {
                this.removeMethodFromClass(classMethodPair_local.getClassName(), classMethodPair_local.getMethodModel());
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        if (this.hasRemote() && (classMethodPair_remote = this.getInterface(classMethod, false)) != null) {
            try {
                this.removeMethodFromClass(classMethodPair_remote.getClassName(), classMethodPair_remote.getMethodModel());
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        try {
            this.removeMethodFromClass(this.getBeanClass(), classMethod);
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    @Override
    public final void delete(MethodModel interfaceMethod, boolean local) {
        boolean checkOther;
        List<MethodModel> impls = this.getImplementation(interfaceMethod);
        boolean bl = checkOther = local ? this.hasRemote() : this.hasLocal();
        if (!impls.isEmpty()) {
            for (MethodModel impl : impls) {
                if (impl == null) continue;
                EjbMethodController.ClassMethodPair classMethodPair = this.getInterface(impl, local);
                if ((!checkOther || classMethodPair != null) && checkOther) continue;
                try {
                    this.removeMethodFromClass(classMethodPair.getClassName(), classMethodPair.getMethodModel());
                }
                catch (IOException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
            try {
                this.removeMethodFromClass(this.getBeanClass(), interfaceMethod);
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    @Override
    public boolean hasRemote() {
        String intf = this.remoteHome;
        if (!this.simplified && intf == null) {
            return false;
        }
        intf = this.remote;
        return intf != null && this.findBusinessInterface(intf) != null;
    }

    @Override
    public boolean hasLocal() {
        String intf = this.localHome;
        if (!this.simplified && intf == null) {
            return false;
        }
        intf = this.local;
        return intf != null && this.findBusinessInterface(intf) != null;
    }

    @Override
    public MethodModel getPrimaryImplementation(MethodModel intfView) {
        List<MethodModel> impls = this.getImplementation(intfView);
        return impls.isEmpty() ? null : impls.get(0);
    }

    @Override
    public String getRemote() {
        return this.remote;
    }

    @Override
    public String getLocal() {
        return this.local;
    }

    public String getLocalHome() {
        return this.localHome;
    }

    public String getHome() {
        return this.remoteHome;
    }

    protected boolean isSimplified() {
        return this.simplified;
    }

    public String getBeanInterface(boolean isLocal, boolean isComponent) {
        if (isComponent) {
            return this.findBusinessInterface(isLocal ? this.local : this.remote);
        }
        String className = isLocal ? this.localHome : this.remoteHome;
        return className;
    }

    private void createBeanMethod(MethodModel method) throws IOException {
        if (this.hasJavaImplementation(method)) {
            List<MethodModel> implMethods = this.getImplementationMethods(method);
            for (MethodModel me : implMethods) {
                if (this.findInClass(this.ejbClass, me)) continue;
                this.addMethodToClass(this.ejbClass, method);
            }
        }
    }

    public final void removeMethod(MethodModel method, boolean local, boolean isComponent) {
        String clazz = this.getBeanInterface(local, isComponent);
        MethodModel methodCopy = method;
        assert (clazz != null);
        if (!local) {
            methodCopy = this.addExceptionIfNecessary(methodCopy, RemoteException.class.getName());
        }
        try {
            this.removeMethodFromClass(clazz, methodCopy);
            this.createBeanMethod(methodCopy);
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    protected boolean findInClass(final String clazz, final MethodModel methodModel) {
        if (clazz == null) {
            return false;
        }
        try {
            FileObject ejbClassFO = (FileObject)this.model.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, FileObject>(){

                public FileObject run(EjbJarMetadata metadata) throws Exception {
                    return metadata.findResource(Utils.toResourceName(AbstractMethodController.this.ejbClass));
                }
            });
            final boolean[] result = new boolean[]{false};
            JavaSource javaSource = JavaSource.forFileObject((FileObject)ejbClassFO);
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    result[0] = AbstractMethodController.this.methodFindInClass(controller, clazz, methodModel) != null;
                }
            }, true);
            return result[0];
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
            return false;
        }
    }

    private ExecutableElement methodFindInClass(CompilationController controller, String clazz, MethodModel methodModel) throws IOException {
        TypeElement typeElement = controller.getElements().getTypeElement(clazz);
        if (typeElement != null) {
            for (ExecutableElement method : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                if (!MethodModelSupport.isSameMethod((CompilationController)controller, (ExecutableElement)method, (MethodModel)methodModel)) continue;
                return method;
            }
        }
        return null;
    }

    protected void addMethodToClass(final String className, final MethodModel method) throws IOException {
        FileObject fileObject = (FileObject)this.model.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, FileObject>(){

            public FileObject run(EjbJarMetadata metadata) throws Exception {
                return metadata.findResource(Utils.toResourceName(className));
            }
        });
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                Trees trees = workingCopy.getTrees();
                TypeElement clazz = workingCopy.getElements().getTypeElement(className);
                ClassTree classTree = trees.getTree(clazz);
                MethodTree methodTree = MethodModelSupport.createMethodTree((WorkingCopy)workingCopy, (MethodModel)method);
                ClassTree modifiedClassTree = workingCopy.getTreeMaker().addClassMember(classTree, (Tree)methodTree);
                workingCopy.rewrite((Tree)classTree, (Tree)modifiedClassTree);
            }
        }).commit();
    }

    protected void removeMethodFromClass(final String className, final MethodModel methodModel) throws IOException {
        FileObject fileObject = (FileObject)this.model.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, FileObject>(){

            public FileObject run(EjbJarMetadata metadata) throws Exception {
                return metadata.findResource(Utils.toResourceName(className));
            }
        });
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ExecutableElement method = AbstractMethodController.this.methodFindInClass((CompilationController)workingCopy, className, methodModel);
                if (method != null) {
                    TypeElement foundClass = workingCopy.getElements().getTypeElement(className);
                    Trees trees = workingCopy.getTrees();
                    ClassTree classTree = trees.getTree(foundClass);
                    MethodTree methodTree = trees.getTree(method);
                    ClassTree modifiedClassTree = workingCopy.getTreeMaker().removeClassMember(classTree, (Tree)methodTree);
                    workingCopy.rewrite((Tree)classTree, (Tree)modifiedClassTree);
                }
            }
        }).commit();
    }

    public static interface GenerateFromIntf {
        public void getInterfaceMethodFromImpl(MethodType var1);

        public MethodModel getImplMethod();

        public MethodModel getSecondaryMethod();
    }

    public static interface GenerateFromImpl {
        public void getInterfaceMethodFromImpl(MethodType var1, String var2, String var3);

        public String getDestinationInterface();

        public MethodModel getInterfaceMethod();
    }
}

