/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.api.codegeneration;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.naming.NamingException;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceContainer;
import org.netbeans.modules.j2ee.common.J2eeProjectCapabilities;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.common.method.MethodModel;
import org.netbeans.modules.j2ee.common.method.MethodModelSupport;
import org.netbeans.modules.j2ee.common.queries.api.InjectionTargetQuery;
import org.netbeans.modules.j2ee.core.api.support.classpath.ContainerClassPathModifier;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.MessageDriven;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.Utils;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries.ServiceLocatorStrategy;
import org.netbeans.modules.j2ee.ejbcore.util._RetoucheUtil;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class CallEjbGenerator {
    private final EjbReference ejbReference;
    private final String ejbReferenceName;
    private final boolean isDefaultRefName;
    private final boolean isSimplified;
    private final boolean isSession;
    private String ejbName;
    private static final String LOG_STATEMENT = "java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,\"exception caught\" ,{0});\n";
    private static final String JNDI_LOOKUP_LOCAL = "javax.naming.Context c = new javax.naming.InitialContext();\n{1} rv = ({1}) c.lookup(\"java:comp/env/{0}\");\nreturn rv{2};\n";
    private static final String JNDI_LOOKUP_REMOTE = "javax.naming.Context c = new javax.naming.InitialContext();\nObject remote = c.lookup(\"java:comp/env/{0}\");\n{1} rv = ({1}) javax.rmi.PortableRemoteObject.narrow(remote, {1}.class);\nreturn rv{2};\n";
    private static final String JNDI_LOOKUP_REMOTE_JAVASE = "javax.naming.Context c = new javax.naming.InitialContext();\nObject remote = c.lookup(\"{0}\");\n{1} rv = ({1}) javax.rmi.PortableRemoteObject.narrow(remote, {1}.class);\nreturn rv{2};\n";
    private static final String JNDI_LOOKUP_EJB3 = "javax.naming.Context c = new javax.naming.InitialContext();\nreturn ({1}) c.lookup(\"java:comp/env/{0}\");\n";
    private static final String JNDI_LOOKUP_GLOBAL = "javax.naming.Context c = new javax.naming.InitialContext();\nreturn ({2}) c.lookup(\"java:global/{0}/{1}!{2}\");\n";
    private static final String JNDI_LOOKUP_EJB3_JAVASE = "javax.naming.Context c = new javax.naming.InitialContext();\nreturn ({1}) c.lookup(\"{0}\");\n";
    private static final String JNDI_LOOKUP_EJB3_JAVAEE5 = "try '{'\n    {0} = {1}.create();\n'}' catch(Exception e) '{'\n    throw new javax.ejb.EJBException(e);\n'}'\n";

    private CallEjbGenerator(final EjbReference ejbReference, String ejbReferenceName, boolean isDefaultRefName) {
        this.ejbReference = ejbReference;
        Object[] result = new Object[]{Boolean.FALSE, null, null};
        try {
            MetadataModel metadataModel = ejbReference.getEjbModule().getMetadataModel();
            result = (Object[])metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Object[]>(){

                public Object[] run(EjbJarMetadata metadata) throws Exception {
                    Ejb ejb = metadata.findByEjbClass(ejbReference.getEjbClass());
                    return new Object[]{ejb instanceof Session, metadata.getRoot().getVersion(), ejb != null ? ejb.getEjbName() : null};
                }
            });
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        this.isDefaultRefName = isDefaultRefName;
        this.isSimplified = result[1] == null ? true : ((BigDecimal)result[1]).doubleValue() > 2.1;
        this.isSession = (Boolean)result[0];
        this.ejbName = (String)result[2];
        this.ejbReferenceName = ejbReferenceName != null ? ejbReferenceName : this.ejbName;
    }

    public static CallEjbGenerator create(EjbReference ejbReference, String ejbReferenceName, boolean isDefaultRefName) {
        return new CallEjbGenerator(ejbReference, ejbReferenceName, isDefaultRefName);
    }

    public ElementHandle<? extends Element> addReference(FileObject referencingFO, String referencingClassName, FileObject referencedFO, String referencedClassName, String serviceLocator, EjbReference.EjbRefIType refIType, boolean throwExceptions, Project nodeProject) throws IOException {
        Object result = null;
        Project enterpriseProject = FileOwnerQuery.getOwner((FileObject)referencingFO);
        EnterpriseReferenceContainer erc = (EnterpriseReferenceContainer)enterpriseProject.getLookup().lookup(EnterpriseReferenceContainer.class);
        boolean enterpriseProjectIsJavaEE5 = Util.isJavaEE5orHigher((Project)enterpriseProject);
        boolean nodeProjectIsJavaEE5 = Util.isJavaEE5orHigher((Project)nodeProject);
        ContainerClassPathModifier ccpm = (ContainerClassPathModifier)enterpriseProject.getLookup().lookup(ContainerClassPathModifier.class);
        if (ccpm != null) {
            ccpm.extendClasspath(referencingFO, new String[]{"ejb"});
        }
        if (enterpriseProjectIsJavaEE5 && InjectionTargetQuery.isInjectionTarget((FileObject)referencingFO, (String)referencingClassName)) {
            CallEjbGenerator.addProjectToClassPath(enterpriseProject, this.ejbReference, referencingFO, refIType);
        } else if (nodeProjectIsJavaEE5 == enterpriseProjectIsJavaEE5) {
            switch (refIType) {
                case REMOTE: {
                    erc.addEjbReference(this.ejbReference, refIType, this.ejbReferenceName, referencingFO, referencingClassName);
                    break;
                }
                case NO_INTERFACE: 
                case LOCAL: {
                    erc.addEjbLocalReference(this.ejbReference, refIType, this.ejbReferenceName, referencingFO, referencingClassName);
                }
            }
        }
        if (serviceLocator == null) {
            boolean isEE6 = J2eeProjectCapabilities.forProject((Project)enterpriseProject).isEjb31LiteSupported();
            result = this.generateReferenceCode(referencingFO, referencingClassName, refIType, throwExceptions, !nodeProjectIsJavaEE5, isEE6, nodeProject);
        } else {
            result = this.generateServiceLocatorLookup(referencingFO, referencingClassName, serviceLocator, refIType, throwExceptions);
        }
        if (serviceLocator != null) {
            erc.setServiceLocatorName(serviceLocator);
        }
        if (refIType == EjbReference.EjbRefIType.REMOTE) {
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)enterpriseProject.getLookup().lookup(J2eeModuleProvider.class);
            String referencedEjbName = CallEjbGenerator.getEjbName(referencedFO, referencedClassName);
            try {
                if (referencedClassName != null && j2eeModuleProvider.getJ2eeModule().getType().equals(J2eeModule.Type.WAR)) {
                    j2eeModuleProvider.getConfigSupport().bindEjbReference(this.ejbReferenceName, referencedEjbName);
                } else if (j2eeModuleProvider.getJ2eeModule().getType().equals(J2eeModule.Type.EJB)) {
                    String ejbName = CallEjbGenerator.getEjbName(referencingFO, referencingClassName);
                    String ejbType = CallEjbGenerator.getEjbType(referencingFO, referencingClassName);
                    if (ejbName != null && ejbType != null) {
                        j2eeModuleProvider.getConfigSupport().bindEjbReferenceForEjb(ejbName, ejbType, this.ejbReferenceName, referencedEjbName);
                    }
                }
            }
            catch (ConfigurationException ce) {
                Logger.getLogger("global").log(Level.WARNING, null, ce);
            }
        }
        return result;
    }

    private ElementHandle<ExecutableElement> generateServiceLocatorLookup(FileObject referencingFO, String referencingClassName, String serviceLocatorName, EjbReference.EjbRefIType refIType, boolean throwExceptions) {
        try {
            return this.generateServiceLocatorJNDI(referencingFO, referencingClassName, this.ejbReference.getHomeName(refIType), this.ejbReferenceName, refIType != EjbReference.EjbRefIType.LOCAL, this.ejbReference.getComponentName(refIType), throwExceptions, serviceLocatorName);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
            return null;
        }
    }

    private ElementHandle<? extends Element> generateReferenceCode(FileObject fileObject, String className, EjbReference.EjbRefIType refIType, boolean throwExceptions, boolean isTargetEjb2x, boolean generateGlobalJNDI, Project ejbProject) {
        Object result = null;
        try {
            result = !(!InjectionTargetQuery.isInjectionTarget((FileObject)fileObject, (String)className) || Utils.getBeanType(this.ejbReference).equals("Stateful") && Utils.isServlet(fileObject, className)) ? (isTargetEjb2x ? this.generateInjectionEjb21FromEE5(fileObject, className, this.ejbReference.getHomeName(refIType), this.ejbReference.getComponentName(refIType)) : this.generateInjection(fileObject, className, this.ejbReference.getComponentName(refIType))) : this.generateJNDI(fileObject, className, throwExceptions, refIType, generateGlobalJNDI, ejbProject);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        return result;
    }

    private ElementHandle<VariableElement> generateInjection(FileObject fileObject, String className, String fieldTypeClass) throws IOException {
        String strippedRefName = this.ejbReferenceName.substring(this.ejbReferenceName.lastIndexOf(47) + 1);
        String name = Character.toLowerCase(strippedRefName.charAt(0)) + strippedRefName.substring(1);
        return _RetoucheUtil.generateAnnotatedField(fileObject, className, "javax.ejb.EJB", _RetoucheUtil.uniqueMemberName(fileObject, className, name, "ejb"), fieldTypeClass, this.isDefaultRefName ? null : Collections.singletonMap("name", strippedRefName), InjectionTargetQuery.isStaticReferenceRequired((FileObject)fileObject, (String)className));
    }

    private ElementHandle<VariableElement> generateInjectionEjb21FromEE5(FileObject fileObject, final String className, String homeName, final String componentName) throws IOException {
        String strippedRefName = this.ejbReferenceName.substring(this.ejbReferenceName.lastIndexOf(47) + 1);
        final String name = Character.toLowerCase(strippedRefName.charAt(0)) + strippedRefName.substring(1);
        String strippedHomeName = homeName.substring(homeName.lastIndexOf(46) + 1);
        final String homeFieldName = Character.toLowerCase(strippedHomeName.charAt(0)) + strippedHomeName.substring(1);
        ElementHandle<VariableElement> elementToOpen = _RetoucheUtil.generateAnnotatedField(fileObject, className, "javax.ejb.EJB", _RetoucheUtil.uniqueMemberName(fileObject, className, homeFieldName, "ejb"), homeName, this.isDefaultRefName ? null : Collections.singletonMap("name", strippedRefName), InjectionTargetQuery.isStaticReferenceRequired((FileObject)fileObject, (String)className));
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TreeMaker treeMaker = workingCopy.getTreeMaker();
                TypeElement callerTypeElement = workingCopy.getElements().getTypeElement(className);
                TypeElement componentTypeElement = workingCopy.getElements().getTypeElement(componentName);
                VariableTree variableTree = treeMaker.Variable(treeMaker.Modifiers(Collections.singleton(Modifier.PRIVATE)), (CharSequence)name, (Tree)treeMaker.QualIdent((Element)componentTypeElement), null);
                ClassTree classTree = workingCopy.getTrees().getTree(callerTypeElement);
                ClassTree newClassTree = treeMaker.insertClassMember(classTree, 2, (Tree)variableTree);
                ModifiersTree modifiersTree = treeMaker.Modifiers(Collections.singleton(Modifier.PRIVATE));
                AnnotationTree annotationTree = GenerationUtils.newInstance((WorkingCopy)workingCopy).createAnnotation("javax.annotation.PostConstruct");
                modifiersTree = treeMaker.addModifiersAnnotation(modifiersTree, annotationTree);
                MethodTree methodTree = treeMaker.Method(modifiersTree, (CharSequence)"initialize", (Tree)treeMaker.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), '{' + MessageFormat.format(CallEjbGenerator.JNDI_LOOKUP_EJB3_JAVAEE5, name, homeFieldName) + '}', null);
                methodTree = (MethodTree)GeneratorUtilities.get((WorkingCopy)workingCopy).importFQNs((Tree)methodTree);
                newClassTree = treeMaker.insertClassMember(newClassTree, 3, (Tree)methodTree);
                workingCopy.rewrite((Tree)classTree, (Tree)newClassTree);
            }
        }).commit();
        return elementToOpen;
    }

    private ElementHandle<ExecutableElement> generateJNDI(final FileObject fileObject, final String className, boolean throwCheckedExceptions, EjbReference.EjbRefIType refIType, final boolean global, Project ejbProject) throws IOException {
        String name = "lookup" + this.ejbName + refIType;
        String body = null;
        String componentName = this.ejbReference.getComponentName(refIType);
        String homeName = this.ejbReference.getHomeName(refIType);
        boolean isLocal = !refIType.equals((Object)EjbReference.EjbRefIType.REMOTE);
        List<String> exceptions = new ArrayList<String>();
        boolean isTargetJavaSE = Utils.isTargetJavaSE(fileObject, className);
        String sessionCreate = "";
        if (this.isSession) {
            sessionCreate = ".create()";
        }
        if (global) {
            String moduleFullName = ProjectUtils.getInformation((Project)ejbProject).getName();
            Project j2eeAppProject = Utils.getNestingJ2eeApp(ejbProject);
            if (j2eeAppProject != null && !j2eeAppProject.equals(ejbProject)) {
                moduleFullName = ProjectUtils.getInformation((Project)j2eeAppProject).getName() + "/" + moduleFullName;
            }
            body = MessageFormat.format(JNDI_LOOKUP_GLOBAL, moduleFullName, this.ejbName, componentName);
        } else {
            body = this.isSimplified && isTargetJavaSE ? MessageFormat.format(JNDI_LOOKUP_EJB3_JAVASE, this.ejbReference.getEjbClass(), componentName) : (this.isSimplified ? MessageFormat.format(JNDI_LOOKUP_EJB3, this.ejbReferenceName, componentName) : (isTargetJavaSE ? MessageFormat.format(JNDI_LOOKUP_REMOTE_JAVASE, homeName, homeName, sessionCreate) : (!isLocal ? MessageFormat.format(JNDI_LOOKUP_REMOTE, this.ejbReferenceName, homeName, sessionCreate) : MessageFormat.format(JNDI_LOOKUP_LOCAL, this.ejbReferenceName, homeName, sessionCreate))));
        }
        String returnType = this.isSimplified ? componentName : homeName;
        exceptions.add(NamingException.class.getName());
        if (this.isSession) {
            returnType = componentName;
            if (!this.isSimplified) {
                exceptions.add("javax.ejb.CreateException");
            }
            if (!this.isSimplified && !isLocal) {
                exceptions.add("java.rmi.RemoteException");
            }
        }
        if (!throwCheckedExceptions) {
            Iterator exIt = exceptions.iterator();
            StringBuffer catchBody = new StringBuffer("try {\n" + body + "}\n");
            while (exIt.hasNext()) {
                String exceptionName = (String)exIt.next();
                catchBody.append("catch(");
                catchBody.append(exceptionName);
                catchBody.append(' ');
                String capitalLetters = this.extractAllCapitalLetters(exceptionName);
                catchBody.append(capitalLetters);
                catchBody.append(") {\n");
                catchBody.append(MessageFormat.format(LOG_STATEMENT, capitalLetters));
                catchBody.append("throw new RuntimeException(" + capitalLetters + ");\n");
                catchBody.append("}\n");
            }
            body = catchBody.toString();
            exceptions = Collections.emptyList();
        }
        final MethodModel methodModel = MethodModel.create((String)_RetoucheUtil.uniqueMemberName(fileObject, className, name, "ejb"), (String)returnType, (String)body, Collections.emptyList(), exceptions, Collections.singleton(Modifier.PRIVATE));
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = workingCopy.getElements().getTypeElement(className);
                MethodTree methodTree = MethodModelSupport.createMethodTree((WorkingCopy)workingCopy, (MethodModel)methodModel);
                ClassTree classTree = workingCopy.getTrees().getTree(typeElement);
                TreeMaker treeMaker = workingCopy.getTreeMaker();
                ClassTree newClassTree = treeMaker.addClassMember(classTree, (Tree)methodTree);
                if (global) {
                    VariableTree variableTree = treeMaker.Variable(treeMaker.Modifiers(Collections.emptySet()), (CharSequence)_RetoucheUtil.uniqueMemberName(fileObject, className, CallEjbGenerator.this.ejbName, "ejb"), methodTree.getReturnType(), (ExpressionTree)treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.Identifier((CharSequence)methodTree.getName()), Collections.emptyList()));
                    newClassTree = treeMaker.insertClassMember(newClassTree, 0, (Tree)variableTree);
                }
                workingCopy.rewrite((Tree)classTree, (Tree)newClassTree);
            }
        }).commit();
        return _RetoucheUtil.getMethodHandle(javaSource, methodModel, className);
    }

    private ElementHandle<ExecutableElement> generateServiceLocatorJNDI(FileObject referencingFO, final String referencingClassName, String homeName, String refName, boolean narrow, String componentName, boolean throwCheckedExceptions, String serviceLocatorName) throws IOException {
        String name = "lookup" + refName.substring(refName.lastIndexOf(47) + 1);
        String body = null;
        List<String> exceptions = new ArrayList<String>(3);
        exceptions.add(NamingException.class.getName());
        String returnType = this.isSimplified ? componentName : homeName;
        boolean genCreate = this.isSession;
        if (genCreate) {
            returnType = componentName;
            exceptions.add("javax.ejb.CreateException");
            if (narrow) {
                exceptions.add("java.rmi.RemoteException");
            }
        }
        Project enterpriseProject = FileOwnerQuery.getOwner((FileObject)referencingFO);
        ServiceLocatorStrategy sls = ServiceLocatorStrategy.create(enterpriseProject, referencingFO, serviceLocatorName);
        body = narrow ? sls.genRemoteEjbStringLookup(refName, homeName, referencingFO, referencingClassName, genCreate) : sls.genLocalEjbStringLookup(refName, homeName, referencingFO, referencingClassName, genCreate);
        if (!throwCheckedExceptions) {
            Iterator exIt = exceptions.iterator();
            StringBuffer catchBody = new StringBuffer("try {\n" + body + "\n}");
            while (exIt.hasNext()) {
                String exceptionName = (String)exIt.next();
                catchBody.append(" catch(");
                catchBody.append(exceptionName);
                catchBody.append(' ');
                String capitalLetters = this.extractAllCapitalLetters(exceptionName);
                catchBody.append(capitalLetters);
                catchBody.append(") {\n");
                catchBody.append(MessageFormat.format(LOG_STATEMENT, capitalLetters));
                catchBody.append("throw new RuntimeException(" + capitalLetters + ");\n");
                catchBody.append('}');
                body = catchBody.toString();
                exceptions = Collections.emptyList();
            }
        }
        final MethodModel methodModel = MethodModel.create((String)_RetoucheUtil.uniqueMemberName(referencingFO, referencingClassName, name, "ejb"), (String)returnType, (String)body, Collections.emptyList(), exceptions, Collections.singleton(Modifier.PRIVATE));
        JavaSource javaSource = JavaSource.forFileObject((FileObject)referencingFO);
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = workingCopy.getElements().getTypeElement(referencingClassName);
                MethodTree methodTree = MethodModelSupport.createMethodTree((WorkingCopy)workingCopy, (MethodModel)methodModel);
                ClassTree classTree = workingCopy.getTrees().getTree(typeElement);
                ClassTree newClassTree = workingCopy.getTreeMaker().addClassMember(classTree, (Tree)methodTree);
                workingCopy.rewrite((Tree)classTree, (Tree)newClassTree);
            }
        }).commit();
        return _RetoucheUtil.getMethodHandle(javaSource, methodModel, referencingClassName);
    }

    private String extractAllCapitalLetters(String word) {
        StringBuffer caps = new StringBuffer(4);
        for (int i = 0; i < word.length(); ++i) {
            char character = word.charAt(i);
            if (!Character.isUpperCase(character)) continue;
            caps.append(Character.toLowerCase(character));
        }
        return caps.toString();
    }

    private static void addProjectToClassPath(Project enterpriseProject, EjbReference ref, FileObject refFO, EjbReference.EjbRefIType refIType) throws IOException {
        boolean differentProject;
        Project target = Utils.getProject(ref, refIType);
        boolean bl = differentProject = target != null && !enterpriseProject.equals(target);
        if (differentProject) {
            if (CallEjbGenerator.isJEEModule(target)) {
                ProjectClassPathModifier.addProjects((Project[])new Project[]{target}, (FileObject)refFO, (String)"classpath/compile_only");
            } else {
                ProjectClassPathModifier.addProjects((Project[])new Project[]{target}, (FileObject)refFO, (String)"classpath/compile");
            }
        }
    }

    private static boolean isJEEModule(Project target) {
        return target.getLookup().lookup(J2eeModuleProvider.class) != null;
    }

    private static String getEjbName(FileObject fileObject, final String className) throws IOException {
        MetadataModel metadataModel = EjbJar.getEjbJar((FileObject)fileObject).getMetadataModel();
        return (String)metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, String>(){

            public String run(EjbJarMetadata metadata) throws Exception {
                Ejb ejb = metadata.findByEjbClass(className);
                return ejb == null ? null : ejb.getEjbName();
            }
        });
    }

    private static String getEjbType(FileObject fileObject, final String className) throws IOException {
        MetadataModel metadataModel = EjbJar.getEjbJar((FileObject)fileObject).getMetadataModel();
        return (String)metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, String>(){

            public String run(EjbJarMetadata metadata) throws Exception {
                String result = null;
                Ejb ejb = metadata.findByEjbClass(className);
                if (ejb instanceof Session) {
                    result = "Session";
                } else if (ejb instanceof Entity) {
                    result = "Entity";
                } else if (ejb instanceof MessageDriven) {
                    result = "MessageDriven";
                }
                return result;
            }
        });
    }
}

