/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.classpath.GlobalPathRegistryEvent;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.modules.debugger.jpda.projects.SourcePathProviderImpl;
import org.netbeans.modules.debugger.jpda.projects.SourcesCurrentModel;
import org.netbeans.spi.viewmodel.CheckNodeModelFilter;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.WindowManager;

public class SourcesRemoteModel
implements TreeModel,
CheckNodeModelFilter,
NodeActionsProvider {
    private static Logger logger = Logger.getLogger(SourcesCurrentModel.class.getName());
    private Vector<ModelListener> listeners = new Vector();
    private Set<String> disabledSourceRoots = new HashSet<String>();
    private List<String> additionalSourceRoots = new ArrayList<String>();
    private String[] unorderedOriginalSourceRoots;
    private String[] sortedOriginalSourceRoots;
    private int[] sourcePathPermutation;
    private Properties sourcesProperties = Properties.getDefault().getProperties("debugger").getProperties("sources");
    private GlobalPathRegistryListener globalRegistryListener;
    private JFileChooser newSourceFileChooser;
    private final Action NEW_SOURCE_ROOT_ACTION = new AbstractAction(NbBundle.getMessage(SourcesRemoteModel.class, (String)"CTL_SourcesModel_Action_AddSrc")){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            int state;
            File currentSourceRoot;
            if (SourcesRemoteModel.this.newSourceFileChooser == null) {
                SourcesRemoteModel.this.newSourceFileChooser = new JFileChooser();
                SourcesRemoteModel.this.newSourceFileChooser.setFileSelectionMode(2);
                SourcesRemoteModel.this.newSourceFileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return NbBundle.getMessage(SourcesRemoteModel.class, (String)"CTL_SourcesModel_AddSrc_Chooser_Filter_Description");
                    }

                    @Override
                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        try {
                            return FileUtil.isArchiveFile((URL)file.toURI().toURL());
                        }
                        catch (MalformedURLException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                            return false;
                        }
                    }
                });
            }
            if ((currentSourceRoot = SourcesCurrentModel.getCurrentSourceRoot()) != null) {
                SourcesRemoteModel.this.newSourceFileChooser.setSelectedFile(currentSourceRoot);
            }
            if ((state = SourcesRemoteModel.this.newSourceFileChooser.showDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(SourcesRemoteModel.class, (String)"CTL_SourcesModel_AddSrc_Btn"))) == 0) {
                File zipOrDir = SourcesRemoteModel.this.newSourceFileChooser.getSelectedFile();
                try {
                    if (!zipOrDir.isDirectory() && !FileUtil.isArchiveFile((URL)zipOrDir.toURI().toURL())) {
                        return;
                    }
                    String d = FileUtil.normalizePath((String)zipOrDir.getAbsolutePath());
                    SourcesRemoteModel sourcesRemoteModel = SourcesRemoteModel.this;
                    synchronized (sourcesRemoteModel) {
                        SourcesRemoteModel.this.additionalSourceRoots.add(d);
                        SourcesRemoteModel.access$202(SourcesRemoteModel.this, SourcesRemoteModel.resize(SourcesRemoteModel.this.unorderedOriginalSourceRoots, 1));
                        SourcesRemoteModel.access$402(SourcesRemoteModel.this, SourcesRemoteModel.resize(SourcesRemoteModel.this.sortedOriginalSourceRoots, 1));
                        SourcesRemoteModel.access$502(SourcesRemoteModel.this, SourcesRemoteModel.resize(SourcesRemoteModel.this.sourcePathPermutation, 1));
                        ((SourcesRemoteModel)SourcesRemoteModel.this).unorderedOriginalSourceRoots[((SourcesRemoteModel)SourcesRemoteModel.this).unorderedOriginalSourceRoots.length - 1] = d;
                        ((SourcesRemoteModel)SourcesRemoteModel.this).sortedOriginalSourceRoots[((SourcesRemoteModel)SourcesRemoteModel.this).sortedOriginalSourceRoots.length - 1] = d;
                        ((SourcesRemoteModel)SourcesRemoteModel.this).sourcePathPermutation[((SourcesRemoteModel)SourcesRemoteModel.this).sourcePathPermutation.length - 1] = SourcesRemoteModel.this.sourcePathPermutation.length - 1;
                        SourcePathProviderImpl.storeSourceRootsOrder(null, SourcesRemoteModel.this.unorderedOriginalSourceRoots, SourcesRemoteModel.this.sourcePathPermutation);
                    }
                    SourcesRemoteModel.this.saveAdditionalSourceRoots();
                    SourcesRemoteModel.this.fireTreeChanged();
                }
                catch (IOException ioex) {
                    ErrorManager.getDefault().notify((Throwable)ioex);
                }
            }
        }
    };
    private final Action DELETE_ACTION = Models.createAction((String)NbBundle.getBundle(SourcesRemoteModel.class).getString("CTL_SourcesModel_Action_Delete"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(Object[] nodes) {
            int k = nodes.length;
            for (int i = 0; i < k; ++i) {
                String node = (String)nodes[i];
                SourcesRemoteModel sourcesRemoteModel = SourcesRemoteModel.this;
                synchronized (sourcesRemoteModel) {
                    ArrayList<String> sortedSR;
                    SourcesRemoteModel.this.additionalSourceRoots.remove(node);
                    SourcesRemoteModel.this.disabledSourceRoots.remove(node);
                    ArrayList<String> unorderedSR = new ArrayList<String>(Arrays.asList(SourcesRemoteModel.this.unorderedOriginalSourceRoots));
                    int index = unorderedSR.indexOf(node);
                    if (index >= 0) {
                        int j;
                        unorderedSR.remove(index);
                        SourcesRemoteModel.access$202(SourcesRemoteModel.this, unorderedSR.toArray(new String[0]));
                        int pi = SourcesRemoteModel.this.sourcePathPermutation[index];
                        for (j = 0; j < SourcesRemoteModel.this.sourcePathPermutation.length; ++j) {
                            if (SourcesRemoteModel.this.sourcePathPermutation[j] <= pi) continue;
                            int[] nArray = SourcesRemoteModel.this.sourcePathPermutation;
                            int n = j;
                            nArray[n] = nArray[n] - 1;
                        }
                        for (j = index; j < SourcesRemoteModel.this.sourcePathPermutation.length - 1; ++j) {
                            ((SourcesRemoteModel)SourcesRemoteModel.this).sourcePathPermutation[j] = SourcesRemoteModel.this.sourcePathPermutation[j + 1];
                        }
                    }
                    if ((index = (sortedSR = new ArrayList<String>(Arrays.asList(SourcesRemoteModel.this.sortedOriginalSourceRoots))).indexOf(node)) >= 0) {
                        sortedSR.remove(index);
                        SourcesRemoteModel.access$402(SourcesRemoteModel.this, sortedSR.toArray(new String[0]));
                    }
                    continue;
                }
            }
            SourcesRemoteModel.access$502(SourcesRemoteModel.this, SourcesRemoteModel.resize(SourcesRemoteModel.this.sourcePathPermutation, -k));
            SourcesRemoteModel.this.saveAdditionalSourceRoots();
            SourcesRemoteModel.this.saveDisabledSourceRoots();
            SourcePathProviderImpl.storeSourceRootsOrder(null, SourcesRemoteModel.this.unorderedOriginalSourceRoots, SourcesRemoteModel.this.sourcePathPermutation);
            SourcesRemoteModel.this.fireTreeChanged();
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private final Action MOVE_UP_ACTION = Models.createAction((String)NbBundle.getBundle(SourcesRemoteModel.class).getString("CTL_SourcesModel_MoveUpSrc"), (Models.ActionPerformer)new Models.ActionPerformer(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEnabled(Object node) {
            if ("Root".equals(node)) {
                return false;
            }
            SourcesRemoteModel sourcesRemoteModel = SourcesRemoteModel.this;
            synchronized (sourcesRemoteModel) {
                return SourcesRemoteModel.this.sortedOriginalSourceRoots.length > 0 && !SourcesRemoteModel.this.sortedOriginalSourceRoots[0].equals(node);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(Object[] nodes) {
            int k = nodes.length;
            SourcesRemoteModel sourcesRemoteModel = SourcesRemoteModel.this;
            synchronized (sourcesRemoteModel) {
                String[] roots = SourcesRemoteModel.this.sortedOriginalSourceRoots;
                int n = roots.length;
                int[] permutation = new int[n];
                for (int i = 0; i < n; ++i) {
                    int j;
                    for (j = 0; j < k && !roots[i].equals(nodes[j]); ++j) {
                    }
                    if (j < k) {
                        if (i <= 0) continue;
                        permutation[i] = permutation[i - 1];
                        permutation[i - 1] = i;
                        continue;
                    }
                    permutation[i] = i;
                }
                SourcesRemoteModel.this.reorderOriginalSourceRoots(permutation);
            }
            SourcesRemoteModel.this.fireTreeChanged();
            SourcesRemoteModel.this.fireSelectedNodes(nodes);
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private final Action MOVE_DOWN_ACTION = Models.createAction((String)NbBundle.getBundle(SourcesCurrentModel.class).getString("CTL_SourcesModel_MoveDownSrc"), (Models.ActionPerformer)new Models.ActionPerformer(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEnabled(Object node) {
            if ("Root".equals(node)) {
                return false;
            }
            SourcesRemoteModel sourcesRemoteModel = SourcesRemoteModel.this;
            synchronized (sourcesRemoteModel) {
                return SourcesRemoteModel.this.sortedOriginalSourceRoots.length > 0 && !SourcesRemoteModel.this.sortedOriginalSourceRoots[SourcesRemoteModel.this.sortedOriginalSourceRoots.length - 1].equals(node);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(Object[] nodes) {
            int k = nodes.length;
            SourcesRemoteModel sourcesRemoteModel = SourcesRemoteModel.this;
            synchronized (sourcesRemoteModel) {
                String[] roots = SourcesRemoteModel.this.sortedOriginalSourceRoots;
                int n = roots.length;
                int[] permutation = new int[n];
                for (int i = n - 1; i >= 0; --i) {
                    int j;
                    for (j = 0; j < k && !roots[i].equals(nodes[j]); ++j) {
                    }
                    if (j < k) {
                        if (i >= n - 1) continue;
                        permutation[i] = permutation[i + 1];
                        permutation[i + 1] = i;
                        continue;
                    }
                    permutation[i] = i;
                }
                SourcesRemoteModel.this.reorderOriginalSourceRoots(permutation);
            }
            SourcesRemoteModel.this.fireTreeChanged();
            SourcesRemoteModel.this.fireSelectedNodes(nodes);
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private final Action RESET_ORDER_ACTION = Models.createAction((String)NbBundle.getBundle(SourcesCurrentModel.class).getString("CTL_SourcesModel_ResetOrderSrc"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(Object[] nodes) {
            SourcesRemoteModel.this.reorderOriginalSourceRoots(null);
            SourcesRemoteModel.this.fireTreeChanged();
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);

    public SourcesRemoteModel() {
        this.loadSourceRoots();
        this.updateCachedRoots();
        this.DELETE_ACTION.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        this.MOVE_UP_ACTION.putValue("DisabledWhenInSortedTable", Boolean.TRUE);
        this.MOVE_DOWN_ACTION.putValue("DisabledWhenInSortedTable", Boolean.TRUE);
        this.RESET_ORDER_ACTION.putValue("DisabledWhenInSortedTable", Boolean.TRUE);
    }

    public Object getRoot() {
        return "Root";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            if (this.globalRegistryListener == null) {
                this.globalRegistryListener = new GlobalPathRegistryListener(){

                    public void pathsAdded(GlobalPathRegistryEvent event) {
                        SourcesRemoteModel.this.fireTreeChanged();
                    }

                    public void pathsRemoved(GlobalPathRegistryEvent event) {
                        SourcesRemoteModel.this.fireTreeChanged();
                    }
                };
                GlobalPathRegistry.getDefault().addGlobalPathRegistryListener((GlobalPathRegistryListener)WeakListeners.create(GlobalPathRegistryListener.class, (EventListener)this.globalRegistryListener, (Object)GlobalPathRegistry.getDefault()));
            }
            TreeSet<FileObject> globalRoots = new TreeSet<FileObject>(new SourcePathProviderImpl.FileObjectComparator());
            globalRoots.addAll(GlobalPathRegistry.getDefault().getSourceRoots());
            int n = globalRoots.size();
            ArrayList<String> sourceRoots = new ArrayList<String>(n);
            Iterator it = globalRoots.iterator();
            for (int i = 0; i < n; ++i) {
                sourceRoots.add(SourcePathProviderImpl.getRoot((FileObject)it.next()));
            }
            SourcesRemoteModel i = this;
            synchronized (i) {
                if (this.additionalSourceRoots.size() > 0) {
                    for (String addSrcRoot : this.additionalSourceRoots) {
                        if (sourceRoots.contains(addSrcRoot)) continue;
                        sourceRoots.add(addSrcRoot);
                    }
                }
            }
            String[] os = sourceRoots.toArray(new String[0]);
            Map<String, Integer> orderIndexes = SourcePathProviderImpl.getRemoteSourceRootsOrder();
            Object[] sortedOriginalRoots = new String[os.length];
            int[] sourcePathPermutation = SourcePathProviderImpl.createPermutation(os, orderIndexes, (String[])sortedOriginalRoots);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("getChildren(): orderIndexes = " + orderIndexes + ", sourcePathPermutation = " + Arrays.toString(sourcePathPermutation));
                logger.fine("    sorted roots = " + Arrays.toString(sortedOriginalRoots));
                logger.fine("  sourcePathPermutation = " + Arrays.toString(sourcePathPermutation));
            }
            to = Math.min(sortedOriginalRoots.length, to);
            from = Math.min(sortedOriginalRoots.length, from);
            Object[] fos = new Object[to - from];
            System.arraycopy(sortedOriginalRoots, from, fos, 0, to - from);
            SourcesRemoteModel sourcesRemoteModel = this;
            synchronized (sourcesRemoteModel) {
                this.unorderedOriginalSourceRoots = os;
                this.sortedOriginalSourceRoots = sortedOriginalRoots;
                this.sourcePathPermutation = sourcePathPermutation;
            }
            return fos;
        }
        throw new UnknownTypeException(parent);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return Integer.MAX_VALUE;
        }
        throw new UnknownTypeException(node);
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof String) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    public void fireTreeChanged() {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged(null);
        }
    }

    private void fireSelectedNodes(Object[] nodes) {
        ModelEvent.SelectionChanged event = new ModelEvent.SelectionChanged((Object)this, nodes);
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)event);
        }
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        if (node instanceof String) {
            if (this.additionalSourceRoots.contains((String)node)) {
                return new Action[]{this.NEW_SOURCE_ROOT_ACTION, this.DELETE_ACTION, null, this.MOVE_UP_ACTION, this.MOVE_DOWN_ACTION, null, this.RESET_ORDER_ACTION};
            }
            return new Action[]{this.NEW_SOURCE_ROOT_ACTION, null, this.MOVE_UP_ACTION, this.MOVE_DOWN_ACTION, null, this.RESET_ORDER_ACTION};
        }
        throw new UnknownTypeException(node);
    }

    public void performDefaultAction(Object node) throws UnknownTypeException {
        if (node instanceof String) {
            return;
        }
        throw new UnknownTypeException(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEnabled(String root) {
        SourcesRemoteModel sourcesRemoteModel = this;
        synchronized (sourcesRemoteModel) {
            return !this.disabledSourceRoots.contains(root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEnabled(String root, boolean enabled) {
        SourcesRemoteModel sourcesRemoteModel = this;
        synchronized (sourcesRemoteModel) {
            if (enabled) {
                this.disabledSourceRoots.remove(root);
            } else {
                this.disabledSourceRoots.add(root);
            }
            this.saveDisabledSourceRoots();
        }
    }

    private void loadSourceRoots() {
        this.disabledSourceRoots = new HashSet<String>(this.sourcesProperties.getProperties("source_roots").getCollection("remote_disabled", (Collection)Collections.EMPTY_SET));
        this.additionalSourceRoots = new ArrayList<String>(this.sourcesProperties.getProperties("additional_source_roots").getCollection("src_roots", (Collection)Collections.EMPTY_LIST));
    }

    private synchronized void saveDisabledSourceRoots() {
        this.sourcesProperties.getProperties("source_roots").setCollection("remote_disabled", this.disabledSourceRoots);
    }

    private synchronized void saveAdditionalSourceRoots() {
        this.sourcesProperties.getProperties("additional_source_roots").setCollection("src_roots", this.additionalSourceRoots);
    }

    private synchronized void updateCachedRoots() {
    }

    public boolean isCheckable(NodeModel original, Object node) throws UnknownTypeException {
        return true;
    }

    public boolean isCheckEnabled(NodeModel original, Object node) throws UnknownTypeException {
        return true;
    }

    public Boolean isSelected(NodeModel original, Object node) throws UnknownTypeException {
        if (node instanceof String) {
            return this.isEnabled((String)node);
        }
        throw new UnknownTypeException(node);
    }

    public void setSelected(NodeModel original, Object node, Boolean selected) throws UnknownTypeException {
        if (node instanceof String) {
            this.setEnabled((String)node, selected);
            return;
        }
        throw new UnknownTypeException(node);
    }

    public String getDisplayName(NodeModel original, Object node) throws UnknownTypeException {
        return original.getDisplayName(node);
    }

    public String getIconBase(NodeModel original, Object node) throws UnknownTypeException {
        return original.getIconBase(node);
    }

    public String getShortDescription(NodeModel original, Object node) throws UnknownTypeException {
        return original.getShortDescription(node);
    }

    public synchronized void reorderOriginalSourceRoots(int[] permutation) {
        String[] srcRoots = this.sortedOriginalSourceRoots;
        if (permutation == null) {
            for (int i = 0; i < this.sourcePathPermutation.length; ++i) {
                this.sourcePathPermutation[i] = i;
            }
            this.sortedOriginalSourceRoots = this.unorderedOriginalSourceRoots;
            srcRoots = this.unorderedOriginalSourceRoots;
        } else {
            int i;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("reorderOriginalSourceRoots(" + Arrays.toString(permutation));
            }
            if (srcRoots.length != permutation.length) {
                throw new IllegalArgumentException("Bad length of permutation: " + permutation.length + ", have " + srcRoots.length + " source roots.");
            }
            int n = permutation.length;
            String[] unorderedOriginalRoots = this.unorderedOriginalSourceRoots;
            Object[] sortedOriginalRoots = new String[n];
            for (i = 0; i < n; ++i) {
                permutation[i] = this.sourcePathPermutation[permutation[i]];
                sortedOriginalRoots[i] = unorderedOriginalRoots[permutation[i]];
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("  sourcePathPermutation = " + Arrays.toString(this.sourcePathPermutation));
            }
            for (i = 0; i < n; ++i) {
                this.sourcePathPermutation[i] = permutation[i];
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("  => sourcePathPermutation = " + Arrays.toString(this.sourcePathPermutation));
                logger.fine("  => sorted roots = " + Arrays.toString(sortedOriginalRoots));
            }
            this.sortedOriginalSourceRoots = sortedOriginalRoots;
            srcRoots = unorderedOriginalRoots;
        }
        SourcePathProviderImpl.storeSourceRootsOrder(null, srcRoots, this.sourcePathPermutation);
    }

    private static String[] resize(String[] array, int by) {
        int n = array.length + by;
        String[] newArray = new String[n];
        n = Math.min(n, array.length);
        System.arraycopy(array, 0, newArray, 0, n);
        return newArray;
    }

    private static int[] resize(int[] array, int by) {
        int n = array.length + by;
        int[] newArray = new int[n];
        n = Math.min(n, array.length);
        System.arraycopy(array, 0, newArray, 0, n);
        return newArray;
    }

    static /* synthetic */ String[] access$202(SourcesRemoteModel x0, String[] x1) {
        x0.unorderedOriginalSourceRoots = x1;
        return x1;
    }

    static /* synthetic */ String[] access$402(SourcesRemoteModel x0, String[] x1) {
        x0.sortedOriginalSourceRoots = x1;
        return x1;
    }

    static /* synthetic */ int[] access$502(SourcesRemoteModel x0, int[] x1) {
        x0.sourcePathPermutation = x1;
        return x1;
    }
}

