/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.project.Project;
import org.netbeans.modules.debugger.jpda.projects.MainProjectManager;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.netbeans.spi.project.ActionProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class RunToCursorActionProvider
extends ActionsProviderSupport {
    private EditorContextDispatcher editorContext = EditorContextDispatcher.getDefault();
    private LineBreakpoint breakpoint;
    private static RequestProcessor RP = new RequestProcessor(RunToCursorActionProvider.class.getName());

    public RunToCursorActionProvider() {
        Listener listener = new Listener();
        MainProjectManager.getDefault().addPropertyChangeListener((PropertyChangeListener)((Object)listener));
        this.editorContext.addPropertyChangeListener("text/x-java", WeakListeners.propertyChange((PropertyChangeListener)((Object)listener), (Object)this.editorContext));
        DebuggerManager.getDebuggerManager().addDebuggerListener("debuggerEngines", (DebuggerManagerListener)listener);
        this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, this.shouldBeEnabled());
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_RUN_TO_CURSOR);
    }

    public void doAction(Object action) {
        this.removeBreakpoint();
        this.createBreakpoint(LineBreakpoint.create((String)this.editorContext.getCurrentURLAsString(), (int)this.editorContext.getCurrentLineNumber()));
        this.invokeAction();
    }

    public void postAction(Object action, final Runnable actionPerformedNotifier) {
        final LineBreakpoint newBreakpoint = LineBreakpoint.create((String)this.editorContext.getCurrentURLAsString(), (int)this.editorContext.getCurrentLineNumber());
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                RunToCursorActionProvider.this.removeBreakpoint();
                RunToCursorActionProvider.this.createBreakpoint(newBreakpoint);
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            RunToCursorActionProvider.this.invokeAction();
                        }
                    });
                }
                catch (InterruptedException iex) {
                }
                catch (InvocationTargetException itex) {
                    ErrorManager.getDefault().notify((Throwable)itex);
                }
                finally {
                    actionPerformedNotifier.run();
                }
            }
        });
    }

    private void invokeAction() {
        RunToCursorActionProvider.debugProject(MainProjectManager.getDefault().getMainProject());
    }

    private static void debugProject(Project p) {
        ((ActionProvider)p.getLookup().lookup(ActionProvider.class)).invokeAction("debug", p.getLookup());
    }

    private boolean shouldBeEnabled() {
        int i;
        if (this.editorContext.getCurrentLineNumber() < 0) {
            return false;
        }
        FileObject fo = this.editorContext.getCurrentFile();
        if (fo == null || !fo.hasExt("java")) {
            return false;
        }
        Project p = MainProjectManager.getDefault().getMainProject();
        if (p == null) {
            return false;
        }
        ActionProvider actionProvider = (ActionProvider)p.getLookup().lookup(ActionProvider.class);
        if (actionProvider == null) {
            return false;
        }
        String[] sa = actionProvider.getSupportedActions();
        int k = sa.length;
        for (i = 0; i < k && !"debug".equals(sa[i]); ++i) {
        }
        if (i == k) {
            return false;
        }
        return actionProvider.isActionEnabled("debug", p.getLookup());
    }

    private void createBreakpoint(LineBreakpoint breakpoint) {
        breakpoint.setHidden(true);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)breakpoint);
        this.breakpoint = breakpoint;
    }

    private void removeBreakpoint() {
        if (this.breakpoint != null) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.breakpoint);
            this.breakpoint = null;
        }
    }

    private class Listener
    extends DebuggerManagerAdapter {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName() == "state") {
                int state = (Integer)e.getNewValue();
                if (state == 4 || state == 3) {
                    RunToCursorActionProvider.this.removeBreakpoint();
                }
                return;
            }
            RunToCursorActionProvider.this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, RunToCursorActionProvider.this.shouldBeEnabled());
        }

        public void engineAdded(DebuggerEngine engine) {
            JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
            if (debugger == null) {
                return;
            }
            debugger.addPropertyChangeListener("state", (PropertyChangeListener)((Object)this));
        }

        public void engineRemoved(DebuggerEngine engine) {
            JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
            if (debugger == null) {
                return;
            }
            debugger.removePropertyChangeListener("state", (PropertyChangeListener)((Object)this));
        }
    }
}

