/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.compilerset;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsPanelSupport;
import org.netbeans.modules.cnd.toolchain.compilers.SPICompilerAccesor;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetManagerImpl;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetPreferences;
import org.netbeans.modules.cnd.toolchain.compilerset.FixCodeAssistancePanel;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class ToolchainValidator {
    private static final boolean DISABLED = Boolean.getBoolean("cnd.toolchain.validator.disabled") || CompilerSetManagerImpl.DISABLED;
    private static final Logger LOG = Logger.getLogger(ToolchainValidator.class.getName());
    public static final ToolchainValidator INSTANCE = new ToolchainValidator();
    private static final RequestProcessor RP = new RequestProcessor("Tool collection validator", 1);

    private ToolchainValidator() {
    }

    public void validate(final ExecutionEnvironment env, final CompilerSetManagerImpl csm) {
        boolean postpone;
        if (DISABLED) {
            return;
        }
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ToolchainValidator.this.validateImpl(env, csm);
            }
        };
        boolean bl = postpone = env.isRemote() && !ServerList.get((ExecutionEnvironment)env).isOnline();
        if (postpone) {
            ServerList.get((ExecutionEnvironment)env).addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("stateChanged".equals(evt.getPropertyName()) && ServerList.get((ExecutionEnvironment)env).isOnline()) {
                        RP.post(runnable);
                        ServerList.get((ExecutionEnvironment)env).removePropertyChangeListener((PropertyChangeListener)this);
                    }
                }
            });
        } else {
            RP.post(runnable);
        }
    }

    void applyChanges(Map<Tool, List<List<String>>> needReset, CompilerSetManagerImpl csm) {
        for (Map.Entry<Tool, List<List<String>>> entry : needReset.entrySet()) {
            Tool tool = entry.getKey();
            List<List<String>> pair = entry.getValue();
            new SPICompilerAccesor(tool).applySystemIncludesAndDefines(pair);
        }
        CompilerSetPreferences.saveToDisk(csm);
        ToolsPanelSupport.fireCodeAssistanceChange(csm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateImpl(ExecutionEnvironment env, CompilerSetManagerImpl csm) {
        ProgressHandle createHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ToolchainValidator.class, (String)"ToolCollectionValidation", (Object)env.getDisplayName()));
        createHandle.start();
        try {
            HashMap<Tool, List<List<String>>> needReset = new HashMap<Tool, List<List<String>>>();
            for (CompilerSet cs : csm.getCompilerSets()) {
                for (Tool tool : cs.getTools()) {
                    List<List<String>> systemIncludesAndDefines;
                    if (!(tool instanceof AbstractCompiler) || tool.getKind() != PredefinedToolKind.CCompiler && tool.getKind() != PredefinedToolKind.CCCompiler || this.isEqualsSystemIncludesAndDefines(systemIncludesAndDefines = new SPICompilerAccesor(tool).getSystemIncludesAndDefines(), (AbstractCompiler)tool)) continue;
                    needReset.put(tool, systemIncludesAndDefines);
                }
            }
            if (needReset.size() > 0) {
                FixCodeAssistancePanel.showNotification(needReset, csm);
            }
        }
        finally {
            createHandle.finish();
        }
    }

    private boolean isEqualsSystemIncludesAndDefines(List<List<String>> systemIncludesAndDefines, AbstractCompiler tool) {
        if (systemIncludesAndDefines == null) {
            return true;
        }
        List<String> systemIncludeDirectories = tool.getSystemIncludeDirectories();
        List<String> systemPreprocessorSymbols = tool.getSystemPreprocessorSymbols();
        if (!this.comparePathsLists(systemIncludesAndDefines.get(0), systemIncludeDirectories, tool)) {
            return false;
        }
        return this.compareMacrosLists(systemIncludesAndDefines.get(1), systemPreprocessorSymbols, tool);
    }

    private boolean comparePathsLists(List<String> newList, List<String> oldList, AbstractCompiler tool) {
        HashSet<String> oldSet = new HashSet<String>(oldList);
        boolean res = true;
        for (String s : newList) {
            if (oldSet.contains(s)) continue;
            LOG.log(Level.FINE, "Tool {0} was changed. Added system include path {1}", new Object[]{tool.getDisplayName(), s});
            res = false;
        }
        return res;
    }

    private boolean compareMacrosLists(List<String> newList, List<String> oldList, AbstractCompiler tool) {
        HashMap<String, String> oldMap = new HashMap<String, String>();
        for (String s : oldList) {
            int i = s.indexOf(61);
            if (i > 0) {
                oldMap.put(s.substring(0, i), s.substring(i + 1));
                continue;
            }
            oldMap.put(s, null);
        }
        boolean res = true;
        for (String s : newList) {
            String value;
            String key;
            if (s.startsWith("__TIME__") || s.startsWith("__DATE__") || s.startsWith("__FILE__") || s.startsWith("__LINE__")) continue;
            int i = s.indexOf(61);
            if (i > 0) {
                key = s.substring(0, i);
                value = s.substring(i + 1);
            } else {
                key = s;
                value = null;
            }
            if (!oldMap.containsKey(key)) {
                LOG.log(Level.FINE, "Tool {0} was changed. Added macro {1}", new Object[]{tool.getDisplayName(), s});
                res = false;
            }
            String oldValue = (String)oldMap.get(key);
            if (value == null && oldValue == null || value == null && "1".equals(oldValue) || "1".equals(value) && oldValue == null || value != null && oldValue != null && value.equals(oldValue)) continue;
            LOG.log(Level.FINE, "Tool {0} was changed. Changed macro {1} from [{2}] to [{3}]", new Object[]{tool.getDisplayName(), key, oldValue, value});
            res = false;
        }
        return res;
    }
}

