/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.compilers;

import java.io.BufferedReader;
import java.io.IOException;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.toolchain.compilers.CCCCompiler;
import org.netbeans.modules.cnd.toolchain.compilers.SunCCCCompiler;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.ErrorManager;

class SunCCCompiler
extends SunCCCCompiler {
    protected SunCCCompiler(ExecutionEnvironment env, CompilerFlavor flavor, ToolKind kind, String name, String displayName, String path) {
        super(env, flavor, kind, name, displayName, path);
    }

    @Override
    public SunCCCompiler createCopy(CompilerFlavor flavor) {
        SunCCCompiler copy = new SunCCCompiler(this.getExecutionEnvironment(), flavor, this.getKind(), this.getName(), this.getDisplayName(), this.getPath());
        if (this.isReady()) {
            copy.copySystemIncludeDirectories(this.getSystemIncludeDirectories());
            copy.copySystemPreprocessorSymbols(this.getSystemPreprocessorSymbols());
        }
        return copy;
    }

    public static SunCCCompiler create(ExecutionEnvironment env, CompilerFlavor flavor, ToolKind kind, String name, String displayName, String path) {
        return new SunCCCompiler(env, flavor, kind, name, displayName, path);
    }

    @Override
    public ToolchainManager.CompilerDescriptor getDescriptor() {
        return this.getFlavor().getToolchainDescriptor().getCpp();
    }

    @Override
    protected void parseCompilerOutput(BufferedReader reader, CCCCompiler.Pair pair) {
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String[] macro;
                String token2;
                for (String token2 : this.getSystemPaths(line)) {
                    SunCCCompiler.addUnique(pair.systemIncludeDirectoriesList, this.applyPathPrefix(token2));
                    if (!token2.endsWith("Cstd")) continue;
                    SunCCCompiler.addUnique(pair.systemIncludeDirectoriesList, this.applyPathPrefix(token2.substring(0, token2.length() - 4) + "std"));
                }
                SunCCCompiler.parseUserMacros(line, pair.systemPreprocessorSymbolsList);
                if (!line.startsWith("#define ") || !CCCCompiler.isValidMacroName((macro = CCCCompiler.getMacro(line.substring(8).trim()))[0])) continue;
                token2 = macro[1] != null ? macro[0] + "=" + macro[1] : macro[0];
                SunCCCompiler.addUnique(pair.systemPreprocessorSymbolsList, token2);
            }
            reader.close();
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(16, (Throwable)ioe);
        }
        this.completePredefinedMacros(pair);
    }
}

