/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.spi.toolchain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.toolchain.execution.OutputListenerImpl;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.windows.OutputListener;

public abstract class ErrorParserProvider {
    public static final String UNIVERSAL_PROVIDER_ID = "universal";
    public static final Result NO_RESULT = new NoResult();
    public static final Result REMOVE_LINE = new RemoveLine();
    private static final DefaultErrorParserProvider DEFAULT = new DefaultErrorParserProvider();

    public static ErrorParserProvider getDefault() {
        return DEFAULT;
    }

    public static List<ErrorParser> getUniversalErorParsers(Project project, ExecutionEnvironment execEnv, FileObject relativeTo) {
        return DEFAULT.getUniversalErorParsersImpl(project, execEnv, relativeTo);
    }

    public abstract ErrorParser getErorParser(Project var1, CompilerFlavor var2, ExecutionEnvironment var3, FileObject var4);

    public abstract String getID();

    private static final class DefaultErrorParserProvider
    extends ErrorParserProvider {
        private final Lookup.Result<ErrorParserProvider> res = Lookup.getDefault().lookupResult(ErrorParserProvider.class);

        DefaultErrorParserProvider() {
        }

        private ErrorParserProvider getService(String id) {
            for (ErrorParserProvider service : this.res.allInstances()) {
                if (!service.getID().equals(id)) continue;
                return service;
            }
            return null;
        }

        @Override
        public ErrorParser getErorParser(Project project, CompilerFlavor flavor, ExecutionEnvironment execEnv, FileObject relativeTo) {
            ErrorParserProvider provider = this.getService(flavor.getToolchainDescriptor().getScanner().getID());
            if (provider != null) {
                return provider.getErorParser(project, flavor, execEnv, relativeTo);
            }
            return null;
        }

        @Override
        public String getID() {
            throw new UnsupportedOperationException();
        }

        public List<ErrorParser> getUniversalErorParsersImpl(Project project, ExecutionEnvironment execEnv, FileObject relativeTo) {
            ArrayList<ErrorParser> parsers = new ArrayList<ErrorParser>();
            for (ErrorParserProvider service : this.res.allInstances()) {
                ErrorParser erorParser;
                if (!ErrorParserProvider.UNIVERSAL_PROVIDER_ID.equals(service.getID()) || (erorParser = service.getErorParser(project, null, execEnv, relativeTo)) == null) continue;
                parsers.add(erorParser);
            }
            return parsers;
        }
    }

    private static final class RemoveLine
    implements Result {
        private RemoveLine() {
        }

        @Override
        public boolean result() {
            return true;
        }

        @Override
        public List<ConvertedLine> converted() {
            return Collections.emptyList();
        }
    }

    private static final class NoResult
    implements Result {
        private NoResult() {
        }

        @Override
        public boolean result() {
            return false;
        }

        @Override
        public List<ConvertedLine> converted() {
            return Collections.emptyList();
        }
    }

    public static final class Results
    implements Result {
        private List<ConvertedLine> result = new ArrayList<ConvertedLine>(1);

        public Results() {
        }

        public Results(String line, OutputListener listener) {
            this.result.add(ConvertedLine.forText((String)line, (OutputListener)listener));
        }

        public void add(String line, OutputListener listener) {
            this.result.add(ConvertedLine.forText((String)line, (OutputListener)listener));
        }

        @Override
        public boolean result() {
            return true;
        }

        @Override
        public List<ConvertedLine> converted() {
            return this.result;
        }
    }

    public static interface Result {
        public boolean result();

        public List<ConvertedLine> converted();
    }

    public static interface ErrorParser {
        public Result handleLine(String var1);

        public void setOutputListenerRegistry(OutputListenerRegistry var1);
    }

    public static final class OutputListenerRegistry {
        private final Map<FileObject, List<OutputListener>> storage = new HashMap<FileObject, List<OutputListener>>();
        private final Map<OutputListener, FileObject> listeners = new HashMap<OutputListener, FileObject>();

        protected OutputListenerRegistry() {
        }

        public OutputListener register(FileObject file, int line, boolean isError, String description) {
            OutputListenerImpl res = new OutputListenerImpl(this, file, line, isError, description);
            List<OutputListener> list = this.storage.get(file);
            if (list == null) {
                list = new ArrayList<OutputListener>();
                this.storage.put(file, list);
            }
            list.add(res);
            this.listeners.put(res, file);
            return res;
        }

        public List<OutputListener> getFileListeners(FileObject file) {
            return this.storage.get(file);
        }
    }
}

