/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.j2me.cdc.platform.CDCPlatform;
import org.netbeans.modules.j2me.cdc.project.ui.wizards.NewCDCProjectWizardIterator;
import org.netbeans.modules.j2me.cdc.project.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.j2me.cdc.project.ui.wizards.SettingsPanel;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class PanelOptionsVisual
extends SettingsPanel
implements ActionListener,
PropertyChangeListener {
    private static boolean lastMainClassCheck = true;
    private static final String MAIN_CLASS = "mainClass";
    protected PanelConfigureProject panel;
    private boolean valid;
    private int type;
    private JPanel containerPanel;
    private JCheckBox createMainCheckBox;
    private JTextField mainClassTextField;
    private JSeparator separator;

    public PanelOptionsVisual(PanelConfigureProject panel, int type) {
        this.initComponents();
        this.type = type;
        this.panel = panel;
        switch (type) {
            case 1: {
                this.createMainCheckBox.setVisible(false);
                this.mainClassTextField.setVisible(false);
                this.separator.setVisible(false);
                break;
            }
            case 0: {
                this.createMainCheckBox.addActionListener(this);
                this.createMainCheckBox.setSelected(lastMainClassCheck);
                this.mainClassTextField.setEnabled(lastMainClassCheck);
                this.separator.setVisible(true);
                break;
            }
            case 2: {
                this.createMainCheckBox.setVisible(false);
                this.mainClassTextField.setVisible(false);
                break;
            }
            case 3: {
                this.createMainCheckBox.setVisible(false);
                this.mainClassTextField.setVisible(false);
                this.separator.setVisible(true);
            }
        }
        this.mainClassTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PanelOptionsVisual.this.mainClassChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PanelOptionsVisual.this.mainClassChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PanelOptionsVisual.this.mainClassChanged();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.createMainCheckBox) {
            lastMainClassCheck = this.createMainCheckBox.isSelected();
            this.mainClassTextField.setEnabled(lastMainClassCheck);
            this.panel.fireChangeEvent();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if ("projectName".equals(event.getPropertyName())) {
            String newProjectName = NewCDCProjectWizardIterator.getPackageName((String)event.getNewValue());
            this.mainClassTextField.setText(MessageFormat.format(NbBundle.getMessage(PanelOptionsVisual.class, (String)"TXT_ClassName"), newProjectName));
        }
    }

    private void initComponents() {
        this.createMainCheckBox = new JCheckBox();
        this.mainClassTextField = new JTextField();
        this.separator = new JSeparator();
        this.containerPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.createMainCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createMainCheckBox, (String)NbBundle.getBundle(PanelOptionsVisual.class).getString("LBL_createMainCheckBox"));
        this.createMainCheckBox.setMargin(new Insets(0, 0, 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.createMainCheckBox, gridBagConstraints);
        this.createMainCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelOptionsVisual.class).getString("ACSN_createMainCheckBox"));
        this.createMainCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelOptionsVisual.class).getString("ACSD_createMainCheckBox"));
        this.mainClassTextField.setText("com.myapp.Main");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.add((Component)this.mainClassTextField, gridBagConstraints);
        this.mainClassTextField.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelOptionsVisual.class).getString("ASCN_mainClassTextFiled"));
        this.mainClassTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelOptionsVisual.class).getString("ASCD_mainClassTextFiled"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.separator, gridBagConstraints);
        this.containerPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.containerPanel, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSN_PanelOptionsVisual"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_PanelOptionsVisual"));
    }

    @Override
    boolean valid(WizardDescriptor settings) {
        if (this.mainClassTextField.isVisible() && this.mainClassTextField.isEnabled()) {
            if (!this.valid) {
                settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"ERROR_IllegalMainClassName"));
            }
            return this.valid;
        }
        return true;
    }

    @Override
    void read(WizardDescriptor d) {
        JavaPlatform[] platforms = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("cdc", null));
        if (platforms.length != 0 && platforms[0] instanceof CDCPlatform) {
            CDCPlatform platform = (CDCPlatform)platforms[0];
            assert (platform != null);
        }
    }

    @Override
    void validate(WizardDescriptor d) {
    }

    @Override
    void store(WizardDescriptor d) {
        d.putProperty(MAIN_CLASS, this.createMainCheckBox.isSelected() && this.createMainCheckBox.isVisible() ? this.mainClassTextField.getText() : null);
    }

    protected void mainClassChanged() {
        String mainClassName = this.mainClassTextField.getText();
        StringTokenizer tk = new StringTokenizer(mainClassName, ".");
        boolean _valid = true;
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken();
            if (token.length() != 0 && Utilities.isJavaIdentifier((String)token)) continue;
            _valid = false;
            break;
        }
        this.valid = _valid;
        this.panel.fireChangeEvent();
    }
}

