/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project.ui.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.mobility.project.PropertyDescriptor;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2me.cdc.project.ui.wizards.ImportCDCProjectPanel;
import org.netbeans.modules.j2me.cdc.project.ui.wizards.NewCDCProjectWizardIterator;
import org.netbeans.modules.mobility.project.J2MEProjectGenerator;
import org.netbeans.modules.mobility.project.ui.wizard.PlatformInstallPanel;
import org.netbeans.modules.mobility.project.ui.wizard.PlatformSelectionPanel;
import org.netbeans.modules.mobility.project.ui.wizard.ProjectPanel;
import org.netbeans.spi.mobility.project.ProjectPropertiesDescriptor;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ImportCDCProjectWizardIterator
implements TemplateWizard.Iterator {
    boolean platformInstall;
    int currentIndex;
    PlatformInstallPanel.WizardPanel platformPanel;
    ImportCDCProjectPanel.WizardPanel sourcesPanel;
    ProjectPanel.WizardPanel projectPanel;
    static final String CDC55 = "org.netbeans.modules.j2me.cdc.nbproject";
    static final String CDCTOOLKIT = "org.netbeans.modules.j2me.cdc.project";
    static final String CDC55TYPE = "CDC Pack 5.5";
    static final String CDCTOOLKITTYPE = "CDC Toolkit";
    final String prjType;

    public ImportCDCProjectWizardIterator() {
        this(CDC55);
    }

    public static ImportCDCProjectWizardIterator toolkit() {
        return new ImportCDCProjectWizardIterator(CDCTOOLKIT);
    }

    ImportCDCProjectWizardIterator(String type) {
        this.prjType = type;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public WizardDescriptor.Panel current() {
        if (this.platformInstall) {
            switch (this.currentIndex) {
                case 0: {
                    return this.platformPanel;
                }
                case 1: {
                    return this.sourcesPanel;
                }
                case 2: {
                    return this.projectPanel;
                }
            }
        } else {
            switch (this.currentIndex) {
                case 0: {
                    return this.sourcesPanel;
                }
                case 1: {
                    return this.projectPanel;
                }
            }
        }
        throw new IllegalStateException();
    }

    public boolean hasNext() {
        if (this.platformInstall) {
            return this.currentIndex < 2;
        }
        return this.currentIndex < 1;
    }

    public boolean hasPrevious() {
        return this.currentIndex > 0;
    }

    public void initialize(TemplateWizard templateWizard) {
        this.platformInstall = PlatformInstallPanel.isPlatformInstalled((String)"cdc") ^ true;
        if (this.platformInstall) {
            this.platformPanel = new PlatformInstallPanel.WizardPanel("cdc");
            ((JComponent)this.platformPanel.getComponent()).putClientProperty("NewProjectWizard_Title", CDC55.equals(this.prjType) ? NbBundle.getMessage(ImportCDCProjectWizardIterator.class, (String)"TXT_Import55Project") : NbBundle.getMessage(ImportCDCProjectWizardIterator.class, (String)"TXT_ImportToolkitProject"));
        }
        this.sourcesPanel = new ImportCDCProjectPanel.WizardPanel(this.prjType);
        ((JComponent)this.sourcesPanel.getComponent()).putClientProperty("NewProjectWizard_Title", CDC55.equals(this.prjType) ? NbBundle.getMessage(ImportCDCProjectWizardIterator.class, (String)"TXT_Import55Project") : NbBundle.getMessage(ImportCDCProjectWizardIterator.class, (String)"TXT_ImportToolkitProject"));
        this.projectPanel = new ProjectPanel.WizardPanel(false, true);
        this.currentIndex = 0;
        this.updateStepsList();
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.platformPanel = null;
        this.sourcesPanel = null;
        this.projectPanel = null;
        this.currentIndex = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DataObject> instantiate(TemplateWizard templateWizard) throws IOException {
        final String location = (String)templateWizard.getProperty("ImportProjectLocation");
        File newLocation = (File)templateWizard.getProperty("ProjectLocation");
        String name = (String)templateWizard.getProperty("ProjectName");
        final EditableProperties oldep = new EditableProperties();
        FileInputStream fis = new FileInputStream(location + File.separator + "nbproject/project.properties");
        try {
            oldep.load((InputStream)fis);
        }
        finally {
            fis.close();
        }
        File f = new File(location + File.separator + "nbproject/private/private.properties");
        final EditableProperties oldpriv = new EditableProperties();
        if (f.exists()) {
            fis = new FileInputStream(f);
            try {
                oldpriv.load((InputStream)fis);
            }
            finally {
                fis.close();
            }
        }
        JavaPlatform[] platforms = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("cdc", null));
        PlatformSelectionPanel.PlatformDescription pdesc = new PlatformSelectionPanel.PlatformDescription();
        AntProjectHelper helper = J2MEProjectGenerator.createProject((File)newLocation, (String)name, (PlatformSelectionPanel.PlatformDescription)pdesc, (J2MEProjectGenerator.ProjectGeneratorCallback)new J2MEProjectGenerator.ProjectGeneratorCallback(){

            public void doPostGeneration(Project project, AntProjectHelper helper, FileObject projectLocation, File projectLocationFile, ArrayList<String> configurations) throws IOException {
                EditableProperties ep = helper.getProperties("nbproject/project.properties");
                EditableProperties priv = helper.getProperties("nbproject/private/private.properties");
                if (oldep.getProperty("main.class.applet") != null && oldep.getProperty("main.class.applet").equals("true")) {
                    ep.setProperty("main.class.class", "applet");
                } else if (oldep.getProperty("main.class.xlet") != null && oldep.getProperty("main.class.xlet").equals("true")) {
                    ep.setProperty("main.class.class", "xlet");
                } else {
                    ep.setProperty("main.class.class", "main");
                }
                for (ProjectPropertiesDescriptor p : Lookup.getDefault().lookup(new Lookup.Template(ProjectPropertiesDescriptor.class)).allInstances()) {
                    for (PropertyDescriptor d : p.getPropertyDescriptors()) {
                        String s;
                        String name = d.getName();
                        if (d.isShared()) {
                            s = oldep.getProperty(name);
                            if (s == null) continue;
                            ep.setProperty(name, s);
                            continue;
                        }
                        s = oldpriv.getProperty(name);
                        if (s == null) continue;
                        priv.setProperty(name, s);
                    }
                }
                FileObject src = projectLocation.createFolder("src");
                File srcFile = FileUtil.toFile((FileObject)src);
                FileObject lib = projectLocation.createFolder("lib");
                File libFile = FileUtil.toFile((FileObject)lib);
                FileObject res = projectLocation.createFolder("resources");
                File resFile = FileUtil.toFile((FileObject)res);
                J2MEProjectGenerator.copyJavaFolder((File)new File(location, "src"), (File)srcFile, (Pattern)J2MEProjectGenerator.IMPORT_SRC_EXCLUDES);
                J2MEProjectGenerator.copyFolder((File)new File(location, "resources"), (File)resFile, (Pattern)J2MEProjectGenerator.IMPORT_SRC_EXCLUDES);
                J2MEProjectGenerator.copyFolder((File)new File(location, "lib"), (File)libFile, (Pattern)J2MEProjectGenerator.IMPORT_EXCLUDES);
                String pa = oldep.getProperty("platform.active");
                if (pa != null) {
                    ep.setProperty("platform.active.description", pa.replace('_', ' '));
                }
                ep.setProperty("platform.trigger", "CDC");
                ep.setProperty("libs.classpath", oldep.getProperty("javac.classpath"));
                ep.setProperty("src.dir", oldep.getProperty("src.dir"));
                helper.putProperties("nbproject/project.properties", ep);
            }
        });
        NewCDCProjectWizardIterator.createManifest(helper.getProjectDirectory(), "manifest.mf");
        return Collections.singleton(DataObject.find((FileObject)helper.getProjectDirectory()));
    }

    public String name() {
        return this.current().getComponent().getName();
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.currentIndex;
        this.updateStepsList();
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.currentIndex;
        this.updateStepsList();
    }

    void updateStepsList() {
        JComponent component = (JComponent)this.current().getComponent();
        if (component == null) {
            return;
        }
        String[] list = this.platformInstall ? new String[]{NbBundle.getMessage(PlatformInstallPanel.class, (String)"TITLE_Platform"), NbBundle.getMessage(ImportCDCProjectPanel.class, (String)"TITLE_Project", (Object)(this.prjType.equals(CDC55) ? CDC55TYPE : CDCTOOLKITTYPE)), NbBundle.getMessage(ProjectPanel.class, (String)"TITLE_Project")} : new String[]{NbBundle.getMessage(ImportCDCProjectPanel.class, (String)"TITLE_Project", (Object)(this.prjType.equals(CDC55) ? CDC55TYPE : CDCTOOLKITTYPE)), NbBundle.getMessage(ProjectPanel.class, (String)"TITLE_Project")};
        component.putClientProperty("WizardPanel_contentData", list);
        component.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(this.currentIndex));
    }
}

