/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remotefs.versioning.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.extexecution.ProcessBuilder;
import org.netbeans.modules.remote.impl.fileoperations.spi.FileOperationsProvider;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.filesystems.VCSFileProxyOperations;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public class FileProxyProviderImpl
extends FileOperationsProvider {
    private final Map<FileSystem, FileOperationsProvider.FileOperations> map = new HashMap<FileSystem, FileOperationsProvider.FileOperations>();
    private static final Logger LOG = Logger.getLogger(FileProxyProviderImpl.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized FileOperationsProvider.FileOperations getFileOperations(FileSystem fs) {
        FileOperationsProvider.FileOperations fileOperations;
        Map<FileSystem, FileOperationsProvider.FileOperations> map = this.map;
        synchronized (map) {
            fileOperations = this.map.get(fs);
            if (fileOperations == null) {
                fileOperations = new FileOperationsImpl(fs);
                this.map.put(fs, fileOperations);
            }
        }
        return fileOperations;
    }

    private static FileOperationsProvider.FileProxyO toFileProxy(VCSFileProxy file) {
        return new FileProxyOImpl(file);
    }

    private static final class FileProxyOImpl
    implements FileOperationsProvider.FileProxyO {
        private final VCSFileProxy file;

        public FileProxyOImpl(VCSFileProxy file) {
            this.file = file;
        }

        public String getPath() {
            return this.file.getPath();
        }

        public String toString() {
            return this.file.getPath();
        }

        public int hashCode() {
            return this.file.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileProxyOImpl other = (FileProxyOImpl)obj;
            return this.file == other.file || this.file != null && this.file.equals((Object)other.file);
        }
    }

    private static final class FileOperationsImpl
    extends FileOperationsProvider.FileOperations
    implements VCSFileProxyOperations {
        private boolean assertIt = false;
        private static final Set<Integer> alreadyTraced = new HashSet<Integer>();

        protected FileOperationsImpl(FileSystem fs) {
            super(fs);
        }

        public String getName(VCSFileProxy file) {
            return this.getName(FileProxyProviderImpl.toFileProxy(file));
        }

        public boolean isDirectory(VCSFileProxy file) {
            this.softEDTAssert();
            return this.isDirectory(FileProxyProviderImpl.toFileProxy(file));
        }

        public boolean isFile(VCSFileProxy file) {
            this.softEDTAssert();
            return this.isFile(FileProxyProviderImpl.toFileProxy(file));
        }

        public boolean canWrite(VCSFileProxy file) {
            this.softEDTAssert();
            return this.canWrite(FileProxyProviderImpl.toFileProxy(file));
        }

        public VCSFileProxy getParentFile(VCSFileProxy file) {
            this.softEDTAssert();
            String parent = this.getDir(FileProxyProviderImpl.toFileProxy(file));
            if (parent == null) {
                return null;
            }
            FileObject root = this.getRoot();
            VCSFileProxy res = VCSFileProxy.createFileProxy((FileObject)root);
            String[] split = parent.split("/");
            for (int i = 0; i < split.length; ++i) {
                if (split[i].isEmpty() || ".".equals(split[i])) continue;
                res = VCSFileProxy.createFileProxy((VCSFileProxy)res, (String)split[i]);
            }
            return res;
        }

        public String getAbsolutePath(VCSFileProxy file) {
            return file.getPath();
        }

        public boolean exists(VCSFileProxy file) {
            this.softEDTAssert();
            return this.exists(FileProxyProviderImpl.toFileProxy(file));
        }

        public VCSFileProxy normalize(VCSFileProxy file) {
            this.softEDTAssert();
            String path = this.normalizeUnixPath(FileProxyProviderImpl.toFileProxy(file));
            if (file.getPath().equals(path)) {
                return file;
            }
            FileObject root = this.getRoot();
            VCSFileProxy res = VCSFileProxy.createFileProxy((FileObject)root);
            String[] split = path.split("/");
            for (int i = 0; i < split.length; ++i) {
                if (split[i].isEmpty() || ".".equals(split[i])) continue;
                res = VCSFileProxy.createFileProxy((VCSFileProxy)res, (String)split[i]);
            }
            return res;
        }

        public FileObject toFileObject(VCSFileProxy path) {
            this.softEDTAssert();
            return this.toFileObject(FileProxyProviderImpl.toFileProxy(path));
        }

        public VCSFileProxy[] list(VCSFileProxy path) {
            this.softEDTAssert();
            String[] list = this.list(FileProxyProviderImpl.toFileProxy(path));
            if (list == null) {
                return null;
            }
            VCSFileProxy[] res = new VCSFileProxy[list.length];
            for (int i = 0; i < list.length; ++i) {
                res[i] = VCSFileProxy.createFileProxy((VCSFileProxy)path, (String)list[i]);
            }
            return res;
        }

        public ProcessBuilder createProcessBuilder(VCSFileProxy file) {
            this.softEDTAssert();
            return this.createProcessBuilder(FileProxyProviderImpl.toFileProxy(file));
        }

        public void refreshFor(VCSFileProxy ... files) {
            ArrayList<FileOperationsProvider.FileProxyO> list = new ArrayList<FileOperationsProvider.FileProxyO>();
            for (VCSFileProxy f : files) {
                list.add(FileProxyProviderImpl.toFileProxy(f));
            }
            this.refreshFor(list.toArray(new FileOperationsProvider.FileProxyO[list.size()]));
        }

        private void softEDTAssert() {
            Exception exception;
            int hashCode;
            if (this.assertIt && SwingUtilities.isEventDispatchThread() && alreadyTraced.add(hashCode = Arrays.hashCode((exception = new Exception()).getStackTrace()))) {
                LOG.log(Level.INFO, "Method cannot be called in EDT", exception);
            }
        }
    }
}

