/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

public class Util {
    private static final Logger log = DLightLogger.getLogger(Util.class);

    private Util() {
    }

    private static String getFullPath(String relpath) {
        File file = InstalledFileLocator.getDefault().locate(relpath, null, false);
        if (file != null && file.exists()) {
            return file.getAbsolutePath();
        }
        return relpath;
    }

    public static File copyToTempDir(Class<?> clazz, String resourceName) throws IOException, ConnectionManager.CancellationException {
        return Util.copyToTempDir(clazz.getClassLoader().getResource(resourceName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copyToTempDir(URL url) throws IOException, ConnectionManager.CancellationException {
        if (url == null) {
            return null;
        }
        InputStream is = url.openStream();
        try {
            File file;
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
            if (hostInfo == null) {
                throw new IOException("Failed to get local ExecutionEnvironment");
            }
            String prefix = "_dlight_" + Util.getBriefName(url);
            File result = File.createTempFile(prefix, "", hostInfo.getTempDirFile());
            result.deleteOnExit();
            FileOutputStream os = new FileOutputStream(result);
            try {
                FileUtil.copy((InputStream)is, (OutputStream)os);
                os.flush();
                file = result;
            }
            catch (Throwable throwable) {
                ((OutputStream)os).close();
                throw throwable;
            }
            ((OutputStream)os).close();
            return file;
        }
        finally {
            is.close();
        }
    }

    public static String getBriefName(URL resourceUrl) {
        String result = resourceUrl.getFile();
        int pos = result.lastIndexOf(47);
        result = pos >= 0 ? result.substring(pos + 1) : result;
        return result;
    }

    public static void setExecutionPermissions(List<String> files) {
        if (files.isEmpty()) {
            return;
        }
        ArrayList<String> paths = new ArrayList<String>();
        Iterator<String> i$ = files.iterator();
        while (i$.hasNext()) {
            String f;
            String fullPath = f = i$.next();
            if (!new File(f).exists()) {
                fullPath = Util.getFullPath(f);
            }
            if (!new File(fullPath).exists()) continue;
            paths.add(fullPath);
        }
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("/bin/chmod");
        commands.add("755");
        commands.addAll(paths);
        ProcessBuilder pb = new ProcessBuilder(commands);
        try {
            pb.start();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static String getBasePath(Class<?> cls) {
        String path = cls.getName().replace('.', '/');
        int pos = path.lastIndexOf(47);
        return pos > 0 ? path.substring(0, pos) : path;
    }

    public static boolean getBoolean(String name, boolean defaultValue) {
        String value = System.getProperty(name);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    public static boolean deleteLocalDirectory(File path) {
        File[] files;
        if (path.exists() && (files = path.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    Util.deleteLocalDirectory(files[i]);
                    continue;
                }
                boolean result = files[i].delete();
                if (result || !log.isLoggable(Level.FINE)) continue;
                log.log(Level.FINE, "Unable to delete file {0}", files[i].getAbsolutePath());
            }
        }
        return path.delete();
    }

    public static <T> T firstInstanceOf(Class<T> clazz, Collection<? super T> objects) {
        for (T obj : objects) {
            if (!clazz.isAssignableFrom(obj.getClass())) continue;
            return clazz.cast(obj);
        }
        return null;
    }

    public static <T> T maskNull(T value, T nullValue) {
        return value == null ? nullValue : value;
    }
}

