/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.dlight.libs.common.InvalidFileObjectSupport;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.util.RequestProcessor;

public final class SuspendableFileChangeListener
implements FileChangeListener {
    private static final RequestProcessor RP = new RequestProcessor("CND FileEvents redispatcher");
    private final RequestProcessor.Task task;
    private final FileChangeListener external;
    private int suspendCount = 0;
    private final Object eventsLock = new Object();
    private HashMap<FSPath, EventWrapper> events = new LinkedHashMap<FSPath, EventWrapper>();
    private final Runnable taskScheduler = new Runnable(){

        @Override
        public void run() {
            SuspendableFileChangeListener.this.task.schedule(0);
        }
    };

    public SuspendableFileChangeListener(FileChangeListener external) {
        this.task = RP.create((Runnable)new Worker(), true);
        this.external = external;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendRemoves() {
        Object object = this.eventsLock;
        synchronized (object) {
            CndUtils.assertTrue(this.suspendCount >= 0, "suspendRemoves with " + this.suspendCount);
            ++this.suspendCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeRemoves() {
        boolean schedule;
        Object object = this.eventsLock;
        synchronized (object) {
            CndUtils.assertTrue(this.suspendCount > 0, "resumeRemoves without suspendRemoves " + this.suspendCount);
            --this.suspendCount;
            if (this.suspendCount < 0) {
                this.suspendCount = 0;
            }
            schedule = this.suspendCount == 0;
        }
        if (schedule) {
            this.taskScheduler.run();
        }
    }

    public void fileChanged(FileEvent fe) {
        this.register(EventKind.FILE_CHANGED, fe);
    }

    public void fileDataCreated(FileEvent fe) {
        this.register(EventKind.FILE_CREATED, fe);
    }

    public void fileDeleted(FileEvent fe) {
        this.register(EventKind.FILE_DELETED, fe);
    }

    public void fileFolderCreated(FileEvent fe) {
        this.register(EventKind.FOLDER_CREATED, fe);
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileRenamed(FileRenameEvent fe) {
        FSPath newPath = FSPath.toFSPath(fe.getFile());
        String strPrevExt = fe.getExt() == null || fe.getExt().isEmpty() ? "" : "." + fe.getExt();
        String strPrevPath = CndPathUtilitities.getDirName(newPath.getPath()) + '/' + fe.getName() + strPrevExt;
        FSPath prevPath = new FSPath(newPath.getFileSystem(), strPrevPath);
        Object object = this.eventsLock;
        synchronized (object) {
            EventWrapper prevPathEvent = this.events.get(prevPath);
            FileObject removedFO = InvalidFileObjectSupport.getInvalidFileObject((FileSystem)prevPath.getFileSystem(), (CharSequence)prevPath.getPath());
            FileEvent deleteFE = new FileEvent((FileObject)fe.getSource(), removedFO, fe.isExpected(), fe.getTime());
            this.events.put(prevPath, SuspendableFileChangeListener.convert(prevPathEvent, EventKind.FILE_DELETED, deleteFE));
            EventWrapper prevNewEvent = this.events.get(newPath);
            this.events.put(newPath, SuspendableFileChangeListener.convert(prevNewEvent, EventKind.FILE_CREATED, (FileEvent)fe));
        }
        fe.runWhenDeliveryOver(this.taskScheduler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(EventKind kind, FileEvent fe) {
        FSPath path = FSPath.toFSPath(fe.getFile());
        Object object = this.eventsLock;
        synchronized (object) {
            EventWrapper prev = this.events.get(path);
            this.events.put(path, SuspendableFileChangeListener.convert(prev, kind, fe));
        }
        fe.runWhenDeliveryOver(this.taskScheduler);
    }

    void flush() {
        this.task.schedule(0);
        this.task.waitFinished();
    }

    private static EventWrapper doAssert(EventWrapper prev, EventWrapper cur) {
        CndUtils.assertTrueInConsole(false, "invalid states " + prev + " " + cur);
        return cur;
    }

    private static EventWrapper doNull(EventWrapper prev, EventWrapper cur) {
        return new EventWrapper(EventKind.NULL, cur.event);
    }

    private static EventWrapper doChanged(EventWrapper prev, EventWrapper cur) {
        return new EventWrapper(EventKind.FILE_CHANGED, cur.event);
    }

    private static EventWrapper doNullOnRename(EventWrapper prev, EventWrapper cur) {
        throw new UnsupportedOperationException();
    }

    private static EventWrapper convert(EventWrapper prev, EventKind kind, FileEvent fe) {
        EventWrapper cur = new EventWrapper(kind, fe);
        if (prev == null || prev.kind == EventKind.NULL) {
            return cur;
        }
        switch (cur.kind) {
            case FILE_DELETED: {
                switch (prev.kind) {
                    case FILE_DELETED: {
                        return prev;
                    }
                    case FILE_CREATED: {
                        return SuspendableFileChangeListener.doNull(prev, cur);
                    }
                    case FILE_RENAMED_CREATED: {
                        return SuspendableFileChangeListener.doNull(prev, cur);
                    }
                    case FILE_RENAMED_DELETED: {
                        return SuspendableFileChangeListener.doAssert(prev, cur);
                    }
                    case FOLDER_CREATED: {
                        return SuspendableFileChangeListener.doNull(prev, cur);
                    }
                    case FILE_CHANGED: {
                        return cur;
                    }
                    case FILE_ATTRIBUTE_CHANGED: {
                        return cur;
                    }
                }
                throw new IllegalArgumentException("unexpected " + (Object)((Object)prev.kind));
            }
            case FILE_CREATED: {
                switch (prev.kind) {
                    case FILE_DELETED: {
                        return SuspendableFileChangeListener.doChanged(prev, cur);
                    }
                    case FILE_CREATED: {
                        return prev;
                    }
                    case FILE_RENAMED_CREATED: {
                        return SuspendableFileChangeListener.doAssert(prev, cur);
                    }
                    case FILE_RENAMED_DELETED: {
                        return SuspendableFileChangeListener.doChanged(prev, cur);
                    }
                    case FOLDER_CREATED: {
                        return SuspendableFileChangeListener.doAssert(prev, cur);
                    }
                    case FILE_CHANGED: {
                        return prev;
                    }
                    case FILE_ATTRIBUTE_CHANGED: {
                        return SuspendableFileChangeListener.doAssert(prev, cur);
                    }
                }
                throw new AssertionError((Object)prev.kind);
            }
            case FILE_RENAMED_CREATED: {
                switch (prev.kind) {
                    case FILE_DELETED: {
                        return SuspendableFileChangeListener.doChanged(prev, cur);
                    }
                    case FILE_CREATED: {
                        return SuspendableFileChangeListener.doAssert(prev, cur);
                    }
                    case FILE_RENAMED_CREATED: {
                        return SuspendableFileChangeListener.doAssert(prev, cur);
                    }
                    case FILE_RENAMED_DELETED: {
                        return SuspendableFileChangeListener.doChanged(prev, cur);
                    }
                    case FOLDER_CREATED: {
                        return SuspendableFileChangeListener.doAssert(prev, cur);
                    }
                    case FILE_CHANGED: {
                        return SuspendableFileChangeListener.doAssert(prev, cur);
                    }
                    case FILE_ATTRIBUTE_CHANGED: {
                        return SuspendableFileChangeListener.doAssert(prev, cur);
                    }
                }
                throw new AssertionError((Object)prev.kind);
            }
            case FILE_RENAMED_DELETED: {
                switch (prev.kind) {
                    case FILE_DELETED: {
                        return SuspendableFileChangeListener.doAssert(prev, cur);
                    }
                    case FILE_CREATED: {
                        return SuspendableFileChangeListener.doNullOnRename(prev, cur);
                    }
                    case FILE_RENAMED_CREATED: {
                        return SuspendableFileChangeListener.doNullOnRename(prev, cur);
                    }
                    case FILE_RENAMED_DELETED: {
                        return SuspendableFileChangeListener.doAssert(prev, cur);
                    }
                    case FOLDER_CREATED: {
                        return SuspendableFileChangeListener.doNullOnRename(prev, cur);
                    }
                    case FILE_CHANGED: {
                        return cur;
                    }
                    case FILE_ATTRIBUTE_CHANGED: {
                        return cur;
                    }
                }
                throw new AssertionError((Object)prev.kind);
            }
            case FOLDER_CREATED: {
                switch (prev.kind) {
                    case FILE_DELETED: {
                        return SuspendableFileChangeListener.doChanged(prev, cur);
                    }
                    case FILE_CREATED: {
                        return SuspendableFileChangeListener.doAssert(prev, cur);
                    }
                    case FILE_RENAMED_CREATED: {
                        return SuspendableFileChangeListener.doAssert(prev, cur);
                    }
                    case FILE_RENAMED_DELETED: {
                        return SuspendableFileChangeListener.doChanged(prev, cur);
                    }
                    case FOLDER_CREATED: {
                        return cur;
                    }
                    case FILE_CHANGED: {
                        return prev;
                    }
                    case FILE_ATTRIBUTE_CHANGED: {
                        return SuspendableFileChangeListener.doAssert(prev, cur);
                    }
                }
                throw new IllegalArgumentException("unexpected " + (Object)((Object)prev.kind));
            }
            case FILE_CHANGED: {
                switch (prev.kind) {
                    case FILE_DELETED: {
                        return SuspendableFileChangeListener.doAssert(prev, cur);
                    }
                    case FILE_CREATED: {
                        return prev;
                    }
                    case FILE_RENAMED_CREATED: {
                        return prev;
                    }
                    case FILE_RENAMED_DELETED: {
                        return SuspendableFileChangeListener.doAssert(prev, cur);
                    }
                    case FOLDER_CREATED: {
                        return prev;
                    }
                    case FILE_CHANGED: {
                        return cur;
                    }
                    case FILE_ATTRIBUTE_CHANGED: {
                        return cur;
                    }
                }
                throw new IllegalArgumentException("unexpected " + (Object)((Object)prev.kind));
            }
            case FILE_ATTRIBUTE_CHANGED: {
                switch (prev.kind) {
                    case FILE_DELETED: {
                        return SuspendableFileChangeListener.doAssert(prev, cur);
                    }
                    case FILE_CREATED: {
                        return prev;
                    }
                    case FILE_RENAMED_CREATED: {
                        return prev;
                    }
                    case FILE_RENAMED_DELETED: {
                        return SuspendableFileChangeListener.doAssert(prev, cur);
                    }
                    case FOLDER_CREATED: {
                        return prev;
                    }
                    case FILE_CHANGED: {
                        return prev;
                    }
                    case FILE_ATTRIBUTE_CHANGED: {
                        return cur;
                    }
                }
                throw new IllegalArgumentException("unexpected " + (Object)((Object)prev.kind));
            }
        }
        throw new AssertionError((Object)prev.kind);
    }

    private static final class EventWrapper {
        private final EventKind kind;
        private final FileEvent event;
        private final boolean folder;
        private final EventWrapper prev;

        public EventWrapper(EventKind kind, FileEvent event) {
            this(kind, event, event.getFile().isFolder(), null);
        }

        public EventWrapper(EventKind kind, FileEvent event, boolean folder, EventWrapper prev) {
            this.kind = kind;
            this.event = event;
            this.folder = folder;
            this.prev = prev;
        }

        public String toString() {
            return "EventWrapper{kind=" + (Object)((Object)this.kind) + ", event=" + this.event + '}';
        }
    }

    private static enum EventKind {
        FILE_DELETED,
        FILE_CREATED,
        FILE_RENAMED_CREATED,
        FILE_RENAMED_DELETED,
        FOLDER_CREATED,
        FILE_CHANGED,
        FILE_ATTRIBUTE_CHANGED,
        NULL;

    }

    private final class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashMap curEvents;
            Object object = SuspendableFileChangeListener.this.eventsLock;
            synchronized (object) {
                if (SuspendableFileChangeListener.this.events.isEmpty()) {
                    return;
                }
                if (SuspendableFileChangeListener.this.suspendCount == 0) {
                    curEvents = SuspendableFileChangeListener.this.events;
                    SuspendableFileChangeListener.this.events = new LinkedHashMap();
                } else {
                    curEvents = SuspendableFileChangeListener.this.events;
                    LinkedHashMap suspendedRemoves = new LinkedHashMap();
                    Iterator it = curEvents.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        EventWrapper value = (EventWrapper)entry.getValue();
                        if (value.kind != EventKind.FILE_DELETED && (value.kind != EventKind.FILE_CREATED || !(value.event instanceof FileRenameEvent))) continue;
                        suspendedRemoves.put(entry.getKey(), value);
                        it.remove();
                    }
                    SuspendableFileChangeListener.this.events = suspendedRemoves;
                }
            }
            block14: for (EventWrapper eventWrapper : curEvents.values()) {
                FileEvent fe = eventWrapper.event;
                switch (eventWrapper.kind) {
                    case FILE_DELETED: {
                        SuspendableFileChangeListener.this.external.fileDeleted(fe);
                        continue block14;
                    }
                    case FILE_CREATED: {
                        SuspendableFileChangeListener.this.external.fileDataCreated(fe);
                        continue block14;
                    }
                    case FILE_RENAMED_CREATED: {
                        SuspendableFileChangeListener.this.external.fileRenamed((FileRenameEvent)fe);
                        continue block14;
                    }
                    case FILE_CHANGED: {
                        SuspendableFileChangeListener.this.external.fileChanged(fe);
                        continue block14;
                    }
                    case FILE_ATTRIBUTE_CHANGED: {
                        SuspendableFileChangeListener.this.external.fileAttributeChanged((FileAttributeEvent)fe);
                        continue block14;
                    }
                    case FOLDER_CREATED: {
                        SuspendableFileChangeListener.this.external.fileFolderCreated(fe);
                        continue block14;
                    }
                    case NULL: {
                        continue block14;
                    }
                    case FILE_RENAMED_DELETED: {
                        continue block14;
                    }
                }
                throw new AssertionError((Object)eventWrapper.kind.name());
            }
        }
    }
}

