/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.spi.utils;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.logging.Level;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.dlight.libs.common.InvalidFileObjectSupport;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public abstract class CndFileSystemProvider {
    private static final CndFileSystemProvider DEFAULT = new DefaultProvider();

    private static CndFileSystemProvider getDefault() {
        return DEFAULT;
    }

    public static void addFileSystemProblemListener(CndFileSystemProblemListener listener, FileSystem fileSystem) {
        CndFileSystemProvider.getDefault().addFileSystemProblemListenerImpl(listener, fileSystem);
    }

    public static void removeFileSystemProblemListener(CndFileSystemProblemListener listener, FileSystem fileSystem) {
        CndFileSystemProvider.getDefault().removeFileSystemProblemListenerImpl(listener, fileSystem);
    }

    public static File toFile(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null && fileObject != null && !fileObject.isValid()) {
            file = new File(fileObject.getPath());
        }
        return file;
    }

    public static FileObject toFileObject(File file) {
        return CndFileSystemProvider.getDefault().toFileObjectImpl(file);
    }

    public static Boolean exists(CharSequence path) {
        return CndFileSystemProvider.getDefault().existsImpl(path);
    }

    public static Boolean canRead(CharSequence path) {
        return CndFileSystemProvider.getDefault().canReadImpl(path);
    }

    public static FileInfo[] getChildInfo(CharSequence path) {
        return CndFileSystemProvider.getDefault().getChildInfoImpl(path);
    }

    public static FileObject toFileObject(CharSequence absPath) {
        FileObject result = CndFileSystemProvider.getDefault().toFileObjectImpl(absPath);
        CndUtils.assertNotNull(result, "Null file object for ", absPath);
        return result;
    }

    public static FileObject urlToFileObject(CharSequence url) {
        return CndFileSystemProvider.getDefault().urlToFileObjectImpl(url);
    }

    public static CharSequence toUrl(FSPath fsPath) {
        return CndFileSystemProvider.getDefault().toUrlImpl(fsPath);
    }

    public static CharSequence toUrl(FileSystem fileSystem, CharSequence absPath) {
        return CndFileSystemProvider.getDefault().toUrlImpl(fileSystem, absPath);
    }

    public static CharSequence fileObjectToUrl(FileObject fileObject) {
        CharSequence result = CndFileSystemProvider.getDefault().fileObjectToUrlImpl(fileObject);
        CndUtils.assertNotNull(result, "Null URL for file object ", fileObject);
        return result;
    }

    public static CharSequence getCanonicalPath(FileSystem fileSystem, CharSequence absPath) throws IOException {
        CndUtils.assertAbsolutePathInConsole(((Object)absPath).toString());
        return CndFileSystemProvider.getDefault().getCanonicalPathImpl(fileSystem, absPath);
    }

    public static FileObject getCanonicalFileObject(FileObject fo) throws IOException {
        return CndFileSystemProvider.getDefault().getCanonicalFileObjectImpl(fo);
    }

    public static String getCanonicalPath(FileObject fo) throws IOException {
        return CndFileSystemProvider.getDefault().getCanonicalPathImpl(fo);
    }

    public static String normalizeAbsolutePath(FileSystem fs, String absPath) {
        return CndFileSystemProvider.getDefault().normalizeAbsolutePathImpl(fs, absPath);
    }

    public static void addFileChangeListener(FileChangeListener listener) {
        CndFileSystemProvider.getDefault().addFileChangeListenerImpl(listener);
    }

    public static void addFileChangeListener(FileChangeListener listener, FileSystem fileSystem, String path) {
        CndFileSystemProvider.getDefault().addFileChangeListenerImpl(listener, fileSystem, path);
    }

    public static void removeFileChangeListener(FileChangeListener listener) {
        CndFileSystemProvider.getDefault().removeFileChangeListenerImpl(listener);
    }

    public static void removeFileChangeListener(FileChangeListener listener, FileSystem fileSystem, String path) {
        CndFileSystemProvider.getDefault().removeFileChangeListenerImpl(listener, fileSystem, path);
    }

    protected abstract Boolean existsImpl(CharSequence var1);

    protected abstract Boolean canReadImpl(CharSequence var1);

    protected abstract FileInfo[] getChildInfoImpl(CharSequence var1);

    protected abstract FileObject toFileObjectImpl(CharSequence var1);

    protected abstract CharSequence fileObjectToUrlImpl(FileObject var1);

    protected abstract CharSequence toUrlImpl(FSPath var1);

    protected abstract CharSequence toUrlImpl(FileSystem var1, CharSequence var2);

    protected abstract FileObject urlToFileObjectImpl(CharSequence var1);

    protected abstract FileObject toFileObjectImpl(File var1);

    protected abstract CharSequence getCanonicalPathImpl(FileSystem var1, CharSequence var2) throws IOException;

    protected abstract FileObject getCanonicalFileObjectImpl(FileObject var1) throws IOException;

    protected abstract String getCanonicalPathImpl(FileObject var1) throws IOException;

    protected abstract String normalizeAbsolutePathImpl(FileSystem var1, String var2);

    protected abstract boolean addFileChangeListenerImpl(FileChangeListener var1);

    protected abstract boolean removeFileChangeListenerImpl(FileChangeListener var1);

    protected abstract boolean addFileChangeListenerImpl(FileChangeListener var1, FileSystem var2, String var3);

    protected abstract boolean removeFileChangeListenerImpl(FileChangeListener var1, FileSystem var2, String var3);

    protected abstract void removeFileSystemProblemListenerImpl(CndFileSystemProblemListener var1, FileSystem var2);

    protected abstract void addFileSystemProblemListenerImpl(CndFileSystemProblemListener var1, FileSystem var2);

    private static class DefaultProvider
    extends CndFileSystemProvider {
        private static final String FILE_PROTOCOL_PREFIX = "file:";
        private CndFileSystemProvider[] cache;

        DefaultProvider() {
            Collection instances = Lookup.getDefault().lookupAll(CndFileSystemProvider.class);
            this.cache = instances.toArray(new CndFileSystemProvider[instances.size()]);
            CndUtils.assertTrueInConsole(this.cache.length > 0, "CndFileSystemProvider NOT FOUND");
        }

        @Override
        public FileObject toFileObjectImpl(CharSequence absPath) {
            FileObject fo;
            for (CndFileSystemProvider provider : this.cache) {
                fo = provider.toFileObjectImpl(absPath);
                if (fo == null) continue;
                return fo;
            }
            File file = new File(FileUtil.normalizePath((String)((Object)absPath).toString()));
            fo = FileUtil.toFileObject((File)file);
            if (fo == null) {
                fo = InvalidFileObjectSupport.getInvalidFileObject((File)file);
            }
            return fo;
        }

        @Override
        protected FileObject toFileObjectImpl(File file) {
            FileObject fo;
            for (CndFileSystemProvider provider : this.cache) {
                fo = provider.toFileObjectImpl(file);
                if (fo == null) continue;
                return fo;
            }
            fo = FileUtil.toFileObject((File)file);
            if (fo == null) {
                fo = InvalidFileObjectSupport.getInvalidFileObject((File)file);
            }
            return fo;
        }

        @Override
        protected Boolean canReadImpl(CharSequence path) {
            for (CndFileSystemProvider provider : this.cache) {
                Boolean result = provider.canReadImpl(path);
                if (result == null) continue;
                return result;
            }
            return new File(((Object)path).toString()).canRead();
        }

        @Override
        protected Boolean existsImpl(CharSequence path) {
            for (CndFileSystemProvider provider : this.cache) {
                Boolean result = provider.existsImpl(path);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Override
        protected FileInfo[] getChildInfoImpl(CharSequence path) {
            for (CndFileSystemProvider provider : this.cache) {
                FileInfo[] result = provider.getChildInfoImpl(path);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Override
        protected FileObject urlToFileObjectImpl(CharSequence url) {
            File file;
            for (CndFileSystemProvider provider : this.cache) {
                FileObject fo = provider.urlToFileObjectImpl(url);
                if (fo == null) continue;
                return fo;
            }
            String path = ((Object)url).toString();
            if (path.startsWith(FILE_PROTOCOL_PREFIX)) {
                try {
                    URL u = new URL(path);
                    file = FileUtil.normalizeFile((File)new File(u.toURI()));
                }
                catch (IllegalArgumentException ex) {
                    CndUtils.getLogger().log(Level.WARNING, "CndFileSystemProvider.urlToFileObjectImpl can not convert {0}:\n{1}", new Object[]{path, ex.getLocalizedMessage()});
                    return null;
                }
                catch (URISyntaxException ex) {
                    CndUtils.getLogger().log(Level.WARNING, "CndFileSystemProvider.urlToFileObjectImpl can not convert {0}:\n{1}", new Object[]{path, ex.getLocalizedMessage()});
                    return null;
                }
                catch (MalformedURLException ex) {
                    CndUtils.getLogger().log(Level.WARNING, "CndFileSystemProvider.urlToFileObjectImpl can not convert {0}:\n{1}", new Object[]{path, ex.getLocalizedMessage()});
                    return null;
                }
            } else {
                file = new File(FileUtil.normalizePath((String)path));
            }
            return FileUtil.toFileObject((File)file);
        }

        @Override
        protected CharSequence fileObjectToUrlImpl(FileObject fileObject) {
            for (CndFileSystemProvider provider : this.cache) {
                CharSequence path = provider.fileObjectToUrlImpl(fileObject);
                if (path == null) continue;
                return path;
            }
            return fileObject.getPath();
        }

        @Override
        protected CharSequence toUrlImpl(FSPath fSPath) {
            for (CndFileSystemProvider provider : this.cache) {
                CharSequence url = provider.toUrlImpl(fSPath);
                if (url == null) continue;
                return url;
            }
            return fSPath.getPath();
        }

        @Override
        protected CharSequence toUrlImpl(FileSystem fileSystem, CharSequence absPath) {
            for (CndFileSystemProvider provider : this.cache) {
                CharSequence url = provider.toUrlImpl(fileSystem, absPath);
                if (url == null) continue;
                return url;
            }
            return absPath;
        }

        @Override
        protected CharSequence getCanonicalPathImpl(FileSystem fileSystem, CharSequence absPath) throws IOException {
            for (CndFileSystemProvider provider : this.cache) {
                CharSequence canonical = provider.getCanonicalPathImpl(fileSystem, absPath);
                if (canonical == null) continue;
                return canonical;
            }
            return absPath;
        }

        @Override
        protected FileObject getCanonicalFileObjectImpl(FileObject fo) throws IOException {
            for (CndFileSystemProvider provider : this.cache) {
                FileObject canonical = provider.getCanonicalFileObjectImpl(fo);
                if (canonical == null) continue;
                return canonical;
            }
            return fo;
        }

        @Override
        protected String getCanonicalPathImpl(FileObject fo) throws IOException {
            for (CndFileSystemProvider provider : this.cache) {
                String canonical = provider.getCanonicalPathImpl(fo);
                if (canonical == null) continue;
                return canonical;
            }
            return fo.getPath();
        }

        @Override
        protected String normalizeAbsolutePathImpl(FileSystem fs, String absPath) {
            for (CndFileSystemProvider provider : this.cache) {
                String normalized = provider.normalizeAbsolutePathImpl(fs, absPath);
                if (normalized == null) continue;
                return normalized;
            }
            return absPath;
        }

        @Override
        protected boolean addFileChangeListenerImpl(FileChangeListener listener, FileSystem fileSystem, String path) {
            for (CndFileSystemProvider provider : this.cache) {
                if (!provider.addFileChangeListenerImpl(listener, fileSystem, path)) continue;
                return true;
            }
            if (CndFileUtils.isLocalFileSystem(fileSystem)) {
                FileUtil.addFileChangeListener((FileChangeListener)listener, (File)FileUtil.normalizeFile((File)new File(path)));
                return true;
            }
            return false;
        }

        @Override
        protected boolean removeFileChangeListenerImpl(FileChangeListener listener, FileSystem fileSystem, String path) {
            for (CndFileSystemProvider provider : this.cache) {
                if (!provider.removeFileChangeListenerImpl(listener, fileSystem, path)) continue;
                return true;
            }
            if (CndFileUtils.isLocalFileSystem(fileSystem)) {
                FileUtil.removeFileChangeListener((FileChangeListener)listener, (File)FileUtil.normalizeFile((File)new File(path)));
                return true;
            }
            return false;
        }

        @Override
        protected boolean addFileChangeListenerImpl(FileChangeListener listener) {
            for (CndFileSystemProvider provider : this.cache) {
                provider.addFileChangeListenerImpl(listener);
            }
            return true;
        }

        @Override
        protected boolean removeFileChangeListenerImpl(FileChangeListener listener) {
            for (CndFileSystemProvider provider : this.cache) {
                provider.removeFileChangeListenerImpl(listener);
            }
            return true;
        }

        @Override
        protected void addFileSystemProblemListenerImpl(CndFileSystemProblemListener listener, FileSystem fileSystem) {
            for (CndFileSystemProvider provider : this.cache) {
                provider.addFileSystemProblemListenerImpl(listener, fileSystem);
            }
        }

        @Override
        protected void removeFileSystemProblemListenerImpl(CndFileSystemProblemListener listener, FileSystem fileSystem) {
            for (CndFileSystemProvider provider : this.cache) {
                provider.removeFileSystemProblemListenerImpl(listener, fileSystem);
            }
        }
    }

    public static interface CndFileSystemProblemListener {
        public void problemOccurred(FSPath var1);

        public void recovered(FileSystem var1);
    }

    public static class FileInfo {
        public final String absolutePath;
        public final boolean directory;
        public final boolean file;

        public FileInfo(String absolutePath, boolean directory, boolean file) {
            this.absolutePath = absolutePath;
            this.directory = directory;
            this.file = file;
        }

        public String toString() {
            return "FileInfo{absolutePath=" + this.absolutePath + ",directory=" + this.directory + ",file=" + this.file + '}';
        }
    }
}

