/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.editor.bookmarks.ui.BookmarkNode;
import org.netbeans.modules.editor.bookmarks.ui.BookmarkNodeRenderer;
import org.netbeans.modules.editor.bookmarks.ui.BookmarksTableModel;
import org.netbeans.swing.etable.ETable;
import org.openide.util.NbBundle;

public class BookmarksTable
extends ETable {
    BookmarksTable() {
        super((TableModel)new BookmarksTableModel(false));
        this.init();
    }

    private void init() {
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.getTableHeader().setResizingAllowed(true);
        this.setAutoResizeMode(3);
        this.setSelectionMode(0);
        TableColumnModel colModel = this.getColumnModel();
        TableColumn col = colModel.getColumn(0);
        col.setHeaderValue(NbBundle.getMessage(BookmarksTable.class, (String)"LBL_BookmarkName"));
        col = colModel.getColumn(1);
        col.setHeaderValue(NbBundle.getMessage(BookmarksTable.class, (String)"LBL_BookmarkKey"));
        col = colModel.getColumn(2);
        col.setHeaderValue(NbBundle.getMessage(BookmarksTable.class, (String)"LBL_BookmarkLocation"));
        col.setCellRenderer(new BookmarkNodeRenderer(false));
        this.getTableHeader().addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                JTableHeader header = (JTableHeader)e.getSource();
                int columnIndex = header.columnAtPoint(e.getPoint());
                if (columnIndex != -1) {
                    header.setToolTipText(BookmarksTable.this.getHeaderToolTipText(columnIndex));
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getClickCount() == 2 || SwingUtilities.isRightMouseButton(e)) && BookmarksTable.this.getModel() instanceof BookmarksTableModel) {
                    BookmarksTableModel model = (BookmarksTableModel)BookmarksTable.this.getModel();
                    int row = ((JTable)e.getSource()).getSelectedRow();
                    BookmarkNode node = model.getEntry(row);
                    if (e.getClickCount() == 2) {
                        node.openInEditor();
                    } else if (SwingUtilities.isRightMouseButton(e)) {
                        node.getContextMenu().show((Component)((Object)BookmarksTable.this), e.getPoint().x, e.getPoint().y);
                    }
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "delete");
    }

    private String getHeaderToolTipText(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return NbBundle.getMessage(BookmarksTable.class, (String)"LBL_BookmarkNameDescription");
            }
            case 1: {
                return NbBundle.getMessage(BookmarksTable.class, (String)"LBL_BookmarkKeyDescription");
            }
            case 2: {
                return NbBundle.getMessage(BookmarksTable.class, (String)"LBL_BookmarkLocationDescription");
            }
        }
        return null;
    }

    public String getToolTipText(MouseEvent event) {
        Point p = event.getPoint();
        int hitColumnIndex = this.columnAtPoint(p);
        int hitRowIndex = this.rowAtPoint(p);
        String toolTipText = hitRowIndex != -1 && hitColumnIndex != -1 ? ((BookmarksTableModel)this.getModel()).getToolTipText(hitRowIndex, hitColumnIndex) : super.getToolTipText(event);
        return toolTipText;
    }
}

