/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.editor.bookmarks.BookmarkHistory;
import org.netbeans.modules.editor.bookmarks.BookmarkInfo;
import org.netbeans.modules.editor.bookmarks.BookmarkUtils;
import org.netbeans.modules.editor.bookmarks.ui.BookmarkNode;
import org.netbeans.modules.editor.bookmarks.ui.BookmarkNodeRenderer;
import org.netbeans.modules.editor.bookmarks.ui.BookmarksNodeTree;
import org.netbeans.modules.editor.bookmarks.ui.BookmarksTableModel;
import org.netbeans.modules.editor.bookmarks.ui.BookmarksView;
import org.openide.util.Utilities;

public final class BookmarkHistoryPopup
implements KeyListener {
    private static final Logger LOG = Logger.getLogger(BookmarkHistoryPopup.class.getName());
    private static BookmarkHistoryPopup INSTANCE = new BookmarkHistoryPopup();
    private JDialog popup;
    private JTable table;
    private BookmarksTableModel tableModel;
    private int selectedEntryIndex;
    private JLabel descriptionLabel;
    private Component lastFocusedComponent;
    private int keepOpenedModifiers;
    private KeyStroke gotoNextKeyStroke;
    private KeyStroke gotoPreviousKeyStroke;

    public static BookmarkHistoryPopup get() {
        return INSTANCE;
    }

    private BookmarkHistoryPopup() {
    }

    public void show(boolean chooseLastUsedBookmark) {
        if (this.popup != null) {
            this.hide();
        }
        this.lastFocusedComponent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        this.gotoPreviousKeyStroke = BookmarkUtils.findKeyStroke("bookmark.history.popup.previous");
        if (this.gotoPreviousKeyStroke != null) {
            this.keepOpenedModifiers = BookmarkHistoryPopup.modifiersBits(this.gotoPreviousKeyStroke.getModifiers());
            this.gotoNextKeyStroke = BookmarkUtils.findKeyStroke("bookmark.history.popup.next");
        } else {
            this.keepOpenedModifiers = 0;
        }
        this.descriptionLabel = new JLabel();
        this.descriptionLabel.setBorder(new EmptyBorder(2, 2, 2, 2));
        Font font = this.descriptionLabel.getFont();
        font = new Font(font.getName(), font.getStyle(), (int)(0.9f * (float)font.getSize()));
        this.descriptionLabel.setFont(font);
        this.selectedEntryIndex = -1;
        this.table = this.createTable();
        this.table.setBorder(new LineBorder(this.table.getForeground()));
        Rectangle screenBounds = Utilities.getUsableScreenBounds();
        this.initTable(screenBounds);
        this.selectEntry(chooseLastUsedBookmark ? 0 : this.tableModel.getEntryCount() - 1);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = -1;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        panel.add((Component)this.table, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = -1;
        constraints.anchor = 18;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        panel.add((Component)new JSeparator(0), constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = -1;
        constraints.anchor = 18;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        panel.add((Component)this.descriptionLabel, constraints);
        panel.setBorder(new LineBorder(Color.black, 1));
        Dimension prefSize = panel.getPreferredSize();
        int x = screenBounds.x + (screenBounds.width - prefSize.width) / 2;
        int y = screenBounds.y + (screenBounds.height - prefSize.height) / 2;
        this.popup = new JDialog();
        this.popup.setModal(true);
        this.popup.setAlwaysOnTop(true);
        this.popup.setUndecorated(true);
        this.popup.getContentPane().add(this.table);
        this.popup.setLocation(x, y);
        this.popup.pack();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "BookmarkHistoryPopup.show: keepOpenedModifiers={0} bounds={1}\n", new Object[]{this.keepOpenedModifiers, this.popup.getBounds()});
        }
        this.popup.setVisible(true);
    }

    public void hide() {
        if (this.popup != null) {
            this.table.removeKeyListener(this);
            this.popup.setVisible(false);
            this.popup.dispose();
            this.popup = null;
            this.table = null;
            this.tableModel = null;
            this.descriptionLabel = null;
        }
    }

    private JTable createTable() {
        List<BookmarkInfo> historyBookmarks = BookmarkHistory.get().historyBookmarks();
        BookmarksNodeTree nodeTree = new BookmarksNodeTree();
        Map<BookmarkInfo, BookmarkNode> bookmark2NodeMap = nodeTree.createBookmark2NodeMap();
        ArrayList<BookmarkNode> entries = new ArrayList<BookmarkNode>(historyBookmarks.size() + 1);
        entries.add(bookmark2NodeMap.get(BookmarkInfo.BOOKMARKS_WINDOW));
        for (BookmarkInfo bookmark : historyBookmarks) {
            entries.add(bookmark2NodeMap.get(bookmark));
        }
        Collections.reverse(entries);
        this.tableModel = new BookmarksTableModel(true);
        assert (!entries.contains(null));
        this.tableModel.setEntries(entries);
        return new JTable(this.tableModel);
    }

    private void initTable(Rectangle maxBounds) {
        this.table.setShowGrid(false);
        this.table.setCellSelectionEnabled(true);
        this.table.setAutoscrolls(false);
        BufferedImage image = new BufferedImage(4, 4, 1);
        Graphics2D g = (Graphics2D)image.getGraphics();
        Font font = this.table.getFont();
        FontMetrics fm = g.getFontMetrics(font);
        int maxWidth = 1;
        int maxHeight = fm.getHeight() + 2;
        for (int i = this.tableModel.getEntryCount() - 1; i >= 0; --i) {
            String value = (String)this.tableModel.getValueAt(i, 0);
            int stringWidth = fm.stringWidth(value);
            maxWidth = Math.max(maxWidth, stringWidth);
        }
        maxWidth += 16;
        maxWidth += 12;
        int columnEntryCount = maxBounds.height / maxHeight;
        int columnCount = this.tableModel.setColumnEntryCount(columnEntryCount);
        this.table.setTableHeader(null);
        BookmarkNodeRenderer cellRenderer = new BookmarkNodeRenderer(true);
        TableColumnModel columnModel = this.table.getColumnModel();
        TableColumn column = columnModel.getColumn(0);
        column.setCellRenderer(cellRenderer);
        column.setPreferredWidth(maxWidth);
        while (columnModel.getColumnCount() < columnCount) {
            column = new TableColumn(columnModel.getColumnCount());
            column.setPreferredWidth(maxWidth);
            column.setCellRenderer(cellRenderer);
            columnModel.addColumn(column);
        }
        this.table.addKeyListener(this);
    }

    private void selectEntry(int entryIndex) {
        assert (entryIndex >= 0) : "entryIndex=" + entryIndex + " < 0";
        int[] rowColumn = new int[2];
        if (this.selectedEntryIndex != -1) {
            this.tableModel.entryIndex2rowColumn(this.selectedEntryIndex, rowColumn);
            this.table.changeSelection(rowColumn[0], rowColumn[1], true, false);
        }
        this.selectedEntryIndex = entryIndex;
        this.tableModel.entryIndex2rowColumn(this.selectedEntryIndex, rowColumn);
        this.table.changeSelection(rowColumn[0], rowColumn[1], true, false);
        this.descriptionLabel.setText(this.tableModel.getToolTipText(rowColumn[0], rowColumn[1]));
        Dimension labelSize = this.descriptionLabel.getSize();
        if (labelSize != null && this.descriptionLabel.getPreferredSize().width > labelSize.width) {
            this.descriptionLabel.revalidate();
        }
    }

    private void selectNext() {
        int nextIndex = (this.selectedEntryIndex + 1) % this.tableModel.getEntryCount();
        this.selectEntry(nextIndex);
    }

    private void selectPrevious() {
        int prevIndex = this.selectedEntryIndex <= 0 ? this.tableModel.getEntryCount() - 1 : this.selectedEntryIndex - 1;
        this.selectEntry(prevIndex);
    }

    private void openBookmark(BookmarkInfo bookmark) {
        if (bookmark != null) {
            if (bookmark == BookmarkInfo.BOOKMARKS_WINDOW) {
                BookmarksView.openView();
            } else {
                BookmarkUtils.postOpenEditor(bookmark);
            }
        }
    }

    private BookmarkInfo getSelectedBookmark() {
        return this.selectedEntryIndex != -1 ? this.tableModel.getEntry(this.selectedEntryIndex).getBookmarkInfo() : null;
    }

    private void returnFocus() {
        if (this.lastFocusedComponent != null) {
            this.lastFocusedComponent.requestFocus();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("BookmarkHistoryPopup.keyPressed: e=" + e + '\n');
        }
        int keyCode = e.getKeyCode();
        if (this.gotoPreviousKeyStroke != null && this.gotoPreviousKeyStroke.getKeyCode() == keyCode) {
            e.consume();
            this.selectNext();
        } else if (this.gotoNextKeyStroke != null && this.gotoNextKeyStroke.getKeyCode() == keyCode) {
            e.consume();
            this.selectPrevious();
        } else {
            switch (keyCode) {
                case 10: {
                    BookmarkInfo selectedBookmark = this.getSelectedBookmark();
                    this.hide();
                    this.openBookmark(selectedBookmark);
                    e.consume();
                    break;
                }
                case 27: {
                    e.consume();
                    this.hide();
                    this.returnFocus();
                    break;
                }
                case 40: {
                    e.consume();
                    this.selectNext();
                    break;
                }
                case 38: {
                    e.consume();
                    this.selectPrevious();
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int modBits = BookmarkHistoryPopup.modifiersBits(e.getModifiersEx());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("BookmarkHistoryPopup.keyReleased: e=" + e + ", modBits=" + modBits + '\n');
        }
        if (this.keepOpenedModifiers != 0 && (modBits & this.keepOpenedModifiers) != this.keepOpenedModifiers) {
            e.consume();
            BookmarkInfo selectedBookmark = this.getSelectedBookmark();
            this.hide();
            this.openBookmark(selectedBookmark);
        }
    }

    private static int modifiersBits(int modifiers) {
        return modifiers & 0x3C0;
    }
}

