/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.bookmarks.api;

import java.lang.ref.Reference;
import java.text.MessageFormat;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.text.Document;
import org.netbeans.lib.editor.bookmarks.api.BookmarkList;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.bookmarks.BookmarkAPIAccessor;
import org.netbeans.modules.editor.bookmarks.BookmarkInfo;
import org.netbeans.modules.editor.bookmarks.BookmarkUtils;
import org.openide.loaders.DataObject;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public final class Bookmark {
    public static final String BOOKMARK_ANNOTATION_TYPE = "editor-bookmark";
    private static Map<Line, Reference<AAnnotation>> lineToAnnotation;
    private BookmarkList bookmarkList;
    private boolean released;
    private final BookmarkInfo info;
    private Line line;
    private AAnnotation annotation;

    Bookmark(BookmarkList bookmarkList, BookmarkInfo info, int offset) {
        if (info == null) {
            throw new IllegalArgumentException("info cannot be null");
        }
        this.bookmarkList = bookmarkList;
        this.info = info;
        Document document = bookmarkList.getDocument();
        int lineIndex = BookmarkUtils.offset2LineIndex(document, offset);
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)document);
        for (Line _line : lineToAnnotation.keySet()) {
            if (_line.getLineNumber() != lineIndex || !((DataObject)_line.getLookup().lookup(DataObject.class)).equals(dataObject)) continue;
            this.line = _line;
            Reference<AAnnotation> annoRef = lineToAnnotation.get(_line);
            this.annotation = annoRef.get();
            if (this.annotation == null) continue;
            return;
        }
        this.line = NbEditorUtilities.getLine((Document)bookmarkList.getDocument(), (int)offset, (boolean)false);
        if (this.line != null) {
            this.annotation = new AAnnotation();
            this.annotation.attach((Annotatable)this.line);
        }
    }

    String getName() {
        return this.info.getName();
    }

    public int getOffset() {
        return BookmarkUtils.lineIndex2Offset(this.bookmarkList.getDocument(), this.line.getLineNumber());
    }

    public int getLineNumber() {
        return this.line.getLineNumber();
    }

    public String getKey() {
        return this.info.getKey();
    }

    public BookmarkList getList() {
        return this.bookmarkList;
    }

    public boolean isReleased() {
        return this.released;
    }

    void release() {
        assert (!this.released);
        this.released = true;
        this.annotation.detach();
        lineToAnnotation.remove(this.line);
    }

    BookmarkInfo info() {
        return this.info;
    }

    public String toString() {
        return "Bookmark: " + this.info + "\n";
    }

    static {
        BookmarkAPIAccessor.INSTANCE = new BookmarkAPIAccessorImpl();
        lineToAnnotation = new WeakHashMap<Line, Reference<AAnnotation>>();
    }

    private static final class BookmarkAPIAccessorImpl
    extends BookmarkAPIAccessor {
        private BookmarkAPIAccessorImpl() {
        }

        @Override
        public BookmarkInfo getInfo(Bookmark b) {
            return b.info();
        }

        @Override
        public Bookmark getBookmark(Document doc, BookmarkInfo b) {
            return BookmarkList.get(doc).getBookmark(b);
        }
    }

    public final class AAnnotation
    extends Annotation {
        public String getAnnotationType() {
            return Bookmark.BOOKMARK_ANNOTATION_TYPE;
        }

        public String getShortDescription() {
            String fmt = NbBundle.getBundle(Bookmark.class).getString("Bookmark_Tooltip");
            int lineIndex = Bookmark.this.getLineNumber();
            return MessageFormat.format(fmt, lineIndex + 1);
        }

        public String toString() {
            return this.getShortDescription();
        }
    }
}

