/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.bookmarks.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.bookmarks.api.Bookmark;
import org.netbeans.lib.editor.bookmarks.api.BookmarkList;
import org.openide.awt.Actions;
import org.openide.cookies.EditorCookie;
import org.openide.text.NbDocument;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public final class ToggleBookmarkAction
extends AbstractAction
implements ContextAwareAction,
Presenter.Toolbar {
    private static final String ACTION_NAME = "bookmark-toggle";
    private static final String ACTION_ICON = "org/netbeans/modules/editor/bookmarks/resources/toggle_bookmark.png";
    private final JTextComponent component;

    public ToggleBookmarkAction() {
        this((JTextComponent)null);
    }

    public ToggleBookmarkAction(JTextComponent component) {
        super(NbBundle.getMessage(ToggleBookmarkAction.class, (String)ACTION_NAME), ImageUtilities.loadImageIcon((String)ACTION_ICON, (boolean)false));
        this.putValue("ShortDescription", Actions.cutAmpersand((String)((String)this.getValue("Name"))));
        this.putValue("noIconInMenu", Boolean.TRUE);
        this.component = component;
        this.updateEnabled();
        EditorRegistryListener editorRegistryListener = new EditorRegistryListener(this);
        EditorRegistry.addPropertyChangeListener((PropertyChangeListener)editorRegistryListener);
    }

    private void updateEnabled() {
        this.setEnabled(this.isEnabled());
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        JTextComponent jtc = ToggleBookmarkAction.findComponent(actionContext);
        return new ToggleBookmarkAction(jtc);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.component != null) {
            ToggleBookmarkAction.actionPerformed(this.component);
        } else {
            JTextComponent jtc = ToggleBookmarkAction.findComponent(Utilities.actionsGlobalContext());
            if (jtc != null) {
                ToggleBookmarkAction.actionPerformed(jtc);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.component != null) {
            return true;
        }
        return EditorRegistry.lastFocusedComponent() != null;
    }

    public Component getToolbarPresenter() {
        AbstractButton b;
        if (this.component != null) {
            b = new MyGaGaButton();
            b.setModel(new BookmarkButtonModel(this.component));
        } else {
            b = new JButton();
        }
        b.putClientProperty("hideActionText", Boolean.TRUE);
        b.setAction(this);
        return b;
    }

    public static JTextComponent findComponent(Lookup lookup) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        return ec == null ? null : NbDocument.findRecentEditorPane((EditorCookie)ec);
    }

    private static void actionPerformed(JTextComponent target) {
        if (target != null) {
            if (org.netbeans.editor.Utilities.getEditorUI((JTextComponent)target).isGlyphGutterVisible()) {
                Caret caret = target.getCaret();
                BookmarkList bookmarkList = BookmarkList.get(target.getDocument());
                bookmarkList.toggleLineBookmark(caret.getDot());
            } else {
                target.getToolkit().beep();
            }
        }
    }

    private static final class EditorRegistryListener
    implements PropertyChangeListener {
        private final Reference<ToggleBookmarkAction> actionRef;

        EditorRegistryListener(ToggleBookmarkAction action) {
            this.actionRef = new WeakReference<ToggleBookmarkAction>(action);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ToggleBookmarkAction action = this.actionRef.get();
            if (action != null) {
                action.updateEnabled();
            } else {
                EditorRegistry.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }

    private static final class MyGaGaButton
    extends JToggleButton
    implements ChangeListener {
        @Override
        public void setModel(ButtonModel model) {
            ButtonModel oldModel = this.getModel();
            if (oldModel != null) {
                oldModel.removeChangeListener(this);
            }
            super.setModel(model);
            ButtonModel newModel = this.getModel();
            if (newModel != null) {
                newModel.addChangeListener(this);
            }
            this.stateChanged(null);
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            boolean selected = this.isSelected();
            super.setContentAreaFilled(selected);
            super.setBorderPainted(selected);
        }

        @Override
        public void setBorderPainted(boolean arg0) {
            if (!this.isSelected()) {
                super.setBorderPainted(arg0);
            }
        }

        @Override
        public void setContentAreaFilled(boolean arg0) {
            if (!this.isSelected()) {
                super.setContentAreaFilled(arg0);
            }
        }
    }

    private static final class BookmarkButtonModel
    extends JToggleButton.ToggleButtonModel
    implements PropertyChangeListener,
    ChangeListener {
        private final JTextComponent component;
        private Caret caret;
        private BookmarkList bookmarks;
        private int lastCurrentLineStartOffset = -1;
        private PropertyChangeListener bookmarksListener = null;
        private ChangeListener caretListener = null;

        public BookmarkButtonModel(JTextComponent component) {
            this.component = component;
            this.component.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.component));
            this.rebuild();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == null || "document".equals(evt.getPropertyName()) || "caret".equals(evt.getPropertyName())) {
                this.rebuild();
            } else if ("bookmarks".equals(evt.getPropertyName())) {
                this.lastCurrentLineStartOffset = -1;
                this.updateState();
            }
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            this.updateState();
        }

        private static boolean isBookmarkOnTheLine(BookmarkList bookmarks, int lineStartOffset) {
            Bookmark bm = bookmarks.getNextBookmark(lineStartOffset - 1, false);
            return bm == null ? false : lineStartOffset == bm.getOffset();
        }

        private void rebuild() {
            Caret newCaret;
            BookmarkList newBookmarks = BookmarkList.get(this.component.getDocument());
            if (newBookmarks != this.bookmarks) {
                if (this.bookmarksListener != null) {
                    this.bookmarks.removePropertyChangeListener(this.bookmarksListener);
                    this.bookmarksListener = null;
                }
                this.bookmarks = newBookmarks;
                if (this.bookmarks != null) {
                    this.bookmarksListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.bookmarks);
                    this.bookmarks.addPropertyChangeListener(this.bookmarksListener);
                }
            }
            if ((newCaret = this.component.getCaret()) != this.caret) {
                if (this.caretListener != null) {
                    this.caret.removeChangeListener(this.caretListener);
                    this.caretListener = null;
                }
                this.caret = newCaret;
                if (this.caret != null) {
                    this.caretListener = WeakListeners.change((ChangeListener)this, (Object)this.caret);
                    this.caret.addChangeListener(this.caretListener);
                }
            }
            this.lastCurrentLineStartOffset = -1;
            this.updateState();
        }

        private void updateState() {
            Document doc = this.component.getDocument();
            if (this.caret != null && this.bookmarks != null && doc instanceof BaseDocument) {
                try {
                    int currentLineStartOffset = org.netbeans.editor.Utilities.getRowStart((BaseDocument)((BaseDocument)doc), (int)this.caret.getDot());
                    if (currentLineStartOffset != this.lastCurrentLineStartOffset) {
                        this.lastCurrentLineStartOffset = currentLineStartOffset;
                        boolean selected = BookmarkButtonModel.isBookmarkOnTheLine(this.bookmarks, currentLineStartOffset);
                        this.setSelected(selected);
                    }
                }
                catch (BadLocationException e) {
                    this.lastCurrentLineStartOffset = -1;
                }
            }
        }
    }
}

