/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.wizard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.groovy.support.wizard.JUnit;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public abstract class ProjectTypeStrategy {
    protected final Project project;
    protected JUnit jUnitVersion;

    protected ProjectTypeStrategy(Project project) {
        this.project = project;
    }

    protected abstract boolean existsGroovyTestFolder(List<SourceGroup> var1);

    protected abstract boolean existsGroovySourceFolder(List<SourceGroup> var1);

    protected abstract void createGroovyTestFolder();

    protected abstract void createGroovySourceFolder();

    protected abstract List<SourceGroup> moveTestFolderAsFirst(List<SourceGroup> var1);

    protected abstract List<SourceGroup> moveSourceFolderAsFirst(List<SourceGroup> var1);

    protected final List<SourceGroup> getOnlyTestSourceGroups(List<SourceGroup> groups) {
        ArrayList<SourceGroup> reorderedGroup = new ArrayList<SourceGroup>();
        for (SourceGroup group : groups) {
            String groupPath = group.getRootFolder().getPath();
            if (!groupPath.endsWith("/test") && !groupPath.contains("/test/")) continue;
            reorderedGroup.add(group);
        }
        return reorderedGroup;
    }

    protected final List<SourceGroup> moveAsFirst(List<SourceGroup> groups, String folderName) {
        ArrayList<SourceGroup> reorderedGroup = new ArrayList<SourceGroup>();
        for (SourceGroup group : groups) {
            if (group.getRootFolder().getPath().contains(folderName)) {
                reorderedGroup.add(0, group);
                continue;
            }
            reorderedGroup.add(group);
        }
        return reorderedGroup;
    }

    public abstract JUnit findJUnitVersion();

    public abstract void addJUnitLibrary(JUnit var1);

    public final void setjUnitVersion(JUnit jUnitVersion) {
        this.jUnitVersion = jUnitVersion;
    }

    protected FileObject findTemplate(WizardDescriptor wizardDescriptor) {
        FileObject templatesParent = Templates.getTemplate((WizardDescriptor)wizardDescriptor).getParent();
        if (this.jUnitVersion == JUnit.JUNIT4) {
            return this.lookForJUnitTemplate(templatesParent, 4);
        }
        if (this.jUnitVersion == JUnit.JUNIT3) {
            return this.lookForJUnitTemplate(templatesParent, 3);
        }
        return null;
    }

    private FileObject lookForJUnitTemplate(FileObject templatesParent, int majorVersion) {
        String templateName = "GroovyJUnit" + majorVersion + "Test.groovy";
        for (FileObject child : templatesParent.getChildren()) {
            if (!templateName.equals(child.getNameExt())) continue;
            return child;
        }
        return null;
    }

    protected final FileObject createFolder(FileObject parentFolder, String folderName) {
        FileObject childFolder = parentFolder.getFileObject(folderName, null);
        if (childFolder == null || !childFolder.isValid()) {
            try {
                return parentFolder.createFolder(folderName);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return childFolder;
    }
}

