/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.groovy.support.api.GroovySources;
import org.netbeans.modules.groovy.support.spi.GroovyExtender;
import org.netbeans.modules.groovy.support.wizard.GroovyFileWizardIterator;
import org.netbeans.modules.groovy.support.wizard.JUnit;
import org.netbeans.modules.gsf.testrunner.api.SelfResizingPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public final class GroovyJUnitTestWizardIterator
extends GroovyFileWizardIterator {
    private static final ResourceBundle BUNDLE = NbBundle.getBundle(GroovyJUnitTestWizardIterator.class);

    private GroovyJUnitTestWizardIterator() {
    }

    @Override
    protected List<SourceGroup> getOrderedSourcesGroups(WizardDescriptor wizardDescriptor, List<SourceGroup> groups) {
        List<SourceGroup> testSourceGroups;
        if (!this.strategy.existsGroovyTestFolder(groups)) {
            this.strategy.createGroovyTestFolder();
            groups = GroovySources.getGroovySourceGroups(ProjectUtils.getSources((Project)this.project));
        }
        if (!(testSourceGroups = this.strategy.getOnlyTestSourceGroups(groups)).isEmpty()) {
            return testSourceGroups;
        }
        return groups;
    }

    @Override
    public Set instantiate(ProgressHandle handle) throws IOException {
        handle.start();
        handle.progress(NbBundle.getMessage(GroovyJUnitTestWizardIterator.class, (String)"LBL_NewGroovyFileWizardIterator_WizardProgress_CreatingFile"));
        JUnit currentJUnit = this.strategy.findJUnitVersion();
        if (currentJUnit == JUnit.NOT_DECLARED) {
            JUnit jUnitToUse = this.askUserWhichJUnitToUse();
            if (jUnitToUse == null) {
                return Collections.emptySet();
            }
            this.strategy.setjUnitVersion(jUnitToUse);
            this.strategy.addJUnitLibrary(jUnitToUse);
        } else {
            this.strategy.setjUnitVersion(currentJUnit);
        }
        FileObject template = this.strategy.findTemplate(this.wiz);
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wiz);
        String targetName = Templates.getTargetName((WizardDescriptor)this.wiz);
        DataFolder dFolder = DataFolder.findFolder((FileObject)targetFolder);
        DataObject dTemplate = DataObject.find((FileObject)template);
        String pkgName = GroovyJUnitTestWizardIterator.getPackageName(targetFolder);
        DataObject dobj = pkgName == null ? dTemplate.createFromTemplate(dFolder, targetName) : dTemplate.createFromTemplate(dFolder, targetName, Collections.singletonMap("package", pkgName));
        FileObject createdFile = dobj.getPrimaryFile();
        GroovyExtender extender = (GroovyExtender)Templates.getProject((WizardDescriptor)this.wiz).getLookup().lookup(GroovyExtender.class);
        if (extender != null && !extender.isActive()) {
            extender.activate();
        }
        handle.finish();
        return Collections.singleton(createdFile);
    }

    private JUnit askUserWhichJUnitToUse() {
        JRadioButton radioButtonForJUnit3 = new JRadioButton();
        JRadioButton radioButtonForJUnit4 = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)radioButtonForJUnit3, (String)BUNDLE.getString("LBL_JUnit3_generator"));
        Mnemonics.setLocalizedText((AbstractButton)radioButtonForJUnit4, (String)BUNDLE.getString("LBL_JUnit4_generator"));
        radioButtonForJUnit3.getAccessibleContext().setAccessibleDescription(BUNDLE.getString("AD_JUnit3_generator"));
        radioButtonForJUnit4.getAccessibleContext().setAccessibleDescription(BUNDLE.getString("AD_JUnit4_generator"));
        ButtonGroup group = new ButtonGroup();
        group.add(radioButtonForJUnit3);
        group.add(radioButtonForJUnit4);
        radioButtonForJUnit4.setSelected(true);
        JTextComponent msg = this.createMultilineLabel(BUNDLE.getString("MSG_select_junit_version"));
        JPanel choicePanel = new JPanel(new GridLayout(0, 1, 0, 3));
        choicePanel.add(radioButtonForJUnit3);
        choicePanel.add(radioButtonForJUnit4);
        JPanel panel = new JPanel(new BorderLayout(0, 12));
        panel.add((Component)msg, "North");
        panel.add((Component)choicePanel, "Center");
        JButton button = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)button, (String)BUNDLE.getString("LBL_Select"));
        button.getAccessibleContext().setAccessibleDescription("AD_Select");
        button.getAccessibleContext().setAccessibleName("AN_Select");
        Object answer = DialogDisplayer.getDefault().notify((NotifyDescriptor)new DialogDescriptor((Object)GroovyJUnitTestWizardIterator.wrapDialogContent(panel), BUNDLE.getString("LBL_title_select_generator"), true, new Object[]{button, NotifyDescriptor.CANCEL_OPTION}, (Object)button, 0, null, (ActionListener)null));
        if (answer == button) {
            if (radioButtonForJUnit3.isSelected()) {
                return JUnit.JUNIT3;
            }
            return JUnit.JUNIT4;
        }
        return null;
    }

    private JTextComponent createMultilineLabel(String text) {
        JTextArea textArea = new JTextArea(text);
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEnabled(false);
        textArea.setOpaque(false);
        textArea.setColumns(25);
        textArea.setDisabledTextColor(new JLabel().getForeground());
        return textArea;
    }

    private static JComponent wrapDialogContent(JComponent comp) {
        SelfResizingPanel result = new SelfResizingPanel();
        result.setLayout(new GridLayout());
        result.add(comp);
        result.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        result.getAccessibleContext().setAccessibleDescription(BUNDLE.getString("AD_title_select_generator"));
        return result;
    }
}

