/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.wizard;

import java.awt.Component;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.groovy.support.api.GroovySources;
import org.netbeans.modules.groovy.support.spi.GroovyExtender;
import org.netbeans.modules.groovy.support.wizard.ProjectTypeStrategy;
import org.netbeans.modules.groovy.support.wizard.impl.AntProjectTypeStrategy;
import org.netbeans.modules.groovy.support.wizard.impl.MavenProjectTypeStrategy;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class GroovyFileWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator {
    private static final long serialVersionUID = 1L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    protected transient WizardDescriptor wiz;
    protected transient Project project;
    protected transient ProjectTypeStrategy strategy;

    protected GroovyFileWizardIterator() {
    }

    protected List<SourceGroup> getOrderedSourcesGroups(WizardDescriptor wizardDescriptor, List<SourceGroup> groups) {
        if (!this.strategy.existsGroovySourceFolder(groups)) {
            this.strategy.createGroovySourceFolder();
            groups = GroovySources.getGroovySourceGroups(ProjectUtils.getSources((Project)this.project));
        }
        return this.strategy.moveSourceFolderAsFirst(groups);
    }

    private WizardDescriptor.Panel[] createPanels(WizardDescriptor wizardDescriptor) {
        Sources sources = ProjectUtils.getSources((Project)this.project);
        List<SourceGroup> sourceGroups = GroovySources.getGroovySourceGroups(sources);
        if (sourceGroups.isEmpty()) {
            sourceGroups = Arrays.asList(sources.getSourceGroups("generic"));
            return new WizardDescriptor.Panel[]{Templates.buildSimpleTargetChooser((Project)this.project, (SourceGroup[])this.sourceGroupToArray(sourceGroups)).create()};
        }
        sourceGroups = this.getOrderedSourcesGroups(wizardDescriptor, sourceGroups);
        return new WizardDescriptor.Panel[]{JavaTemplates.createPackageChooser((Project)this.project, (SourceGroup[])this.sourceGroupToArray(sourceGroups))};
    }

    private SourceGroup[] sourceGroupToArray(List<SourceGroup> groups) {
        return groups.toArray(new SourceGroup[groups.size()]);
    }

    private String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        assert (panels != null);
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }

    public Set<FileObject> instantiate() throws IOException {
        assert (false) : "This method cannot be called if the class implements WizardDescriptor.ProgressInstantiatingIterator.";
        return null;
    }

    public Set instantiate(ProgressHandle handle) throws IOException {
        handle.start();
        handle.progress(NbBundle.getMessage(GroovyFileWizardIterator.class, (String)"LBL_NewGroovyFileWizardIterator_WizardProgress_CreatingFile"));
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wiz);
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wiz);
        String targetName = Templates.getTargetName((WizardDescriptor)this.wiz);
        DataFolder dFolder = DataFolder.findFolder((FileObject)targetFolder);
        DataObject dTemplate = DataObject.find((FileObject)template);
        String pkgName = GroovyFileWizardIterator.getPackageName(targetFolder);
        DataObject dobj = pkgName == null ? dTemplate.createFromTemplate(dFolder, targetName) : dTemplate.createFromTemplate(dFolder, targetName, Collections.singletonMap("package", pkgName));
        FileObject createdFile = dobj.getPrimaryFile();
        GroovyExtender extender = (GroovyExtender)Templates.getProject((WizardDescriptor)this.wiz).getLookup().lookup(GroovyExtender.class);
        if (extender != null && !extender.isActive()) {
            extender.activate();
        }
        handle.finish();
        return Collections.singleton(createdFile);
    }

    public void initialize(WizardDescriptor wiz) {
        this.preInitialize(wiz);
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels(wiz);
        String[] beforeSteps = null;
        Object prop = wiz.getProperty("WizardPanel_contentData");
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = this.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    protected void preInitialize(WizardDescriptor wizardDescriptor) {
        this.project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        FileObject pom = this.project.getProjectDirectory().getFileObject("pom.xml");
        this.strategy = pom != null && pom.isValid() ? new MavenProjectTypeStrategy(this.project) : new AntProjectTypeStrategy(this.project);
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return "";
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    protected final void fireChangeEvent() {
        this.changeSupport.fireChange();
    }

    protected static String getPackageName(FileObject targetFolder) {
        Project project = FileOwnerQuery.getOwner((FileObject)targetFolder);
        Sources sources = ProjectUtils.getSources((Project)project);
        List<SourceGroup> groups = GroovySources.getGroovySourceGroups(sources);
        String packageName = null;
        for (int i = 0; i < groups.size() && packageName == null; ++i) {
            packageName = FileUtil.getRelativePath((FileObject)groups.get(i).getRootFolder(), (FileObject)targetFolder);
        }
        if (packageName != null) {
            packageName = packageName.replaceAll("/", ".");
        }
        return packageName;
    }
}

