/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.model.impl.semantic.box;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.css.lib.api.properties.NodeVisitor;
import org.netbeans.modules.css.lib.api.properties.ResolvedProperty;
import org.netbeans.modules.css.model.api.Declaration;
import org.netbeans.modules.css.model.api.Declarations;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.semantic.Edge;
import org.netbeans.modules.css.model.api.semantic.PModel;
import org.netbeans.modules.css.model.api.semantic.box.Box;
import org.netbeans.modules.css.model.api.semantic.box.BoxElement;
import org.netbeans.modules.css.model.api.semantic.box.BoxType;
import org.netbeans.modules.css.model.api.semantic.box.EditableBox;
import org.netbeans.modules.css.model.impl.semantic.ModelBuilderNodeVisitor;
import org.netbeans.modules.css.model.impl.semantic.NodeModel;
import org.netbeans.modules.css.model.impl.semantic.PropertyModelId;
import org.netbeans.modules.css.model.impl.semantic.box.BoxProvider;
import org.netbeans.modules.css.model.impl.semantic.box.DeclarationsBorderColorModel;
import org.netbeans.modules.css.model.impl.semantic.box.DeclarationsBorderStyleModel;
import org.netbeans.modules.css.model.impl.semantic.box.DeclarationsBorderWidthModel;
import org.netbeans.modules.css.model.impl.semantic.box.DeclarationsMarginModel;
import org.netbeans.modules.css.model.impl.semantic.box.DeclarationsPaddingModel;
import org.netbeans.modules.css.model.impl.semantic.box.EditableBoxProvider;

public class DeclarationsBoxModelProvider
implements EditableBoxProvider {
    private Model model;
    private Declarations declarations;

    public DeclarationsBoxModelProvider(Model model, Declarations element) {
        this.model = model;
        this.declarations = element;
    }

    @Override
    public EditableBox getBox(BoxType boxType) {
        ArrayList<Declaration> involved = new ArrayList<Declaration>();
        BoxElement[] boxe = new BoxElement[4];
        for (Declaration declaration : this.declarations.getDeclarations()) {
            ModelBuilderNodeVisitor modelvisitor = new ModelBuilderNodeVisitor(PropertyModelId.BOX);
            ResolvedProperty resolvedProperty = declaration.getResolvedProperty();
            if (resolvedProperty == null || !resolvedProperty.isResolved()) continue;
            resolvedProperty.getParseTree().accept((NodeVisitor)modelvisitor);
            Collection<BoxProvider> providers = modelvisitor.getModels(BoxProvider.class);
            for (BoxProvider p : providers) {
                Box box;
                NodeModel nmodel;
                if (p instanceof NodeModel && !(nmodel = (NodeModel)((Object)p)).isValid() || (box = p.getBox(boxType)) == null) continue;
                for (Edge e : Edge.values()) {
                    BoxElement boxElement = box.getEdge(e);
                    if (boxElement == null) continue;
                    boxe[e.ordinal()] = boxElement;
                }
                involved.add(declaration);
            }
        }
        switch (boxType) {
            case MARGIN: {
                return new DeclarationsMarginModel(this.model, this.declarations, involved, new BI(boxe));
            }
            case PADDING: {
                return new DeclarationsPaddingModel(this.model, this.declarations, involved, new BI(boxe));
            }
            case BORDER_COLOR: {
                return new DeclarationsBorderColorModel(this.model, this.declarations, involved, new BI(boxe));
            }
            case BORDER_STYLE: {
                return new DeclarationsBorderStyleModel(this.model, this.declarations, involved, new BI(boxe));
            }
            case BORDER_WIDTH: {
                return new DeclarationsBorderWidthModel(this.model, this.declarations, involved, new BI(boxe));
            }
        }
        return new EBI(boxe, boxType);
    }

    private static class EBI
    implements EditableBox,
    PModel {
        private BoxElement[] elements;
        private BoxType type;

        public EBI(BoxElement[] elements, BoxType type) {
            this.elements = elements;
            this.type = type;
        }

        @Override
        public void setEdge(Edge edge, BoxElement value) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public BoxElement getEdge(Edge edge) {
            return this.elements[edge.ordinal()];
        }

        @Override
        public String getName() {
            return this.type.name();
        }

        @Override
        public String getDisplayName() {
            return this.type.getDisplayName();
        }

        @Override
        public String getDescription() {
            return String.format("%s Box Model", this.getDisplayName());
        }

        @Override
        public String getCategoryName() {
            return "Box";
        }

        @Override
        public BoxElement createElement(CharSequence text) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class BI
    implements Box {
        private BoxElement[] elements;

        public BI(BoxElement[] elements) {
            this.elements = elements;
        }

        @Override
        public BoxElement getEdge(Edge edge) {
            return this.elements[edge.ordinal()];
        }
    }
}

