/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.model.impl.semantic.box;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import org.netbeans.modules.css.model.api.Declaration;
import org.netbeans.modules.css.model.api.Declarations;
import org.netbeans.modules.css.model.api.ElementFactory;
import org.netbeans.modules.css.model.api.Expression;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.Property;
import org.netbeans.modules.css.model.api.PropertyValue;
import org.netbeans.modules.css.model.api.semantic.Edge;
import org.netbeans.modules.css.model.api.semantic.box.Box;
import org.netbeans.modules.css.model.api.semantic.box.BoxElement;
import org.netbeans.modules.css.model.api.semantic.box.EditableBox;
import org.netbeans.modules.css.model.impl.semantic.box.BoxWithDifferentEdges;

public abstract class DeclarationsBoxModelBase
implements EditableBox {
    private final Model model;
    private final Declarations declarations;
    private Collection<Declaration> involved;
    private Box box;

    public DeclarationsBoxModelBase(Model model, Declarations element, Collection<Declaration> involved, Box box) {
        this.model = model;
        this.declarations = element;
        this.involved = involved;
        this.box = box;
    }

    protected abstract String getPropertyName();

    protected abstract String getPropertyName(Edge var1);

    @Override
    public BoxElement getEdge(Edge edge) {
        return this.box.getEdge(edge);
    }

    @Override
    public void setEdge(Edge edge, BoxElement value) {
        BoxElement current = this.getEdge(edge);
        if (current == null && value == null || current != null && current.equals(value)) {
            return;
        }
        EnumMap<Edge, BoxElement> map = new EnumMap<Edge, BoxElement>(Edge.class);
        map.put(Edge.TOP, this.getEdge(Edge.TOP));
        map.put(Edge.BOTTOM, this.getEdge(Edge.BOTTOM));
        map.put(Edge.LEFT, this.getEdge(Edge.LEFT));
        map.put(Edge.RIGHT, this.getEdge(Edge.RIGHT));
        map.put(edge, value);
        for (Declaration d : this.involved) {
            this.declarations.removeDeclaration(d);
        }
        this.involved = new ArrayList<Declaration>();
        ElementFactory f = this.model.getElementFactory();
        Property p = f.createProperty(this.getPropertyName());
        BoxElement t = (BoxElement)map.get((Object)Edge.TOP);
        BoxElement r = (BoxElement)map.get((Object)Edge.RIGHT);
        BoxElement b = (BoxElement)map.get((Object)Edge.BOTTOM);
        BoxElement l = (BoxElement)map.get((Object)Edge.LEFT);
        this.box = new BoxWithDifferentEdges(t, r, b, l);
        if (t == null || r == null || b == null || l == null) {
            for (Edge e : Edge.values()) {
                BoxElement mw = (BoxElement)map.get((Object)e);
                if (mw == null) continue;
                String propVal = mw.asText();
                Expression expr = f.createExpression(propVal);
                PropertyValue pv = f.createPropertyValue(expr);
                String propertyName = this.getPropertyName(e);
                Property prop = f.createProperty(propertyName);
                Declaration newD = f.createDeclaration(prop, pv, false);
                this.declarations.addDeclaration(newD);
                this.involved.add(newD);
            }
        } else {
            StringBuilder sb = new StringBuilder();
            if (t.equals(b)) {
                if (l.equals(r)) {
                    if (t.equals(l)) {
                        sb.append(t.asText());
                    } else {
                        sb.append(t.asText());
                        sb.append(" ");
                        sb.append(l.asText());
                    }
                } else {
                    sb.append(t.asText());
                    sb.append(" ");
                    sb.append(r.asText());
                    sb.append(" ");
                    sb.append(b.asText());
                    sb.append(" ");
                    sb.append(l.asText());
                }
            } else if (l.equals(r)) {
                sb.append(t.asText());
                sb.append(" ");
                sb.append(l.asText());
                sb.append(" ");
                sb.append(b.asText());
            } else {
                sb.append(t.asText());
                sb.append(" ");
                sb.append(r.asText());
                sb.append(" ");
                sb.append(b.asText());
                sb.append(" ");
                sb.append(l.asText());
            }
            Expression e = f.createExpression(sb);
            PropertyValue pv = f.createPropertyValue(e);
            Declaration newD = f.createDeclaration(p, pv, false);
            this.declarations.addDeclaration(newD);
            this.involved.add(newD);
        }
    }
}

