/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.model.impl.semantic.box;

import java.util.Collection;
import org.netbeans.modules.css.model.api.Declaration;
import org.netbeans.modules.css.model.api.Declarations;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.semantic.Edge;
import org.netbeans.modules.css.model.api.semantic.PModel;
import org.netbeans.modules.css.model.api.semantic.box.Box;
import org.netbeans.modules.css.model.api.semantic.box.BoxElement;
import org.netbeans.modules.css.model.impl.semantic.box.BorderStyleItem;
import org.netbeans.modules.css.model.impl.semantic.box.Bundle;
import org.netbeans.modules.css.model.impl.semantic.box.DeclarationsBoxModelBase;

public class DeclarationsBorderStyleModel
extends DeclarationsBoxModelBase
implements PModel {
    private static final String PROPERTY_NAME_PREFIX = "border";
    private static final String PROPERTY_NAME_POSTFIX = "style";
    private static final String PROPERTY_NAME = "border-style";

    public DeclarationsBorderStyleModel(Model model, Declarations element, Collection<Declaration> involved, Box box) {
        super(model, element, involved, box);
    }

    @Override
    protected String getPropertyName() {
        return PROPERTY_NAME;
    }

    @Override
    protected String getPropertyName(Edge edge) {
        StringBuilder b = new StringBuilder();
        b.append(PROPERTY_NAME_PREFIX);
        b.append('-');
        b.append(edge.name().toLowerCase());
        b.append('-');
        b.append(PROPERTY_NAME_POSTFIX);
        return b.toString();
    }

    @Override
    public String getDisplayName() {
        return Bundle.CTL_BorderStyleDisplayName();
    }

    @Override
    public String getDescription() {
        return Bundle.CTL_BorderStyleDescription();
    }

    @Override
    public String getCategoryName() {
        return Bundle.CTL_BorderStyleCategory();
    }

    @Override
    public String getName() {
        return PROPERTY_NAME;
    }

    @Override
    public BoxElement createElement(CharSequence text) {
        return BorderStyleItem.parseValue(text);
    }
}

