/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.model.impl.semantic.box;

import org.netbeans.modules.css.lib.api.properties.Node;
import org.netbeans.modules.css.lib.api.properties.Token;
import org.netbeans.modules.css.lib.api.properties.TokenAcceptor;
import org.netbeans.modules.css.lib.api.properties.Tokenizer;
import org.netbeans.modules.css.model.api.semantic.box.BoxElement;
import org.netbeans.modules.css.model.impl.semantic.NodeModel;
import org.netbeans.modules.css.model.impl.semantic.box.Length;
import org.netbeans.modules.css.model.impl.semantic.box.Text;
import org.netbeans.modules.css.model.impl.semantic.box.TokenNodeModel;
import org.netbeans.modules.web.common.api.LexerUtils;

public class BoxEdgeSize
extends NodeModel
implements BoxElement {
    public TokenNodeModel auto;
    public Length length;
    public TokenNodeModel percentage;

    public BoxEdgeSize(Node node) {
        super(node);
    }

    private BoxEdgeSize(TokenNodeModel auto, Length length, TokenNodeModel percentage) {
        this.auto = auto;
        this.length = length;
        this.percentage = percentage;
    }

    private static TokenNodeModel createText(CharSequence text) {
        return new TokenNodeModel(text);
    }

    private static BoxEdgeSize createAuto() {
        return new BoxEdgeSize(BoxEdgeSize.createText("auto"), null, null);
    }

    private static BoxEdgeSize createLength(CharSequence length) {
        return new BoxEdgeSize(null, new Length(BoxEdgeSize.createText(length)), null);
    }

    private static BoxEdgeSize createPercentage(CharSequence value) {
        return new BoxEdgeSize(null, null, BoxEdgeSize.createText(value));
    }

    public static BoxEdgeSize parseValue(CharSequence tokenImage) {
        TokenAcceptor lengthTokenAcceptor = TokenAcceptor.getAcceptor((String)"length");
        TokenAcceptor percentageTokenAcceptor = TokenAcceptor.getAcceptor((String)"percentage");
        Tokenizer tokenizer = new Tokenizer(tokenImage);
        Token token = tokenizer.token();
        if (lengthTokenAcceptor.accepts(token)) {
            return BoxEdgeSize.createLength(tokenImage);
        }
        if (percentageTokenAcceptor.accepts(token)) {
            return BoxEdgeSize.createPercentage(tokenImage);
        }
        if (LexerUtils.equals((CharSequence)"auto", (CharSequence)tokenImage, (boolean)true, (boolean)true)) {
            return BoxEdgeSize.createAuto();
        }
        return null;
    }

    public Text getAuto() {
        return this.auto;
    }

    public Length getLength() {
        return this.length;
    }

    public Text getPercentage() {
        return this.percentage;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoxEdgeSize other = (BoxEdgeSize)obj;
        if (!(this.auto == other.auto || this.auto != null && this.auto.equals(other.auto))) {
            return false;
        }
        if (!(this.length == other.length || this.length != null && this.length.equals(other.length))) {
            return false;
        }
        return this.percentage == other.percentage || this.percentage != null && this.percentage.equals(other.percentage);
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + (this.auto != null ? this.auto.hashCode() : 0);
        hash = 17 * hash + (this.length != null ? this.length.hashCode() : 0);
        hash = 17 * hash + (this.percentage != null ? this.percentage.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName());
        b.append("(");
        if (this.getAuto() != null) {
            b.append(this.getAuto());
        }
        if (this.getLength() != null) {
            b.append(this.getLength());
        }
        if (this.getPercentage() != null) {
            b.append(this.getPercentage());
        }
        b.append(")");
        return b.toString();
    }

    @Override
    public String asText() {
        if (this.auto != null) {
            return ((Object)this.auto.getValue()).toString();
        }
        if (this.getLength() != null) {
            return ((Object)this.getLength().getLength().getValue()).toString();
        }
        return ((Object)this.getPercentage().getValue()).toString();
    }
}

