/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.model.impl.semantic.box;

import org.netbeans.modules.css.lib.api.properties.Node;
import org.netbeans.modules.css.model.api.semantic.box.BoxElement;
import org.netbeans.modules.css.model.impl.semantic.NodeModel;
import org.netbeans.modules.css.model.impl.semantic.box.TokenNodeModel;
import org.netbeans.modules.web.common.api.LexerUtils;

public class BorderStyleItem
extends NodeModel
implements BoxElement {
    private TokenNodeModel fixedValue;

    public BorderStyleItem(Node node) {
        super(node);
    }

    private BorderStyleItem(FixedValue fixedValue) {
        this.fixedValue = BorderStyleItem.createText(fixedValue.getValue());
    }

    private static TokenNodeModel createText(CharSequence text) {
        return new TokenNodeModel(text);
    }

    public static BorderStyleItem parseValue(CharSequence tokenImage) {
        FixedValue fixedValue = BorderStyleItem.getFixedValue(tokenImage);
        if (fixedValue != null) {
            return new BorderStyleItem(fixedValue);
        }
        return null;
    }

    private static FixedValue getFixedValue(CharSequence sequence) {
        for (FixedValue fv : FixedValue.values()) {
            if (!LexerUtils.equals((CharSequence)fv.getValue(), (CharSequence)sequence, (boolean)true, (boolean)false)) continue;
            return fv;
        }
        return null;
    }

    @Override
    protected TokenNodeModel getTokenNode(CharSequence image) {
        if (this.fixedValue != null && LexerUtils.equals((CharSequence)this.fixedValue.getValue(), (CharSequence)image, (boolean)true, (boolean)false)) {
            return this.fixedValue;
        }
        return super.getTokenNode(image);
    }

    public TokenNodeModel getFixedValueModel(FixedValue fixedValue) {
        return this.getTokenNode(fixedValue.getValue());
    }

    @Override
    public String asText() {
        for (FixedValue fv : FixedValue.values()) {
            TokenNodeModel tnm = this.getFixedValueModel(fv);
            if (tnm == null) continue;
            return ((Object)tnm.getValue()).toString();
        }
        return "invalid value";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BorderStyleItem other = (BorderStyleItem)obj;
        return this.asText().equals(other.asText());
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.fixedValue != null ? this.fixedValue.hashCode() : 0);
        return hash;
    }

    public static enum FixedValue {
        none,
        hidden,
        dotted,
        dashed,
        solid,
        _double,
        groove,
        ridge,
        inset,
        outset;


        public String getValue() {
            return this.name().charAt(0) == '_' ? this.name().substring(1) : this.name();
        }
    }
}

