/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.model.impl.semantic.box;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.css.lib.api.properties.Node;
import org.netbeans.modules.css.model.api.semantic.Edge;
import org.netbeans.modules.css.model.impl.semantic.CustomModelFactory;
import org.netbeans.modules.css.model.impl.semantic.NodeModel;
import org.netbeans.modules.css.model.impl.semantic.box.BorderSingleEdgeColor;
import org.netbeans.modules.css.model.impl.semantic.box.BorderSingleEdgeStyle;
import org.netbeans.modules.css.model.impl.semantic.box.BorderSingleEdgeWidth;

public class BorderSingleEdgeModelFactory
implements CustomModelFactory {
    private static final Pattern PATTERN = Pattern.compile("border-(\\w*)-(\\w*)");
    private Map<String, Edge> EDGE_NAMES = new HashMap<String, Edge>();

    public BorderSingleEdgeModelFactory() {
        for (Edge e : Edge.values()) {
            this.EDGE_NAMES.put(e.name().toLowerCase(), e);
        }
    }

    @Override
    public NodeModel createModel(Node node) {
        String nodeName = node.name().toLowerCase(Locale.ENGLISH);
        Matcher matcher = PATTERN.matcher(nodeName);
        if (matcher.find()) {
            String edgeName = matcher.group(1);
            Edge edge = this.EDGE_NAMES.get(edgeName);
            if (edge == null) {
                return null;
            }
            String typeName = matcher.group(2);
            if ("color".equals(typeName)) {
                return new BorderSingleEdgeColor(edge, node);
            }
            if ("style".equals(typeName)) {
                return new BorderSingleEdgeStyle(edge, node);
            }
            if ("width".equals(typeName)) {
                return new BorderSingleEdgeWidth(edge, node);
            }
        }
        return null;
    }
}

