/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.model.impl.semantic.background;

import org.netbeans.modules.css.lib.api.properties.GroupNode;
import org.netbeans.modules.css.lib.api.properties.Node;
import org.netbeans.modules.css.lib.api.properties.NodeVisitor2;
import org.netbeans.modules.css.lib.api.properties.TokenNode;
import org.netbeans.modules.css.model.api.semantic.Length;
import org.netbeans.modules.css.model.api.semantic.Percentage;
import org.netbeans.modules.css.model.api.semantic.Size;
import org.netbeans.modules.css.model.impl.semantic.Element;
import org.netbeans.modules.css.model.impl.semantic.LengthI;
import org.netbeans.modules.css.model.impl.semantic.PercentageI;
import org.netbeans.modules.web.common.api.LexerUtils;

public class BgSizeI {
    private SizeI size = new SizeI();

    public BgSizeI(Node node) {
        node.accept(new NodeVisitor2(){
            private State state;
            private int arg;

            public boolean visitGroupNode(GroupNode groupNode) {
                block0 : switch (Element.forNode((Node)groupNode)) {
                    case single: {
                        this.state = State.IN_SINGLE;
                        break;
                    }
                    case pair: {
                        this.state = State.IN_PAIR;
                        break;
                    }
                    case percentage: {
                        ++this.arg;
                        switch (this.arg) {
                            case 1: {
                                BgSizeI.this.size.horizontal.percentage = new PercentageI((Node)groupNode);
                                BgSizeI.this.size.vertical.auto = true;
                                break;
                            }
                            case 2: {
                                BgSizeI.this.size.vertical.percentage = new PercentageI((Node)groupNode);
                                BgSizeI.this.size.vertical.auto = false;
                            }
                        }
                        break;
                    }
                    case length: {
                        ++this.arg;
                        switch (this.arg) {
                            case 1: {
                                BgSizeI.this.size.horizontal.length = new LengthI((Node)groupNode);
                                BgSizeI.this.size.vertical.auto = true;
                                break block0;
                            }
                            case 2: {
                                BgSizeI.this.size.vertical.length = new LengthI((Node)groupNode);
                                BgSizeI.this.size.vertical.auto = false;
                            }
                        }
                    }
                }
                return true;
            }

            public void visitTokenNode(TokenNode tokenNode) {
                CharSequence img = tokenNode.image();
                switch (this.state) {
                    case IN_SINGLE: {
                        if (LexerUtils.equals((CharSequence)"cover", (CharSequence)img, (boolean)true, (boolean)true)) {
                            BgSizeI.this.size.cover = true;
                            break;
                        }
                        if (!LexerUtils.equals((CharSequence)"contain", (CharSequence)img, (boolean)true, (boolean)true)) break;
                        BgSizeI.this.size.contain = true;
                        break;
                    }
                    case IN_PAIR: {
                        if (!LexerUtils.equals((CharSequence)"auto", (CharSequence)img, (boolean)true, (boolean)true)) break;
                        ++this.arg;
                        switch (this.arg) {
                            case 1: {
                                BgSizeI.this.size.horizontal.auto = true;
                            }
                            case 2: {
                                BgSizeI.this.size.vertical.auto = true;
                            }
                        }
                    }
                }
            }
        });
    }

    public Size getSize() {
        return this.size;
    }

    public String toString() {
        return "";
    }

    private static class ValueI
    implements Size.Value {
        private Length length;
        private Percentage percentage;
        private boolean auto;

        @Override
        public Length getLength() {
            return this.length;
        }

        @Override
        public Percentage getPercentage() {
            return this.percentage;
        }

        @Override
        public boolean isAuto() {
            return this.auto;
        }
    }

    private static class SizeI
    implements Size {
        private boolean cover;
        private boolean contain;
        private ValueI horizontal = new ValueI();
        private ValueI vertical = new ValueI();

        @Override
        public boolean isCover() {
            return this.cover;
        }

        @Override
        public boolean isContain() {
            return this.contain;
        }

        @Override
        public Size.Value getHorizontalSize() {
            return this.horizontal;
        }

        @Override
        public Size.Value getVerticalSize() {
            return this.vertical;
        }
    }

    private static enum State {
        IN_SINGLE,
        IN_PAIR;

    }
}

