/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.model.impl.semantic;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import org.netbeans.modules.css.lib.api.properties.Node;
import org.netbeans.modules.css.lib.api.properties.NodeVisitor;
import org.netbeans.modules.css.model.impl.semantic.CustomModelFactory;
import org.netbeans.modules.css.model.impl.semantic.NodeModel;
import org.netbeans.modules.css.model.impl.semantic.PropertyModelId;
import org.netbeans.modules.css.model.impl.semantic.box.TokenNodeModel;

public class ModelBuilderNodeVisitor
implements NodeVisitor {
    private Collection<NodeModel> models = new ArrayList<NodeModel>();
    private NodeModel currentModel;
    private PropertyModelId propertyModel;
    private Stack<NodeModel> current = new Stack();

    public ModelBuilderNodeVisitor(PropertyModelId propertyModel) {
        this.propertyModel = propertyModel;
    }

    public Collection<NodeModel> getModels() {
        return this.models;
    }

    public <T> Collection<T> getModels(Class<T> type) {
        ArrayList<T> tmodels = new ArrayList<T>();
        for (NodeModel m : this.getModels()) {
            if (!type.isAssignableFrom(m.getClass())) continue;
            tmodels.add(type.cast(m));
        }
        return tmodels;
    }

    static String getModelClassNameForNodeName(String nodeName) {
        if (nodeName.length() == 0) {
            throw new IllegalArgumentException("Node name cannot be empty.");
        }
        StringBuilder sb = new StringBuilder();
        boolean nextCharToUpper = true;
        for (int i = 0; i < nodeName.length(); ++i) {
            char c = nodeName.charAt(i);
            if (i == 0 && (c == '@' || c == '!')) continue;
            if (c == '-' || c == '_') {
                nextCharToUpper = true;
                continue;
            }
            if (nextCharToUpper) {
                nextCharToUpper = false;
                sb.append(Character.toUpperCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private Class getModelClass(String modelClassName) {
        for (Class clazz : this.propertyModel.getModelClasses()) {
            if (!clazz.getSimpleName().equals(modelClassName)) continue;
            return clazz;
        }
        return null;
    }

    public boolean visit(Node node) {
        String nodeName = node.name();
        if (nodeName == null) {
            throw new IllegalArgumentException(String.format("Node %s has no name!", node.toString()));
        }
        String modelClassName = ModelBuilderNodeVisitor.getModelClassNameForNodeName(nodeName);
        System.out.println("model class for node " + node + ": " + modelClassName);
        if (this.current.isEmpty()) {
            Class modelClass;
            this.currentModel = this.createModelInstance(node);
            if (this.currentModel == null && (modelClass = this.getModelClass(modelClassName)) != null) {
                this.currentModel = this.createModelInstance(modelClass, node);
            }
            if (this.currentModel != null) {
                this.current.push(this.currentModel);
                this.models.add(this.currentModel);
            }
            return true;
        }
        return this.handleNode(modelClassName, node);
    }

    public void unvisit(Node node) {
        if (!this.current.isEmpty()) {
            this.current.pop();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleNode(String modelClassName, Node node) {
        Class fieldType;
        Class<Node.ResolvedTokenNode> constructorArgumentClass;
        block11: {
            NodeModel nmodel = CustomModelFactory.Query.createModel(node);
            if (nmodel != null) {
                try {
                    this.current.peek().setSubmodel(modelClassName, nmodel);
                    this.current.push(nmodel);
                    return true;
                }
                catch (NoSuchFieldException ex) {
                    return true;
                }
                catch (IllegalArgumentException ex) {
                    return true;
                }
                catch (IllegalAccessException ex) {}
                return true;
            }
            Class<?> currentModelClass = this.current.peek().getClass();
            String submodelFieldName = NodeModel.getSubmodelFieldName(modelClassName);
            if (node instanceof Node.ResolvedTokenNode) {
                constructorArgumentClass = Node.ResolvedTokenNode.class;
                fieldType = TokenNodeModel.class;
            } else {
                if (!(node instanceof Node.GroupNodeImpl)) throw new IllegalStateException();
                constructorArgumentClass = Node.class;
                try {
                    Field field = currentModelClass.getField(submodelFieldName);
                    fieldType = field.getType();
                }
                catch (NoSuchFieldException nsfe) {
                    fieldType = this.current.peek().getModelClassForSubNode(node.name());
                    if (fieldType != null) break block11;
                    String msg = String.format("Processing node %s: Neither public field %s found in the model class %s nor the class provides a class for the node name %s", node, submodelFieldName, currentModelClass, node.name());
                    System.err.println(msg);
                    this.current.peek().setUnhandledChild(node);
                    return false;
                }
            }
        }
        try {
            Constructor constructor = fieldType.getConstructor(constructorArgumentClass);
            NodeModel modelInstance = (NodeModel)constructor.newInstance(node);
            this.current.peek().setSubmodel(modelClassName, modelInstance);
            this.current.push(modelInstance);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private NodeModel createModelInstance(Node node) {
        return CustomModelFactory.Query.createModel(node);
    }

    private NodeModel createModelInstance(Class modelClass, Node node) {
        try {
            Constructor constructor = modelClass.getConstructor(Node.class);
            return (NodeModel)constructor.newInstance(node);
        }
        catch (Exception ex) {
            throw new IllegalStateException(String.format("Cannot create an instance of class %s by invoking its constructor with Node argument", modelClass.getName()), ex);
        }
    }
}

