/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeType;
import org.netbeans.modules.css.lib.api.NodeUtil;
import org.netbeans.modules.css.model.api.Element;
import org.netbeans.modules.css.model.api.ElementListener;
import org.netbeans.modules.css.model.api.Media;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.ModelVisitor;
import org.netbeans.modules.css.model.api.PlainElement;
import org.netbeans.modules.css.model.api.Rule;
import org.netbeans.modules.css.model.api.semantic.PModel;
import org.netbeans.modules.css.model.impl.ElementFactoryImpl;
import org.netbeans.modules.css.model.impl.ModelElementListener;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.web.common.api.LexerUtils;

public abstract class ModelElement
implements Element {
    private final List<ClassElement> CLASSELEMENTS = new ArrayList<ClassElement>();
    private Collection<ElementListener> LISTENERS;
    protected final Model model;
    private Node node;
    private Element parent;
    private static final String DEFAULT_INDENT = "    ";
    private static final String EMPTY_STRING = "";

    public ModelElement(Model model) {
        this.model = model;
    }

    public ModelElement(Model model, Node node) {
        this(model);
        this.node = node;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public void accept(ModelVisitor modelVisitor) {
        for (int i = 0; i < this.getElementsCount(); ++i) {
            Element child = this.getElementAt(i);
            child.accept(modelVisitor);
        }
        this.acceptVisitorGeneric(this, modelVisitor);
    }

    public void acceptVisitorGeneric(Element element, ModelVisitor modelVisitor) {
        try {
            Class elementClass = this.getModelClass(element);
            if (Rule.class.equals((Object)elementClass)) {
                modelVisitor.visitRule((Rule)element);
            } else if (Media.class.equals((Object)elementClass)) {
                modelVisitor.visitMedia((Media)element);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Element getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Element e) {
        this.parent = e;
    }

    protected boolean isArtificialElement() {
        return this.node == null;
    }

    @Override
    public boolean isValid() {
        if (this.node == null) {
            return true;
        }
        return NodeUtil.getChildrenRecursivelyByType((Node)this.node, (NodeType[])new NodeType[]{NodeType.error, NodeType.recovery}).isEmpty();
    }

    @Override
    public Collection<? extends PModel> getSemanticModels() {
        return Collections.emptyList();
    }

    @Override
    public int getStartOffset() {
        return this.node != null ? this.node.from() : -1;
    }

    @Override
    public int getEndOffset() {
        return this.node != null ? this.node.to() : -1;
    }

    @Override
    public synchronized void addElementListener(ElementListener listener) {
        if (this.LISTENERS == null) {
            this.LISTENERS = new ArrayList<ElementListener>();
            this.LISTENERS.add(listener);
        }
    }

    @Override
    public synchronized void removeElementListener(ElementListener listener) {
        if (this.LISTENERS == null) {
            return;
        }
        this.LISTENERS.remove(listener);
        if (this.LISTENERS.isEmpty()) {
            this.LISTENERS = null;
        }
    }

    protected synchronized void fireElementChanged() {
        if (this.LISTENERS == null) {
            return;
        }
        for (ElementListener el : this.LISTENERS) {
            el.elementChanged(null);
        }
    }

    private void fireElementAdded(Element e) {
        e.setParent(this);
        ModelElementListener.Support.fireElementAdded(e, this.getElementListener());
        this.fireElementChanged();
    }

    private void fireElementRemoved(Element e) {
        e.setParent(null);
        ModelElementListener.Support.fireElementRemoved(e, this.getElementListener());
        this.fireElementChanged();
    }

    protected abstract Class getModelClass();

    protected final void initChildrenElements() {
        for (Node child : this.node.children()) {
            this.addElement(((ElementFactoryImpl)this.model.getElementFactory()).createElement(this.model, child));
        }
    }

    protected void addEmptyElement(Class clazz) {
        this.CLASSELEMENTS.add(new ClassElement(clazz, null));
    }

    protected void addTextElement(CharSequence text) {
        this.addElement(this.model.getElementFactory().createPlainElement(text));
    }

    private Class getModelClass(Element element) {
        if (element instanceof ModelElement) {
            ModelElement melement = (ModelElement)element;
            Class clazz = melement.getModelClass();
            if (!clazz.isAssignableFrom(element.getClass())) {
                throw new IllegalArgumentException(String.format("Element %s declares %s as its superinterface but it is not true!", element.getClass().getSimpleName(), clazz.getSimpleName()));
            }
            return clazz;
        }
        return element.getClass();
    }

    @Override
    public int addElement(Element e) {
        Class clazz = this.getModelClass(e);
        this.CLASSELEMENTS.add(new ClassElement(clazz, e));
        this.fireElementAdded(e);
        return this.getElementsCount() - 1;
    }

    @Override
    public Element getElementAt(int index) {
        ClassElement ce = this.CLASSELEMENTS.get(index);
        return ce == null ? null : ce.getElement();
    }

    @Override
    public int getElementsCount() {
        return this.CLASSELEMENTS.size();
    }

    @Override
    public Element setElementAt(int index, Element e) {
        Class clazz = this.getModelClass(e);
        ClassElement ce = new ClassElement(clazz, e);
        ClassElement old = this.CLASSELEMENTS.set(index, ce);
        if (old.getElement() != null) {
            this.fireElementRemoved(old.getElement());
        }
        this.fireElementAdded(e);
        return old == null ? null : old.getElement();
    }

    @Override
    public Iterator<Element> childrenIterator() {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (ClassElement ce : this.CLASSELEMENTS) {
            elements.add(ce.getElement());
        }
        return elements.iterator();
    }

    @Override
    public Element removeElement(int index) {
        ClassElement removed = this.CLASSELEMENTS.remove(index);
        if (removed != null) {
            Element removedElement = removed.getElement();
            this.fireElementRemoved(removedElement);
            return removedElement;
        }
        return null;
    }

    @Override
    public boolean removeElement(Element element) {
        int index = this.getElementIndex(element);
        if (index == -1) {
            return false;
        }
        return this.removeElement(index) != null;
    }

    @Override
    public void insertElement(int index, Element element) {
        Class clazz = this.getModelClass(element);
        this.CLASSELEMENTS.add(index, new ClassElement(clazz, element));
        this.fireElementAdded(element);
    }

    @Override
    public int getElementIndex(Element e) {
        for (int i = 0; i < this.CLASSELEMENTS.size(); ++i) {
            ClassElement ce = this.CLASSELEMENTS.get(i);
            if (!ce.getElement().equals(e)) continue;
            return i;
        }
        return -1;
    }

    public int getElementIndex(Class elementClass) {
        for (int i = 0; i < this.CLASSELEMENTS.size(); ++i) {
            ClassElement ce = this.CLASSELEMENTS.get(i);
            if (!ce.getClazz().equals(elementClass)) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getModelClass(this).getSimpleName());
        sb.append("(model=");
        sb.append(this.model);
        sb.append(",sihc=");
        sb.append(System.identityHashCode(this));
        sb.append(",type=");
        if (this.node != null) {
            sb.append("source[ofs=");
            sb.append(this.node.from());
            sb.append('-');
            sb.append(this.node.to());
            sb.append(";line=");
            try {
                sb.append(1 + LexerUtils.getLineOffset((CharSequence)this.model.getOriginalSource(), (int)this.node.from()));
                sb.append('-');
                sb.append(1 + LexerUtils.getLineOffset((CharSequence)this.model.getOriginalSource(), (int)this.node.to()));
            }
            catch (BadLocationException ex) {
                sb.append("BLE!");
            }
            sb.append(']');
        } else {
            sb.append("AI");
        }
        sb.append(')');
        return sb.toString();
    }

    protected void setElement(Element element) {
        this.setElement(element, false);
    }

    protected int setElement(Element element, boolean addElementIfSetAlready) {
        int index = this.getElementIndex(this.getModelClass(element));
        if (index == -1) {
            return this.addElement(element);
        }
        Element original = this.getElementAt(index);
        if (original == null) {
            this.setElementAt(index, element);
            return index;
        }
        this.insertElement(++index, element);
        return index;
    }

    protected <T extends Element> T getElementAt(int index, Class<T> type) {
        if (index < 0 || index >= this.getElementsCount()) {
            return null;
        }
        Element e = this.getElementAt(index);
        if (type.isAssignableFrom(e.getClass())) {
            return (T)((Element)type.cast(e));
        }
        return null;
    }

    protected String getIndent() {
        Document doc = (Document)this.model.getLookup().lookup(Document.class);
        if (doc != null) {
            int indentLevel = IndentUtils.indentLevelSize((Document)doc);
            return IndentUtils.createIndentString(null, (int)indentLevel);
        }
        return DEFAULT_INDENT;
    }

    protected void wipeWhitespaces(PlainElement pe, boolean endLineInclusive) {
        String text = ((Object)pe.getContent()).toString();
        int lastEndIndex = text.lastIndexOf(10);
        if (lastEndIndex >= 0) {
            String upToTheNL = text.substring(0, lastEndIndex);
            if (upToTheNL.trim().length() == 0) {
                pe.setContent(endLineInclusive ? EMPTY_STRING : "\n");
            } else {
                text = text.substring(0, lastEndIndex + 1);
                pe.setContent(text);
            }
        } else if (text.trim().length() == 0) {
            pe.setContent(EMPTY_STRING);
        }
    }

    protected abstract ModelElementListener getElementListener();

    private static class ClassElement {
        private Class clazz;
        private Element element;

        public ClassElement(Class clazz, Element element) {
            this.clazz = clazz;
            this.element = element;
        }

        public Class getClazz() {
            return this.clazz;
        }

        public Element getElement() {
            return this.element;
        }

        public String toString() {
            return this.getElement().toString();
        }
    }
}

