/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.model.impl;

import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeType;
import org.netbeans.modules.css.model.api.AtRuleId;
import org.netbeans.modules.css.model.api.Body;
import org.netbeans.modules.css.model.api.BodyItem;
import org.netbeans.modules.css.model.api.CharSet;
import org.netbeans.modules.css.model.api.CharSetValue;
import org.netbeans.modules.css.model.api.Declaration;
import org.netbeans.modules.css.model.api.Declarations;
import org.netbeans.modules.css.model.api.Element;
import org.netbeans.modules.css.model.api.ElementFactory;
import org.netbeans.modules.css.model.api.Expression;
import org.netbeans.modules.css.model.api.FontFace;
import org.netbeans.modules.css.model.api.GenericAtRule;
import org.netbeans.modules.css.model.api.ImportItem;
import org.netbeans.modules.css.model.api.Imports;
import org.netbeans.modules.css.model.api.Media;
import org.netbeans.modules.css.model.api.MediaExpression;
import org.netbeans.modules.css.model.api.MediaFeature;
import org.netbeans.modules.css.model.api.MediaQuery;
import org.netbeans.modules.css.model.api.MediaQueryList;
import org.netbeans.modules.css.model.api.MediaQueryOperator;
import org.netbeans.modules.css.model.api.MediaType;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.MozDocument;
import org.netbeans.modules.css.model.api.MozDocumentFunction;
import org.netbeans.modules.css.model.api.Namespace;
import org.netbeans.modules.css.model.api.NamespacePrefixName;
import org.netbeans.modules.css.model.api.Namespaces;
import org.netbeans.modules.css.model.api.Page;
import org.netbeans.modules.css.model.api.PlainElement;
import org.netbeans.modules.css.model.api.Prio;
import org.netbeans.modules.css.model.api.Property;
import org.netbeans.modules.css.model.api.PropertyValue;
import org.netbeans.modules.css.model.api.ResourceIdentifier;
import org.netbeans.modules.css.model.api.Rule;
import org.netbeans.modules.css.model.api.Selector;
import org.netbeans.modules.css.model.api.SelectorsGroup;
import org.netbeans.modules.css.model.api.StyleSheet;
import org.netbeans.modules.css.model.api.VendorAtRule;
import org.netbeans.modules.css.model.api.WebkitKeyframeSelectors;
import org.netbeans.modules.css.model.api.WebkitKeyframes;
import org.netbeans.modules.css.model.api.WebkitKeyframesBlock;
import org.netbeans.modules.css.model.impl.AtRuleIdI;
import org.netbeans.modules.css.model.impl.BodyI;
import org.netbeans.modules.css.model.impl.BodyItemI;
import org.netbeans.modules.css.model.impl.CharSetI;
import org.netbeans.modules.css.model.impl.CharSetValueI;
import org.netbeans.modules.css.model.impl.DeclarationI;
import org.netbeans.modules.css.model.impl.DeclarationsI;
import org.netbeans.modules.css.model.impl.ExpressionI;
import org.netbeans.modules.css.model.impl.FontFaceI;
import org.netbeans.modules.css.model.impl.GenericAtRuleI;
import org.netbeans.modules.css.model.impl.ImportItemI;
import org.netbeans.modules.css.model.impl.ImportsI;
import org.netbeans.modules.css.model.impl.MediaExpressionI;
import org.netbeans.modules.css.model.impl.MediaFeatureI;
import org.netbeans.modules.css.model.impl.MediaI;
import org.netbeans.modules.css.model.impl.MediaQueryI;
import org.netbeans.modules.css.model.impl.MediaQueryListI;
import org.netbeans.modules.css.model.impl.MediaQueryOperatorI;
import org.netbeans.modules.css.model.impl.MediaTypeI;
import org.netbeans.modules.css.model.impl.MozDocumentFunctionI;
import org.netbeans.modules.css.model.impl.MozDocumentI;
import org.netbeans.modules.css.model.impl.NamespaceI;
import org.netbeans.modules.css.model.impl.NamespacePrefixNameI;
import org.netbeans.modules.css.model.impl.NamespacesI;
import org.netbeans.modules.css.model.impl.PageI;
import org.netbeans.modules.css.model.impl.PlainElementI;
import org.netbeans.modules.css.model.impl.PrioI;
import org.netbeans.modules.css.model.impl.PropertyI;
import org.netbeans.modules.css.model.impl.PropertyValueI;
import org.netbeans.modules.css.model.impl.ResourceIdentifierI;
import org.netbeans.modules.css.model.impl.RuleI;
import org.netbeans.modules.css.model.impl.SelectorI;
import org.netbeans.modules.css.model.impl.SelectorsGroupI;
import org.netbeans.modules.css.model.impl.StyleSheetI;
import org.netbeans.modules.css.model.impl.Utils;
import org.netbeans.modules.css.model.impl.VendorAtRuleI;
import org.netbeans.modules.css.model.impl.WebkitKeyframeSelectorsI;
import org.netbeans.modules.css.model.impl.WebkitKeyframesBlockI;
import org.netbeans.modules.css.model.impl.WebkitKeyframesI;
import org.netbeans.modules.css.model.impl.WsI;
import org.openide.util.Parameters;

public final class ElementFactoryImpl
implements ElementFactory {
    private Model model;

    public ElementFactoryImpl(Model model) {
        this.model = model;
    }

    public Element createElement(Model model, Node node) {
        NodeType type = node.type();
        String className = Utils.getInterfaceForNodeType(type.name());
        if (className.equals("AtRuleId")) {
            return new AtRuleIdI(model, node);
        }
        if (className.equals("GenericAtRule")) {
            return new GenericAtRuleI(model, node);
        }
        if (className.equals("MozDocument")) {
            return new MozDocumentI(model, node);
        }
        if (className.equals("MozDocumentFunction")) {
            return new MozDocumentFunctionI(model, node);
        }
        if (className.equals("VendorAtRule")) {
            return new VendorAtRuleI(model, node);
        }
        if (className.equals("WebkitKeyframes")) {
            return new WebkitKeyframesI(model, node);
        }
        if (className.equals("WebkitKeyframeSelectors")) {
            return new WebkitKeyframeSelectorsI(model, node);
        }
        if (className.equals("WebkitKeyframesBlock")) {
            return new WebkitKeyframesBlockI(model, node);
        }
        if (className.equals("StyleSheet")) {
            return new StyleSheetI(model, node);
        }
        if (className.equals("CharSet")) {
            return new CharSetI(model, node);
        }
        if (className.equals("CharSetValue")) {
            return new CharSetValueI(model, node);
        }
        if (className.equals("FontFace")) {
            return new FontFaceI(model, node);
        }
        if (className.equals("Imports")) {
            return new ImportsI(model, node);
        }
        if (className.equals("ImportItem")) {
            return new ImportItemI(model, node);
        }
        if (className.equals("ResourceIdentifier")) {
            return new ResourceIdentifierI(model, node);
        }
        if (className.equals("Media")) {
            return new MediaI(model, node);
        }
        if (className.equals("MediaQueryList")) {
            return new MediaQueryListI(model, node);
        }
        if (className.equals("MediaQuery")) {
            return new MediaQueryI(model, node);
        }
        if (className.equals("MediaQueryOperator")) {
            return new MediaQueryOperatorI(model, node);
        }
        if (className.equals("MediaExpression")) {
            return new MediaExpressionI(model, node);
        }
        if (className.equals("MediaFeature")) {
            return new MediaFeatureI(model, node);
        }
        if (className.equals("MediaType")) {
            return new MediaTypeI(model, node);
        }
        if (className.equals("Namespaces")) {
            return new NamespacesI(model, node);
        }
        if (className.equals("Namespace")) {
            return new NamespaceI(model, node);
        }
        if (className.equals("NamespacePrefixName")) {
            return new NamespacePrefixNameI(model, node);
        }
        if (className.equals("Body")) {
            return new BodyI(model, node);
        }
        if (className.equals("BodyItem")) {
            return new BodyItemI(model, node);
        }
        if (className.equals("Rule")) {
            return new RuleI(model, node);
        }
        if (className.equals("SelectorsGroup")) {
            return new SelectorsGroupI(model, node);
        }
        if (className.equals("Selector")) {
            return new SelectorI(model, node);
        }
        if (className.equals("Declarations")) {
            return new DeclarationsI(model, node);
        }
        if (className.equals("Declaration")) {
            return new DeclarationI(model, node);
        }
        if (className.equals("Property")) {
            return new PropertyI(model, node);
        }
        if (className.equals("PropertyValue")) {
            return new PropertyValueI(model, node);
        }
        if (className.equals("Expression")) {
            return new ExpressionI(model, node);
        }
        if (className.equals("Prio")) {
            return new PrioI(model, node);
        }
        if (className.equals("PlainElement")) {
            return new PlainElementI(model, node);
        }
        if (className.equals("Page")) {
            return new PageI(model, node);
        }
        if (className.equals("Ws")) {
            return new WsI(model, node);
        }
        if (className.equals("Token")) {
            return new PlainElementI(model, node);
        }
        Logger.getLogger(ElementFactoryImpl.class.getName()).log(Level.WARNING, "created element by reflection for {0}, update the ElementFactoryImpl.createElement() methods ugly switch!", className);
        return this.createElementByReflection(model, node);
    }

    private Element createElementByReflection(Model model, Node node) {
        Parameters.notNull((CharSequence)"model", (Object)model);
        Parameters.notNull((CharSequence)"node", (Object)node);
        try {
            Class<?> clazz = Class.forName(Utils.getImplementingClassNameForNodeType(node.type()));
            Constructor<?> constructor = clazz.getConstructor(Model.class, Node.class);
            return (Element)constructor.newInstance(model, node);
        }
        catch (ClassNotFoundException cnfe) {
            return new PlainElementI(model, node);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public StyleSheet createStyleSheet() {
        return new StyleSheetI(this.model);
    }

    @Override
    public CharSet createCharSet() {
        return new CharSetI(this.model);
    }

    @Override
    public CharSetValue createCharSetValue() {
        return new CharSetValueI(this.model);
    }

    @Override
    public FontFace createFontFace() {
        return new FontFaceI(this.model);
    }

    @Override
    public FontFace createFontFace(Declarations declarations) {
        FontFace fontFace = this.createFontFace();
        fontFace.setDeclarations(declarations);
        return fontFace;
    }

    @Override
    public Imports createImports() {
        return new ImportsI(this.model);
    }

    @Override
    public ImportItem createImportItem() {
        return new ImportItemI(this.model);
    }

    @Override
    public ResourceIdentifier createResourceIdentifier() {
        return new ResourceIdentifierI(this.model);
    }

    @Override
    public MediaQueryList createMediaQueryList() {
        return new MediaQueryListI(this.model);
    }

    @Override
    public MediaQuery createMediaQuery() {
        return new MediaQueryI(this.model);
    }

    @Override
    public Namespaces createNamespaces() {
        return new NamespacesI(this.model);
    }

    @Override
    public Namespace createNamespace() {
        return new NamespaceI(this.model);
    }

    @Override
    public NamespacePrefixName createNamespacePrefixName() {
        return new NamespacePrefixNameI(this.model);
    }

    @Override
    public Body createBody() {
        return new BodyI(this.model);
    }

    @Override
    public BodyItem createBodyItem() {
        return new BodyItemI(this.model);
    }

    @Override
    public Rule createRule() {
        return new RuleI(this.model);
    }

    @Override
    public Rule createRule(SelectorsGroup selectorsGroup, Declarations declarations) {
        Rule rule = this.createRule();
        rule.setSelectorsGroup(selectorsGroup);
        rule.setDeclarations(declarations);
        return rule;
    }

    @Override
    public SelectorsGroup createSelectorsGroup() {
        return new SelectorsGroupI(this.model);
    }

    @Override
    public SelectorsGroup createSelectorsGroup(Selector ... selectors) {
        SelectorsGroup sg = this.createSelectorsGroup();
        for (Selector s : selectors) {
            sg.addSelector(s);
        }
        return sg;
    }

    @Override
    public Selector createSelector() {
        return new SelectorI(this.model);
    }

    @Override
    public Selector createSelector(CharSequence code) {
        return new SelectorI(this.model, code);
    }

    @Override
    public Declarations createDeclarations() {
        return new DeclarationsI(this.model);
    }

    @Override
    public Declarations createDeclarations(Declaration ... declarations) {
        Declarations ds = this.createDeclarations();
        for (Declaration d : declarations) {
            ds.addDeclaration(d);
        }
        return ds;
    }

    @Override
    public Declaration createDeclaration() {
        return new DeclarationI(this.model);
    }

    @Override
    public Declaration createDeclaration(Property property, PropertyValue propertyValue, boolean isImportant) {
        Declaration d = this.createDeclaration();
        d.setProperty(property);
        d.setPropertyValue(propertyValue);
        Prio prio = this.createPrio();
        prio.setContent(isImportant ? "!" : "");
        d.setPrio(prio);
        return d;
    }

    @Override
    public Property createProperty() {
        return new PropertyI(this.model);
    }

    @Override
    public Property createProperty(CharSequence propertyName) {
        Property p = this.createProperty();
        p.setContent(propertyName);
        return p;
    }

    @Override
    public PropertyValue createPropertyValue() {
        return new PropertyValueI(this.model);
    }

    @Override
    public PropertyValue createPropertyValue(Expression expression) {
        PropertyValue pv = this.createPropertyValue();
        pv.setExpression(expression);
        return pv;
    }

    @Override
    public Expression createExpression() {
        return new ExpressionI(this.model);
    }

    @Override
    public Expression createExpression(CharSequence expression) {
        Expression e = this.createExpression();
        e.setContent(expression);
        return e;
    }

    @Override
    public Prio createPrio() {
        return new PrioI(this.model);
    }

    @Override
    public PlainElement createPlainElement() {
        return new PlainElementI(this.model);
    }

    @Override
    public PlainElement createPlainElement(CharSequence text) {
        return new PlainElementI(this.model, text);
    }

    @Override
    public MediaQueryOperator createMediaQueryOperator() {
        return new MediaQueryOperatorI(this.model);
    }

    @Override
    public MediaExpression createMediaExpression() {
        return new MediaExpressionI(this.model);
    }

    @Override
    public MediaExpression createMediaExpression(MediaFeature mediaFeature, Expression expression) {
        MediaExpression me = this.createMediaExpression();
        me.setMediaFeature(mediaFeature);
        me.setExpression(expression);
        return me;
    }

    @Override
    public MediaFeature createMediaFeature() {
        return new MediaFeatureI(this.model);
    }

    @Override
    public MediaType createMediaType() {
        return new MediaTypeI(this.model);
    }

    @Override
    public Media createMedia() {
        return new MediaI(this.model);
    }

    @Override
    public Page createPage() {
        return new PageI(this.model);
    }

    @Override
    public Page createPage(CharSequence source) {
        return new PageI(this.model, source);
    }

    @Override
    public MediaQueryOperator createMediaQueryOperator(CharSequence text) {
        return new MediaQueryOperatorI(this.model, text);
    }

    @Override
    public MediaFeature createMediaFeature(CharSequence text) {
        return new MediaFeatureI(this.model, text);
    }

    @Override
    public MediaType createMediaType(CharSequence text) {
        return new MediaTypeI(this.model, text);
    }

    @Override
    public MediaQuery createMediaQuery(MediaQueryOperator mediaQueryOperator, MediaType mediaType, MediaExpression ... mediaExpression) {
        MediaQuery mq = this.createMediaQuery();
        mq.setMediaQueryOperator(mediaQueryOperator);
        mq.setMediaType(mediaType);
        for (MediaExpression me : mediaExpression) {
            mq.addMediaExpression(me);
        }
        return mq;
    }

    @Override
    public MediaQueryList createMediaQueryList(MediaQuery ... mediaQuery) {
        MediaQueryList mql = this.createMediaQueryList();
        for (MediaQuery mq : mediaQuery) {
            mql.addMediaQuery(mq);
        }
        return mql;
    }

    @Override
    public Media createMedia(MediaQueryList mediaQueryList, Rule ... rule) {
        Media media = this.createMedia();
        media.setMediaQueryList(mediaQueryList);
        for (Rule r : rule) {
            media.addRule(r);
        }
        return media;
    }

    @Override
    public Media createMedia(MediaQueryList mediaQueryList, Page ... page) {
        Media media = this.createMedia();
        for (Page p : page) {
            media.addPage(p);
        }
        return media;
    }

    @Override
    public VendorAtRule createVendorAtRule() {
        return new VendorAtRuleI(this.model);
    }

    @Override
    public AtRuleId createAtRuleId() {
        return new AtRuleIdI(this.model);
    }

    @Override
    public AtRuleId createAtRuleId(CharSequence text) {
        AtRuleId atRuleId = this.createAtRuleId();
        atRuleId.setContent(text);
        return atRuleId;
    }

    @Override
    public MozDocument createMozDocument() {
        return new MozDocumentI(this.model);
    }

    @Override
    public MozDocumentFunction createMozDocumentFunction() {
        return new MozDocumentFunctionI(this.model);
    }

    @Override
    public GenericAtRule createGenericAtRule() {
        return new GenericAtRuleI(this.model);
    }

    @Override
    public WebkitKeyframes createWebkitKeyFrames() {
        return new WebkitKeyframesI(this.model);
    }

    @Override
    public WebkitKeyframesBlock createWebkitKeyFramesBlock() {
        return new WebkitKeyframesBlockI(this.model);
    }

    @Override
    public WebkitKeyframeSelectors createWebkitKeyframeSelectors() {
        return new WebkitKeyframeSelectorsI(this.model);
    }
}

