/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.model.api.Declaration;
import org.netbeans.modules.css.model.api.Declarations;
import org.netbeans.modules.css.model.api.Expression;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.PlainElement;
import org.netbeans.modules.css.model.api.PropertyValue;
import org.netbeans.modules.css.model.api.semantic.PModel;
import org.netbeans.modules.css.model.api.semantic.box.BoxType;
import org.netbeans.modules.css.model.impl.ModelElement;
import org.netbeans.modules.css.model.impl.ModelElementListener;
import org.netbeans.modules.css.model.impl.semantic.box.DeclarationsBoxModelProvider;
import org.openide.util.CharSequences;

public class DeclarationsI
extends ModelElement
implements Declarations {
    private List<Declaration> declarations = new ArrayList<Declaration>();
    private final ModelElementListener elementListener = new ModelElementListener.Adapter(){

        @Override
        public void elementAdded(Declaration declaration) {
            DeclarationsI.this.declarations.add(declaration);
        }

        @Override
        public void elementRemoved(Declaration declaration) {
            DeclarationsI.this.declarations.remove(declaration);
        }
    };

    public DeclarationsI(Model model) {
        super(model);
    }

    public DeclarationsI(Model model, Node node) {
        super(model, node);
        this.initChildrenElements();
    }

    @Override
    public Collection<? extends PModel> getSemanticModels() {
        if (this.isValid()) {
            ArrayList<PModel> models = new ArrayList<PModel>();
            DeclarationsBoxModelProvider dbm = new DeclarationsBoxModelProvider(this.model, this);
            models.add((PModel)((Object)dbm.getBox(BoxType.MARGIN)));
            models.add((PModel)((Object)dbm.getBox(BoxType.PADDING)));
            models.add((PModel)((Object)dbm.getBox(BoxType.BORDER_COLOR)));
            models.add((PModel)((Object)dbm.getBox(BoxType.BORDER_STYLE)));
            models.add((PModel)((Object)dbm.getBox(BoxType.BORDER_WIDTH)));
            return models;
        }
        return Collections.emptyList();
    }

    @Override
    public List<Declaration> getDeclarations() {
        return this.declarations;
    }

    @Override
    protected ModelElementListener getElementListener() {
        return this.elementListener;
    }

    @Override
    public void addDeclaration(Declaration declaration) {
        PropertyValue propertyValue;
        Declaration last;
        int lastIndex;
        PlainElement pe;
        if (!(this.getDeclarations().isEmpty() || (pe = this.getElementAt((lastIndex = this.getElementIndex(last = this.getDeclarations().get(this.getDeclarations().size() - 1))) + 1, PlainElement.class)) != null && CharSequences.indexOf((CharSequence)pe.getContent(), (CharSequence)";") != -1 || (propertyValue = last.getPropertyValue()) == null)) {
            Expression expression = propertyValue.getExpression();
            CharSequence content = expression.getContent();
            for (int i = content.length() - 1; i >= 0; --i) {
                char c = content.charAt(i);
                if (Character.isWhitespace(c)) continue;
                StringBuilder sb = new StringBuilder();
                sb.append(content.subSequence(0, i + 1));
                sb.append(';');
                sb.append(content.subSequence(i + 1, content.length()));
                expression.setContent(sb);
                break;
            }
        }
        this.addElement(declaration);
        this.addTextElement(";\n");
    }

    @Override
    public boolean removeDeclaration(Declaration declaration) {
        PlainElement after;
        int index = this.getElementIndex(declaration);
        if (index == -1) {
            return false;
        }
        this.removeElement(index);
        PlainElement before = this.getElementAt(index - 1, PlainElement.class);
        if (before != null) {
            this.wipeWhitespaces(before, false);
        }
        if ((after = this.getElementAt(index, PlainElement.class)) != null) {
            String afterTrimmed = ((Object)after.getContent()).toString().trim();
            if (";".equals(afterTrimmed)) {
                this.removeElement(index);
                PlainElement afterafter = this.getElementAt(index, PlainElement.class);
                if (afterafter != null) {
                    this.wipeWhitespaces(afterafter, true);
                }
            } else {
                this.wipeWhitespaces(after, true);
            }
        }
        return true;
    }

    @Override
    protected Class getModelClass() {
        return Declarations.class;
    }
}

