/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.model.api;

import java.util.Collection;
import org.netbeans.modules.css.model.api.Body;
import org.netbeans.modules.css.model.api.Declaration;
import org.netbeans.modules.css.model.api.Declarations;
import org.netbeans.modules.css.model.api.ElementFactory;
import org.netbeans.modules.css.model.api.Media;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.ModelVisitor;
import org.netbeans.modules.css.model.api.Property;
import org.netbeans.modules.css.model.api.PropertyValue;
import org.netbeans.modules.css.model.api.Rule;
import org.netbeans.modules.css.model.api.SelectorsGroup;
import org.netbeans.modules.css.model.api.StyleSheet;
import org.netbeans.modules.web.common.api.LexerUtils;

public class ModelUtils {
    private Model model;
    private StyleSheet styleSheet;
    private ElementFactory factory;

    public ModelUtils(Model model) {
        this.model = model;
        this.factory = model.getElementFactory();
        this.styleSheet = model.getStyleSheet();
    }

    public Rule createRule(Collection<String> selectors, Collection<String> declarations) {
        SelectorsGroup selectorsGroup = this.factory.createSelectorsGroup();
        for (String selectorName : selectors) {
            selectorsGroup.addSelector(this.factory.createSelector(selectorName));
        }
        Declarations decls = this.factory.createDeclarations();
        for (String declaration : declarations) {
            decls.addDeclaration(this.createDeclaration(declaration));
        }
        return this.factory.createRule(selectorsGroup, decls);
    }

    public Body getBody() {
        Body body = this.styleSheet.getBody();
        if (body == null) {
            body = this.factory.createBody();
            this.styleSheet.setBody(body);
        }
        return body;
    }

    public Declaration createDeclaration(String code) {
        int separatorIndex = code.indexOf(58);
        if (separatorIndex == -1) {
            throw new IllegalArgumentException(String.format("Bad declaration value (forgotten colon): %s", code));
        }
        String propertyImg = code.substring(0, separatorIndex);
        String valueImg = code.substring(separatorIndex + 1);
        Property property = this.factory.createProperty(propertyImg);
        PropertyValue propertyValue = this.factory.createPropertyValue(this.factory.createExpression(valueImg));
        return this.factory.createDeclaration(property, propertyValue, false);
    }

    public Rule findMatchingRule(Model model, Rule rule) {
        assert (rule.getModel() == model);
        if (rule.getParent() == null) {
            return null;
        }
        final RuleRefModelVisitor ruleRef = new RuleRefModelVisitor(model, rule);
        model.runReadTask(new Model.ModelTask(){

            @Override
            public void run(StyleSheet styleSheet) {
                styleSheet.accept(ruleRef);
            }
        });
        int ruleIndex = ruleRef.getRuleIndex();
        assert (ruleIndex != -1);
        CharSequence ruleId = LexerUtils.trim((CharSequence)ruleRef.getRuleId());
        ResolveRuleRefModelVisitor resolveRuleRef = new ResolveRuleRefModelVisitor(this.model, ruleId, ruleIndex);
        this.styleSheet.accept(resolveRuleRef);
        return resolveRuleRef.getResolvedRule();
    }

    public Media findMatchingMedia(Model model, Media media) {
        assert (media.getModel() == model);
        if (media.getParent() == null) {
            return null;
        }
        final MediaRefModelVisitor ruleRef = new MediaRefModelVisitor(model, media);
        model.runReadTask(new Model.ModelTask(){

            @Override
            public void run(StyleSheet styleSheet) {
                styleSheet.accept(ruleRef);
            }
        });
        int mediaIndex = ruleRef.getMediaIndex();
        assert (mediaIndex != -1);
        CharSequence ruleId = LexerUtils.trim((CharSequence)ruleRef.getMediaId());
        ResolveMediaRefModelVisitor resolveRuleRef = new ResolveMediaRefModelVisitor(this.model, ruleId, mediaIndex);
        this.styleSheet.accept(resolveRuleRef);
        return resolveRuleRef.getResolvedMedia();
    }

    private static class ResolveMediaRefModelVisitor
    extends ModelVisitor.Adapter {
        private final Model model;
        private final CharSequence mediaId;
        private final int ruleIndex;
        private int index;
        private Media rule;
        private boolean cancelled;

        public ResolveMediaRefModelVisitor(Model model, CharSequence ruleId, int ruleIndex) {
            this.model = model;
            this.mediaId = ruleId;
            this.ruleIndex = ruleIndex;
        }

        @Override
        public void visitMedia(Media rule) {
            if (this.cancelled) {
                return;
            }
            CharSequence foundRuleId = LexerUtils.trim((CharSequence)this.model.getElementSource(rule.getMediaQueryList()));
            if (LexerUtils.equals((CharSequence)this.mediaId, (CharSequence)foundRuleId, (boolean)false, (boolean)false)) {
                if (this.index == this.ruleIndex) {
                    this.rule = rule;
                    this.cancelled = true;
                } else {
                    ++this.index;
                }
            }
        }

        public Media getResolvedMedia() {
            return this.rule;
        }
    }

    private static class MediaRefModelVisitor
    extends ModelVisitor.Adapter {
        private final Model model;
        private final Media media;
        private CharSequence ruleId;
        private int ruleIndex = -1;
        private boolean cancelled;

        public MediaRefModelVisitor(Model model, Media rule) {
            this.model = model;
            this.media = rule;
        }

        @Override
        public void visitMedia(Media rule) {
            if (this.cancelled) {
                return;
            }
            CharSequence foundRuleId = LexerUtils.trim((CharSequence)this.model.getElementSource(rule.getMediaQueryList()));
            if (LexerUtils.equals((CharSequence)this.getMediaId(), (CharSequence)foundRuleId, (boolean)false, (boolean)false)) {
                ++this.ruleIndex;
            }
            if (this.media == rule) {
                this.cancelled = true;
            }
        }

        public int getMediaIndex() {
            return this.ruleIndex;
        }

        public synchronized CharSequence getMediaId() {
            if (this.ruleId == null) {
                this.ruleId = LexerUtils.trim((CharSequence)this.model.getElementSource(this.media.getMediaQueryList()));
            }
            return this.ruleId;
        }
    }

    private static class ResolveRuleRefModelVisitor
    extends ModelVisitor.Adapter {
        private final Model model;
        private final CharSequence ruleId;
        private final int ruleIndex;
        private int index;
        private Rule rule;
        private boolean cancelled;

        public ResolveRuleRefModelVisitor(Model model, CharSequence ruleId, int ruleIndex) {
            this.model = model;
            this.ruleId = ruleId;
            this.ruleIndex = ruleIndex;
        }

        @Override
        public void visitRule(Rule rule) {
            if (this.cancelled) {
                return;
            }
            CharSequence foundRuleId = LexerUtils.trim((CharSequence)this.model.getElementSource(rule.getSelectorsGroup()));
            if (LexerUtils.equals((CharSequence)this.ruleId, (CharSequence)foundRuleId, (boolean)false, (boolean)false)) {
                if (this.index == this.ruleIndex) {
                    this.rule = rule;
                    this.cancelled = true;
                } else {
                    ++this.index;
                }
            }
        }

        public Rule getResolvedRule() {
            return this.rule;
        }
    }

    private static class RuleRefModelVisitor
    extends ModelVisitor.Adapter {
        private final Model model;
        private final Rule rule;
        private CharSequence ruleId;
        private int ruleIndex = -1;
        private boolean cancelled;

        public RuleRefModelVisitor(Model model, Rule rule) {
            this.model = model;
            this.rule = rule;
        }

        @Override
        public void visitRule(Rule rule) {
            if (this.cancelled) {
                return;
            }
            CharSequence foundRuleId = LexerUtils.trim((CharSequence)this.model.getElementSource(rule.getSelectorsGroup()));
            if (LexerUtils.equals((CharSequence)this.getRuleId(), (CharSequence)foundRuleId, (boolean)false, (boolean)false)) {
                ++this.ruleIndex;
            }
            if (this.rule == rule) {
                this.cancelled = true;
            }
        }

        public int getRuleIndex() {
            return this.ruleIndex;
        }

        public synchronized CharSequence getRuleId() {
            if (this.ruleId == null) {
                this.ruleId = LexerUtils.trim((CharSequence)this.model.getElementSource(this.rule.getSelectorsGroup()));
            }
            return this.ruleId;
        }
    }
}

