/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.model.api;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.diff.Difference;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeType;
import org.netbeans.modules.css.lib.api.NodeUtil;
import org.netbeans.modules.css.live.LiveUpdater;
import org.netbeans.modules.css.model.ModelAccess;
import org.netbeans.modules.css.model.api.Element;
import org.netbeans.modules.css.model.api.ElementFactory;
import org.netbeans.modules.css.model.api.PlainElement;
import org.netbeans.modules.css.model.api.StyleSheet;
import org.netbeans.modules.css.model.impl.ElementFactoryImpl;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.spi.diff.DiffProvider;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class Model
implements PropertyChangeListener {
    public static final String CHANGES_APPLIED_TO_DOCUMENT = "changes.applied";
    public static final String NO_CHANGES_APPLIED_TO_DOCUMENT = "no.changes.to.apply";
    public static final String MODEL_WRITE_TASK_FINISHED = "model.write.task.finished";
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private static final Logger LOGGER = Logger.getLogger("css.model");
    private final Mutex MODEL_MUTEX = new Mutex();
    private Lookup MODEL_LOOKUP;
    private DocumentLookup documentLookup;
    private ElementFactory ELEMENT_FACTORY;
    private boolean changesApplied;
    private int modelSerialNumber;
    private static int globalModelSerialNumber;
    private EditorCookie.Observable editorCookie;
    private DataObject dataObject;
    private static final OffsetConvertor DIRECT_OFFSET_CONVERTOR;

    public static synchronized Model getModel(CssParserResult parserResult) {
        Model model = (Model)parserResult.getProperty(Model.class);
        if (model == null) {
            model = Model.createModel(parserResult);
            parserResult.setProperty(Model.class, (Object)model);
        }
        return model;
    }

    public static Model createModel(CssParserResult parserResult) {
        return new Model(parserResult);
    }

    private Model(int modelSerialNumber) {
        this.modelSerialNumber = modelSerialNumber;
    }

    Model() {
        this(++globalModelSerialNumber);
        this.MODEL_LOOKUP = Lookups.fixed((Object[])new Object[]{this.getElementFactory().createStyleSheet()});
    }

    Model(CssParserResult parserResult) {
        this(++globalModelSerialNumber);
        Node styleSheetNode = NodeUtil.query((Node)parserResult.getParseTree(), (String)NodeType.styleSheet.name());
        ArrayList<Object> lookupContent = new ArrayList<Object>();
        if (styleSheetNode == null) {
            lookupContent.add(this.getElementFactory().createStyleSheet());
        } else {
            lookupContent.add(styleSheetNode);
            lookupContent.add((StyleSheet)Model.getElementFactoryImpl(this).createElement(this, styleSheetNode));
        }
        Snapshot snapshot = parserResult.getSnapshot();
        Source source = snapshot.getSource();
        FileObject file = source.getFileObject();
        Document doc = source.getDocument(true);
        lookupContent.add(parserResult);
        lookupContent.add(snapshot);
        lookupContent.add(snapshot.getText());
        if (file != null) {
            lookupContent.add(file);
            try {
                this.dataObject = DataObject.find((FileObject)file);
                this.editorCookie = (EditorCookie.Observable)this.dataObject.getLookup().lookup(EditorCookie.Observable.class);
                this.editorCookie.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.editorCookie));
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.documentLookup = new DocumentLookup();
        if (doc != null) {
            this.documentLookup.updateLookup(Lookups.fixed((Object[])new Object[]{doc}));
        }
        this.MODEL_LOOKUP = new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])lookupContent.toArray()), this.documentLookup});
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        Object newValue;
        if ("document".equals(pce.getPropertyName()) && (newValue = pce.getNewValue()) == null) {
            try {
                if (this.dataObject.isValid()) {
                    StyledDocument newDocument = this.editorCookie.openDocument();
                    this.documentLookup.updateLookup(Lookups.fixed((Object[])new Object[]{newDocument}));
                    LOGGER.log(Level.FINE, "Model: {0}: new document instance set to {0} upon EditorCookie.Observable.PROP_DOCUMENT property change.", new Object[]{this, System.identityHashCode(newDocument)});
                } else {
                    this.documentLookup.updateLookup(Lookups.fixed((Object[])new Object[0]));
                    LOGGER.log(Level.FINE, "Model: {0}: DataObject become invalid.", new Object[]{this});
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public int getSerialNumber() {
        return this.modelSerialNumber;
    }

    public Lookup getLookup() {
        return this.MODEL_LOOKUP;
    }

    public void runReadTask(final ModelTask runnable) {
        this.MODEL_MUTEX.readAccess(new Runnable(){

            @Override
            public void run() {
                runnable.run(Model.this.getStyleSheet());
            }
        });
    }

    public void runWriteTask(final ModelTask runnable) {
        if (this.changesApplied) {
            throw new IllegalStateException("trying to write to already saved model!");
        }
        this.MODEL_MUTEX.writeAccess(new Runnable(){

            @Override
            public void run() {
                runnable.run(Model.this.getStyleSheet());
            }
        });
        this.support.firePropertyChange(MODEL_WRITE_TASK_FINISHED, null, null);
    }

    public CharSequence getOriginalSource() {
        return (CharSequence)this.getLookup().lookup(CharSequence.class);
    }

    public CharSequence getModelSource() {
        return this.getElementSource(this.getStyleSheet());
    }

    public CharSequence getElementSource(Element element) {
        this.checkModelAccess();
        StringBuilder b = new StringBuilder();
        this.getElementSource(element, b);
        return b;
    }

    public Difference[] getModelSourceDiff() throws IOException {
        DiffProvider diffProvider = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
        StringReader r1 = new StringReader(((Object)this.getOriginalSource()).toString());
        StringReader r2 = new StringReader(((Object)this.getModelSource()).toString());
        Difference[] diffs = diffProvider.computeDiff((Reader)r1, (Reader)r2);
        return diffs;
    }

    public boolean applyChanges() throws IOException, BadLocationException {
        if (this.changesApplied) {
            throw new IllegalStateException("Trying to save already saved model!");
        }
        Document doc = (Document)this.getLookup().lookup(Document.class);
        if (doc == null) {
            throw new IllegalStateException("Trying to save model with invalidated DataObject!");
        }
        Difference[] diff = this.getModelSourceDiff();
        if (diff.length > 0) {
            Snapshot snapshot = (Snapshot)this.getLookup().lookup(Snapshot.class);
            if (this.dataObject != null) {
                LiveUpdater liveUpdater;
                SaveCookie saveCookie;
                boolean modified = this.dataObject.getLookup().lookup(SaveCookie.class) != null;
                this.applyChanges_AtomicLock(doc, diff, new SnapshotOffsetConvertor(snapshot));
                if (!modified && (saveCookie = (SaveCookie)this.dataObject.getLookup().lookup(SaveCookie.class)) != null) {
                    saveCookie.save();
                }
                if ((liveUpdater = (LiveUpdater)Lookup.getDefault().lookup(LiveUpdater.class)) != null) {
                    liveUpdater.update(doc);
                }
            } else {
                this.applyChanges_AtomicLock(doc, diff, new SnapshotOffsetConvertor(snapshot));
            }
            LOGGER.log(Level.INFO, "{0}: changes applied to document", this);
            this.changesApplied = true;
            this.support.firePropertyChange(CHANGES_APPLIED_TO_DOCUMENT, null, null);
            return true;
        }
        LOGGER.log(Level.INFO, "{0}: requested applyChanges, but there were none", this);
        this.support.firePropertyChange(NO_CHANGES_APPLIED_TO_DOCUMENT, null, null);
        return false;
    }

    private void applyChanges_AtomicLock(final Document document, final Difference[] diff, final OffsetConvertor convertor) throws IOException, BadLocationException {
        BaseDocument bdoc = (BaseDocument)document;
        final AtomicReference io_exc_ref = new AtomicReference();
        final AtomicReference ble_exc_ref = new AtomicReference();
        bdoc.runAtomicAsUser(new Runnable(){

            @Override
            public void run() {
                try {
                    Model.this.applyChanges(document, diff, convertor);
                }
                catch (IOException ex) {
                    io_exc_ref.set(ex);
                }
                catch (BadLocationException ex) {
                    ble_exc_ref.set(ex);
                }
            }
        });
        if (io_exc_ref.get() != null) {
            throw (IOException)io_exc_ref.get();
        }
        if (ble_exc_ref.get() != null) {
            throw (BadLocationException)ble_exc_ref.get();
        }
    }

    public synchronized ElementFactory getElementFactory() {
        if (this.ELEMENT_FACTORY == null) {
            this.ELEMENT_FACTORY = Model.getElementFactoryImpl(this);
        }
        return this.ELEMENT_FACTORY;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    StyleSheet getStyleSheet() {
        this.checkModelAccess();
        return (StyleSheet)this.getLookup().lookup(StyleSheet.class);
    }

    private void getElementSource(Element e, StringBuilder b) {
        if (e instanceof PlainElement) {
            b.append(((PlainElement)e).getContent());
        }
        Iterator<Element> itr = e.childrenIterator();
        while (itr.hasNext()) {
            Element element = itr.next();
            if (element == null) continue;
            this.getElementSource(element, b);
        }
    }

    private void checkModelAccess() {
        if (ModelAccess.checkModelAccess && !this.MODEL_MUTEX.isReadAccess() && !this.MODEL_MUTEX.isWriteAccess()) {
            LOGGER.log(Level.WARNING, "Model access outside of Model.runRead/WriteTask()!", new IllegalAccessException());
        }
    }

    private void applyChanges(Document document, Difference[] diff, OffsetConvertor convertor) throws IOException, BadLocationException {
        int sourceDelta = 0;
        block5: for (Difference d : diff) {
            int firstStart = d.getFirstStart();
            int from = convertor.getOriginalOffset(LexerUtils.getLineBeginningOffset((CharSequence)this.getOriginalSource(), (int)(firstStart == 0 ? 0 : firstStart - 1)));
            switch (d.getType()) {
                case 2: {
                    String first = d.getFirstText();
                    String second = d.getSecondText();
                    if (first.endsWith("\n") && second.endsWith("\n")) {
                        first = first.substring(0, first.length() - 1);
                        second = second.substring(0, second.length() - 1);
                    }
                    int len = first.length();
                    document.remove(sourceDelta + from, len);
                    document.insertString(sourceDelta + from, second, null);
                    int insertLen = second.length();
                    sourceDelta += insertLen - len;
                    continue block5;
                }
                case 1: {
                    from = convertor.getOriginalOffset(LexerUtils.getLineBeginningOffset((CharSequence)this.getOriginalSource(), (int)d.getFirstStart()));
                    int len = d.getSecondText().length();
                    document.insertString(sourceDelta + from, d.getSecondText(), null);
                    sourceDelta += len;
                    continue block5;
                }
                case 0: {
                    int len = d.getFirstText().length();
                    document.remove(sourceDelta + from, len);
                    sourceDelta -= len;
                }
            }
        }
    }

    public String toString() {
        FileObject file = (FileObject)this.getLookup().lookup(FileObject.class);
        Snapshot snapshot = (Snapshot)this.getLookup().lookup(Snapshot.class);
        Document doc = (Document)this.getLookup().lookup(Document.class);
        return this.getClass().getSimpleName() + ':' + this.getSerialNumber() + ", snapshot#=" + snapshot.hashCode() + ", file=" + (file != null ? file.getNameExt() : null) + ", document#=" + (doc != null ? Integer.valueOf(System.identityHashCode(doc)) : null) + ", saved=" + this.changesApplied;
    }

    private static ElementFactoryImpl getElementFactoryImpl(Model model) {
        return new ElementFactoryImpl(model);
    }

    static {
        DIRECT_OFFSET_CONVERTOR = new OffsetConvertor(){

            @Override
            public int getOriginalOffset(int documentOffset) {
                return documentOffset;
            }
        };
    }

    private static class DocumentLookup
    extends ProxyLookup {
        private DocumentLookup() {
        }

        protected final void updateLookup(Lookup lookup) {
            this.setLookups(new Lookup[]{lookup});
        }
    }

    private static class SnapshotOffsetConvertor
    implements OffsetConvertor {
        private Snapshot snapshot;

        public SnapshotOffsetConvertor(Snapshot snapshot) {
            this.snapshot = snapshot;
        }

        @Override
        public int getOriginalOffset(int embeddedOffset) {
            return this.snapshot.getOriginalOffset(embeddedOffset);
        }
    }

    private static interface OffsetConvertor {
        public int getOriginalOffset(int var1);
    }

    public static interface ModelTask {
        public void run(StyleSheet var1);
    }
}

