/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.samples;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.modules.php.samples.Bundle;
import org.netbeans.modules.php.samples.PHPSamplesWizardPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class PHPSamplesPanelVisual
extends JPanel
implements DocumentListener {
    public static final String PROP_PROJECT_NAME = "projectName";
    private PHPSamplesWizardPanel panel;
    private JButton browseButton;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;

    public PHPSamplesPanelVisual(PHPSamplesWizardPanel panel) {
        this.initComponents();
        this.panel = panel;
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
    }

    public String getProjectName() {
        return this.projectNameTextField.getText();
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(PHPSamplesPanelVisual.class, (String)"PHPSamplesPanelVisual.projectNameLabel.text"));
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(PHPSamplesPanelVisual.class, (String)"PHPSamplesPanelVisual.projectLocationLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(PHPSamplesPanelVisual.class, (String)"PHPSamplesPanelVisual.browseButton.text"));
        this.browseButton.setActionCommand("BROWSE");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PHPSamplesPanelVisual.this.browseButtonActionPerformed(evt);
            }
        });
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFolderLabel, (String)NbBundle.getMessage(PHPSamplesPanelVisual.class, (String)"PHPSamplesPanelVisual.createdFolderLabel.text"));
        this.createdFolderTextField.setEditable(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectNameLabel).addComponent(this.projectLocationLabel).addComponent(this.createdFolderLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectNameTextField, GroupLayout.Alignment.TRAILING, -1, 191, Short.MAX_VALUE).addComponent(this.projectLocationTextField, GroupLayout.Alignment.TRAILING, -1, 191, Short.MAX_VALUE).addComponent(this.createdFolderTextField, GroupLayout.Alignment.TRAILING, -1, 191, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectNameLabel).addComponent(this.projectNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectLocationLabel).addComponent(this.projectLocationTextField, -2, -1, -2).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.createdFolderLabel).addComponent(this.createdFolderTextField, -2, -1, -2)).addContainerGap(213, Short.MAX_VALUE)));
        this.projectNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PHPSamplesPanelVisual.class, (String)"PHPSamplesPanelVisual.projectNameLabel.AccessibleContext.accessibleName"));
        this.projectNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PHPSamplesPanelVisual.class, (String)"PHPSamplesPanelVisual.projectNameLabel.AccessibleContext.accessibleDescription"));
        this.projectNameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PHPSamplesPanelVisual.class, (String)"PHPSamplesPanelVisual.projectNameTextField.AccessibleContext.accessibleName"));
        this.projectNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PHPSamplesPanelVisual.class, (String)"PHPSamplesPanelVisual.projectNameTextField.AccessibleContext.accessibleDescription"));
        this.projectLocationLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PHPSamplesPanelVisual.class, (String)"PHPSamplesPanelVisual.projectLocationLabel.AccessibleContext.accessibleName"));
        this.projectLocationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PHPSamplesPanelVisual.class, (String)"PHPSamplesPanelVisual.projectLocationLabel.AccessibleContext.accessibleDescription"));
        this.projectLocationTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PHPSamplesPanelVisual.class, (String)"PHPSamplesPanelVisual.projectLocationTextField.AccessibleContext.accessibleName"));
        this.projectLocationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PHPSamplesPanelVisual.class, (String)"PHPSamplesPanelVisual.projectLocationTextField.AccessibleContext.accessibleDescription"));
        this.browseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PHPSamplesPanelVisual.class, (String)"PHPSamplesPanelVisual.browseButton.AccessibleContext.accessibleName"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PHPSamplesPanelVisual.class, (String)"PHPSamplesPanelVisual.browseButton.AccessibleContext.accessibleDescription"));
        this.createdFolderLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PHPSamplesPanelVisual.class, (String)"PHPSamplesPanelVisual.createdFolderLabel.AccessibleContext.accessibleName"));
        this.createdFolderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PHPSamplesPanelVisual.class, (String)"PHPSamplesPanelVisual.createdFolderLabel.AccessibleContext.accessibleDescription"));
        this.createdFolderTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PHPSamplesPanelVisual.class, (String)"PHPSamplesPanelVisual.createdFolderTextField.AccessibleContext.accessibleName"));
        this.createdFolderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PHPSamplesPanelVisual.class, (String)"PHPSamplesPanelVisual.createdFolderTextField.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PHPSamplesPanelVisual.class, (String)"PHPSamplesPanelVisual.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PHPSamplesPanelVisual.class, (String)"PHPSamplesPanelVisual.AccessibleContext.accessibleDescription"));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File selectedFile;
        File f;
        FileChooserBuilder builder = new FileChooserBuilder(PHPSamplesPanelVisual.class).setTitle(Bundle.PhpSamplePanelVisual_fileChooser_title()).setDirectoriesOnly(true).forceUseOfDefaultWorkingDirectory(true);
        String path = this.projectLocationTextField.getText();
        if (path.length() > 0 && (f = new File(path)).exists()) {
            builder.setDefaultWorkingDirectory(f);
        }
        if ((selectedFile = builder.showOpenDialog()) != null) {
            this.projectLocationTextField.setText(FileUtil.normalizeFile((File)selectedFile).getAbsolutePath());
        }
        this.panel.fireChangeEvent();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        File destFolder;
        File projLoc;
        if (this.projectNameTextField.getText().length() == 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"Project Name is not a valid folder name.");
            return false;
        }
        File f = FileUtil.normalizeFile((File)new File(this.projectLocationTextField.getText()).getAbsoluteFile());
        if (!f.isDirectory()) {
            String message = "Project Folder is not a valid path.";
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)message);
            return false;
        }
        for (projLoc = destFolder = FileUtil.normalizeFile((File)new File(this.createdFolderTextField.getText()).getAbsoluteFile()); projLoc != null && !projLoc.exists(); projLoc = projLoc.getParentFile()) {
        }
        if (projLoc == null || !projLoc.canWrite()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"Project Folder cannot be created.");
            return false;
        }
        if (FileUtil.toFileObject((File)projLoc) == null) {
            String message = "Project Folder is not a valid path.";
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)message);
            return false;
        }
        File[] kids = destFolder.listFiles();
        if (destFolder.exists() && kids != null && kids.length > 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"Project Folder already exists and is not empty.");
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    void store(WizardDescriptor d) {
        String name = this.projectNameTextField.getText().trim();
        String folder = this.createdFolderTextField.getText().trim();
        d.putProperty("projdir", (Object)new File(folder));
        d.putProperty("name", (Object)name);
    }

    void read(WizardDescriptor settings) {
        File projectLocation = (File)settings.getProperty("projdir");
        projectLocation = projectLocation == null || projectLocation.getParentFile() == null || !projectLocation.getParentFile().isDirectory() ? ProjectChooser.getProjectsFolder() : projectLocation.getParentFile();
        this.projectLocationTextField.setText(projectLocation.getAbsolutePath());
        String projectName = (String)settings.getProperty("name");
        if (projectName == null) {
            projectName = "sample";
        }
        String newProjectName = projectName;
        File testFile = new File(projectLocation, projectName);
        if (testFile.exists()) {
            File[] files = projectLocation.listFiles();
            HashSet<String> filesSet = new HashSet<String>();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                String fileName = file.getName();
                if (fileName.indexOf(projectName) != 0 || !file.isDirectory()) continue;
                filesSet.add(fileName);
            }
            boolean dontHaveName = true;
            int i = 1;
            do {
                if (!filesSet.contains(newProjectName = projectName + i)) {
                    dontHaveName = false;
                    continue;
                }
                ++i;
            } while (dontHaveName);
            filesSet.clear();
        }
        this.projectNameTextField.setText(newProjectName);
        this.projectNameTextField.selectAll();
    }

    void validate(WizardDescriptor d) throws WizardValidationException {
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
    }

    private void updateTexts(DocumentEvent e) {
        Document doc = e.getDocument();
        if (doc == this.projectNameTextField.getDocument() || doc == this.projectLocationTextField.getDocument()) {
            String projectName = this.projectNameTextField.getText();
            String projectFolder = this.projectLocationTextField.getText();
            this.createdFolderTextField.setText(projectFolder + File.separatorChar + projectName);
        }
        this.panel.fireChangeEvent();
    }
}

