/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.util;

import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.spi.IssueProvider;
import org.netbeans.modules.bugtracking.spi.QueryProvider;
import org.netbeans.modules.bugtracking.spi.RepositoryProvider;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.ListValuePicker;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.kenai.KenaiRepository;
import org.netbeans.modules.bugzilla.query.BugzillaQuery;
import org.netbeans.modules.bugzilla.repository.BugzillaConfiguration;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.mylyn.util.BugtrackingCommand;
import org.netbeans.modules.mylyn.util.GetTaskDataCommand;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class BugzillaUtil {
    public static boolean show(JPanel panel, String title, String okName) {
        return BugzillaUtil.show(panel, title, okName, new HelpCtx(panel.getClass()));
    }

    public static boolean show(JPanel panel, String title, String okName, HelpCtx helpCtx) {
        JButton ok = new JButton(okName);
        ok.getAccessibleContext().setAccessibleDescription(ok.getText());
        JButton cancel = new JButton(NbBundle.getMessage(BugzillaUtil.class, (String)"LBL_Cancel"));
        cancel.getAccessibleContext().setAccessibleDescription(cancel.getText());
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, title, true, new Object[]{ok, cancel}, (Object)ok, 0, helpCtx, null);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == ok;
    }

    public static TaskData getTaskData(BugzillaRepository repository, String id) {
        return BugzillaUtil.getTaskData(repository, id, true);
    }

    public static TaskData getTaskData(BugzillaRepository repository, String id, boolean handleExceptions) {
        GetTaskDataCommand cmd = new GetTaskDataCommand((AbstractRepositoryConnector)Bugzilla.getInstance().getRepositoryConnector(), repository.getTaskRepository(), id);
        repository.getExecutor().execute((BugtrackingCommand)cmd, handleExceptions);
        if (cmd.hasFailed() && Bugzilla.LOG.isLoggable(Level.FINE)) {
            Bugzilla.LOG.log(Level.FINE, cmd.getErrorMessage());
        }
        return cmd.getTaskData();
    }

    public static String getKeywords(String message, String keywordsString, BugzillaRepository repository) {
        try {
            BugzillaConfiguration bc = repository.getConfiguration();
            if (bc == null || !bc.isValid()) {
                return keywordsString;
            }
            return ListValuePicker.getValues((String)NbBundle.getMessage(BugzillaUtil.class, (String)"CTL_KeywordsTitle"), (String)NbBundle.getMessage(BugzillaUtil.class, (String)"LBL_Keywords"), (String)message, (String)keywordsString, bc.getKeywords());
        }
        catch (Exception ex) {
            Bugzilla.LOG.log(Level.SEVERE, null, ex);
            return keywordsString;
        }
    }

    public static boolean isAssertEnabled() {
        boolean retval = false;
        if (!$assertionsDisabled) {
            retval = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return retval;
    }

    public static boolean isNbRepository(BugzillaRepository repo) {
        return BugtrackingUtil.isNbRepository((String)repo.getUrl());
    }

    public static boolean showQAContact(BugzillaRepository repo) {
        return BugzillaUtil.isNbRepository(repo) || !(repo instanceof KenaiRepository);
    }

    public static boolean showStatusWhiteboard(BugzillaRepository repo) {
        return BugzillaUtil.isNbRepository(repo) || !(repo instanceof KenaiRepository);
    }

    public static boolean showIssueType(BugzillaRepository repo) {
        return BugzillaUtil.isNbRepository(repo);
    }

    public static Repository getRepository(BugzillaRepository bugzillaRepository) {
        Repository repository = Bugzilla.getInstance().getBugtrackingFactory().getRepository("org.netbeans.modules.bugzilla", bugzillaRepository.getID());
        if (repository == null) {
            repository = Bugzilla.getInstance().getBugtrackingFactory().createRepository((Object)bugzillaRepository, (RepositoryProvider)Bugzilla.getInstance().getRepositoryProvider(), (QueryProvider)Bugzilla.getInstance().getQueryProvider(), (IssueProvider)Bugzilla.getInstance().getIssueProvider());
        }
        return repository;
    }

    public static void openIssue(BugzillaIssue bugzillaIssue) {
        Bugzilla.getInstance().getBugtrackingFactory().openIssue(BugzillaUtil.getRepository(bugzillaIssue.getRepository()), (Object)bugzillaIssue);
    }

    public static void openQuery(BugzillaQuery bugzillaQuery) {
        Bugzilla.getInstance().getBugtrackingFactory().openQuery(BugzillaUtil.getRepository(bugzillaQuery.getRepository()), (Object)bugzillaQuery);
    }
}

