/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.query;

import java.awt.Component;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListModel;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.BugzillaConfig;

public abstract class QueryParameter {
    static final ParameterValue[] EMPTY_PARAMETER_VALUE = new ParameterValue[]{new ParameterValue("", "")};
    static final ParameterValue PV_CONTAINS_ALL_KEYWORDS = new ParameterValue("contains all keywords", "allwords");
    static final ParameterValue PV_CONTAINS_ANY_KEYWORDS = new ParameterValue("contains any keywords", "anywords");
    static final ParameterValue PV_CONTAINS_NONE_KEYWORDS = new ParameterValue("contains none keywords", "nowords");
    static final ParameterValue PV_CONTAINS = new ParameterValue("contains", "substring");
    static final ParameterValue PV_IS = new ParameterValue("is", "exact");
    static final ParameterValue PV_MATCHES_REGEX = new ParameterValue("matches the regexp", "regexp");
    static final ParameterValue PV_DOESNT_MATCH_REGEX = new ParameterValue("doesn't match the regexp", "notregexp");
    static final ParameterValue PV_CONTAINS_ALL_STRINGS = new ParameterValue("contains all of the words/strings", "allwordssubstr");
    static final ParameterValue PV_CONTAINS_ANY_STRINGS = new ParameterValue("contains any of the words/strings", "anywordssubstr");
    static final ParameterValue PV_CONTAINS_THE_STRING = new ParameterValue("contains the string", "substring");
    static final ParameterValue PV_CONTAINS_THE_STRING_CASE = new ParameterValue("contains the string (exact case)", "casesubstring");
    static final ParameterValue PV_CONTAINS_ALL_WORDS = new ParameterValue("contains all of the words", "allwords");
    static final ParameterValue PV_CONTAINS_ANY_WORDS = new ParameterValue("contains any of the words", "anywords");
    static final ParameterValue PV_FIELD_BUG_CREATION = new ParameterValue("[Bug creation]", "[Bug+creation]");
    static final ParameterValue PV_FIELD_ALIAS = new ParameterValue("alias", "alias");
    static final ParameterValue PV_FIELD_ASSIGNED_TO = new ParameterValue("assigned_to", "assigned_to");
    static final ParameterValue PV_FIELD_LIST_ACCESSIBLE = new ParameterValue("cclist_accessible", "cclist_accessible");
    static final ParameterValue PV_FIELD_COMPONENT = new ParameterValue("component", "component");
    static final ParameterValue PV_FIELD_DEADLINE = new ParameterValue("deadline", "deadline");
    static final ParameterValue PV_FIELD_EVER_CONFIRMED = new ParameterValue("everconfirmed", "everconfirmed");
    static final ParameterValue PV_FIELD_REP_PLARFORM = new ParameterValue("rep_platform", "rep_platform");
    static final ParameterValue PV_FIELD_REMAINING_TIME = new ParameterValue("remaining_time", "remaining_time");
    static final ParameterValue PV_FIELD_WORK_TIME = new ParameterValue("work_time", "work_time");
    static final ParameterValue PV_FIELD_KEYWORDS = new ParameterValue("keywords", "keywords");
    static final ParameterValue PV_FIELD_ESTIMATED_TIME = new ParameterValue("estimated_time", "estimated_time");
    static final ParameterValue PV_FIELD_OP_SYS = new ParameterValue("op_sys", "op_sys");
    static final ParameterValue PV_FIELD_PRIORITY = new ParameterValue("priority", "priority");
    static final ParameterValue PV_FIELD_PRODUCT = new ParameterValue("product", "product");
    static final ParameterValue PV_FIELD_QA_CONTACT = new ParameterValue("qa_contact", "qa_contact");
    static final ParameterValue PV_FIELD_REPORTER_ACCESSIBLE = new ParameterValue("reporter_accessible", "reporter_accessible");
    static final ParameterValue PV_FIELD_RESOLUTION = new ParameterValue("resolution", "resolution");
    static final ParameterValue PV_FIELD_BUG_SEVERITY = new ParameterValue("bug_severity", "bug_severity");
    static final ParameterValue PV_FIELD_BUG_STATUS = new ParameterValue("bug_status", "bug_status");
    static final ParameterValue PV_FIELD_SHORT_DESC = new ParameterValue("short_desc", "short_desc");
    static final ParameterValue PV_FIELD_TARGET_MILESTONE = new ParameterValue("target_milestone", "target_milestone");
    static final ParameterValue PV_FIELD_BUG_FILE_LOC = new ParameterValue("bug_file_loc", "bug_file_loc");
    static final ParameterValue PV_FIELD_VERSION = new ParameterValue("version", "version");
    static final ParameterValue PV_FIELD_VOTES = new ParameterValue("votes", "votes");
    static final ParameterValue PV_FIELD_STATUS_WHITEBOARD = new ParameterValue("status_whiteboard", "status_whiteboard");
    static final ParameterValue[] PV_TEXT_SEARCH_VALUES = new ParameterValue[]{PV_CONTAINS_ALL_STRINGS, PV_CONTAINS_ANY_STRINGS, PV_CONTAINS_THE_STRING, PV_CONTAINS_THE_STRING_CASE, PV_CONTAINS_ALL_WORDS, PV_CONTAINS_ANY_WORDS, PV_MATCHES_REGEX, PV_DOESNT_MATCH_REGEX};
    static final ParameterValue[] PV_KEYWORDS_VALUES = new ParameterValue[]{PV_CONTAINS_ALL_KEYWORDS, PV_CONTAINS_ANY_KEYWORDS, PV_CONTAINS_NONE_KEYWORDS};
    static final ParameterValue[] PV_PEOPLE_VALUES = new ParameterValue[]{PV_CONTAINS, PV_IS, PV_MATCHES_REGEX, PV_DOESNT_MATCH_REGEX};
    static final ParameterValue[] PV_LAST_CHANGE = new ParameterValue[]{PV_FIELD_BUG_CREATION, PV_FIELD_ALIAS, PV_FIELD_ASSIGNED_TO, PV_FIELD_LIST_ACCESSIBLE, PV_FIELD_COMPONENT, PV_FIELD_DEADLINE, PV_FIELD_EVER_CONFIRMED, PV_FIELD_REP_PLARFORM, PV_FIELD_REMAINING_TIME, PV_FIELD_WORK_TIME, PV_FIELD_KEYWORDS, PV_FIELD_ESTIMATED_TIME, PV_FIELD_OP_SYS, PV_FIELD_PRIORITY, PV_FIELD_PRODUCT, PV_FIELD_QA_CONTACT, PV_FIELD_REPORTER_ACCESSIBLE, PV_FIELD_RESOLUTION, PV_FIELD_BUG_SEVERITY, PV_FIELD_BUG_STATUS, PV_FIELD_SHORT_DESC, PV_FIELD_TARGET_MILESTONE, PV_FIELD_BUG_FILE_LOC, PV_FIELD_VERSION, PV_FIELD_VOTES, PV_FIELD_STATUS_WHITEBOARD};
    private final String parameter;
    private final String encoding;
    protected boolean alwaysDisabled = false;

    public QueryParameter(String parameter, String encoding) {
        this.parameter = parameter;
        this.encoding = encoding;
    }

    public String getParameter() {
        return this.parameter;
    }

    abstract ParameterValue[] getValues();

    abstract void setValues(ParameterValue[] var1);

    void setAlwaysDisabled(boolean bl) {
        this.alwaysDisabled = bl;
        this.setEnabled(false);
    }

    abstract void setEnabled(boolean var1);

    public StringBuffer get(boolean encode) {
        ParameterValue[] values;
        StringBuffer sb = new StringBuffer();
        for (ParameterValue pv : values = this.getValues()) {
            sb.append("&");
            sb.append(this.getParameter());
            sb.append("=");
            if (encode) {
                try {
                    String value = pv.getValue();
                    if (value.equals("[Bug+creation]")) {
                        sb.append(URLEncoder.encode("[", this.encoding));
                        sb.append("Bug+creation");
                        sb.append(URLEncoder.encode("]", this.encoding));
                        continue;
                    }
                    sb.append(URLEncoder.encode(value, this.encoding));
                }
                catch (UnsupportedEncodingException ex) {
                    sb.append(URLEncoder.encode(pv.getValue()));
                    Bugzilla.LOG.log(Level.WARNING, null, ex);
                }
                continue;
            }
            sb.append(pv.getValue());
        }
        return sb;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(this.get(true));
        sb.append("]");
        return sb.toString();
    }

    public static class SimpleQueryParameter
    extends QueryParameter {
        private final String[] values;

        public SimpleQueryParameter(String parameter, String[] values, String encoding) {
            super(parameter, encoding);
            this.values = values;
        }

        @Override
        ParameterValue[] getValues() {
            if (this.values == null || this.values.length == 0) {
                return EMPTY_PARAMETER_VALUE;
            }
            ParameterValue[] ret = new ParameterValue[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                ret[i] = new ParameterValue(this.values[i]);
            }
            return ret;
        }

        @Override
        void setValues(ParameterValue[] values) {
        }

        @Override
        void setEnabled(boolean b) {
        }
    }

    static class PriorityRenderer
    extends ParameterValueCellRenderer {
        PriorityRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof ParameterValue) {
                String prio = ((ParameterValue)value).getValue();
                renderer.setIcon(BugzillaConfig.getInstance().getPriorityIcon(prio));
            } else {
                renderer.setIcon(null);
            }
            return renderer;
        }
    }

    static class ParameterValueCellRenderer
    extends DefaultListCellRenderer {
        ParameterValueCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof ParameterValue) {
                value = ((ParameterValue)value).getDisplayName();
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    static class ParameterValue {
        private final String displayName;
        private final String value;
        private String toString;

        public ParameterValue(String value) {
            this(value, value);
        }

        public ParameterValue(String displayName, String value) {
            assert (displayName != null);
            assert (value != null);
            this.displayName = displayName;
            this.value = value;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            if (this.toString == null) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.displayName);
                sb.append("[");
                sb.append(this.value);
                sb.append("]");
                this.toString = sb.toString();
            }
            return this.toString;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ParameterValue) {
                ParameterValue pv = (ParameterValue)obj;
                return this.value.equals(pv.value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    static class CheckBoxParameter
    extends QueryParameter {
        private ParameterValue[] selected = new ParameterValue[]{new ParameterValue("1")};
        private final JCheckBox chk;

        public CheckBoxParameter(JCheckBox chk, String parameter, String encoding) {
            super(parameter, encoding);
            this.chk = chk;
        }

        @Override
        public ParameterValue[] getValues() {
            return this.chk.isSelected() ? this.selected : EMPTY_PARAMETER_VALUE;
        }

        @Override
        public void setValues(ParameterValue[] pvs) {
            assert (pvs.length < 2);
            if (pvs.length == 0 || pvs[0] == null) {
                return;
            }
            this.chk.setSelected(pvs[0].getValue().equals("1"));
        }

        @Override
        void setEnabled(boolean b) {
            this.chk.setEnabled(this.alwaysDisabled ? false : b);
        }
    }

    static class AllWordsTextFieldParameter
    extends TextFieldParameter {
        public AllWordsTextFieldParameter(JTextField txt, String parameter, String encoding) {
            super(txt, parameter, encoding, true);
        }
    }

    static class TextFieldParameter
    extends QueryParameter {
        private final JTextField txt;
        private final boolean allWords;

        public TextFieldParameter(JTextField txt, String parameter, String encoding) {
            this(txt, parameter, encoding, false);
        }

        public TextFieldParameter(JTextField txt, String parameter, String encoding, boolean allWords) {
            super(parameter, encoding);
            this.txt = txt;
            this.allWords = allWords;
        }

        @Override
        public ParameterValue[] getValues() {
            String value = this.txt.getText();
            if (value == null || value.equals("")) {
                return EMPTY_PARAMETER_VALUE;
            }
            String[] split = value.split(" ");
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < split.length; ++i) {
                String s = split[i];
                sb.append(s);
                if (i >= split.length - 1) continue;
                sb.append(this.allWords ? " " : "+");
            }
            String v = sb.toString();
            return new ParameterValue[]{new ParameterValue(v, v)};
        }

        @Override
        public void setValues(ParameterValue[] pvs) {
            assert (pvs.length < 2);
            if (pvs.length == 0 || pvs[0] == null) {
                return;
            }
            String value = pvs[0].getValue();
            if (!this.allWords) {
                value = value.replace("+", " ");
            }
            this.txt.setText(value);
        }

        @Override
        void setEnabled(boolean b) {
            this.txt.setEnabled(this.alwaysDisabled ? false : b);
        }
    }

    static class ListParameter
    extends QueryParameter {
        private final JList list;

        public ListParameter(JList list, String parameter, String encoding) {
            super(parameter, encoding);
            this.list = list;
            list.setModel(new DefaultListModel());
        }

        @Override
        public ParameterValue[] getValues() {
            Object[] values = this.list.getSelectedValues();
            if (values == null || values.length == 0) {
                return EMPTY_PARAMETER_VALUE;
            }
            ParameterValue[] ret = new ParameterValue[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = (ParameterValue)values[i];
            }
            return ret;
        }

        public void setParameterValues(List<ParameterValue> values) {
            this.setParameterValues(values.toArray(new ParameterValue[values.size()]));
        }

        public void setParameterValues(ParameterValue[] values) {
            DefaultListModel<ParameterValue> m = new DefaultListModel<ParameterValue>();
            for (ParameterValue pv : values) {
                m.addElement(pv);
            }
            this.list.setModel(m);
        }

        @Override
        public void setValues(ParameterValue[] values) {
            int idx;
            if (values.length == 0) {
                return;
            }
            this.list.clearSelection();
            if (values.length == 1 && "".equals(values[0].getValue().trim())) {
                return;
            }
            LinkedList<Integer> selectionList = new LinkedList<Integer>();
            block0: for (int i = 0; i < values.length; ++i) {
                ListModel model = this.list.getModel();
                for (int j = 0; j < model.getSize(); ++j) {
                    ParameterValue pv = (ParameterValue)model.getElementAt(j);
                    if (!pv.getValue().toLowerCase().equals(values[i].getValue().toLowerCase())) continue;
                    selectionList.add(j);
                    continue block0;
                }
            }
            int[] selection = new int[selectionList.size()];
            int i = 0;
            Iterator i$ = selectionList.iterator();
            while (i$.hasNext()) {
                int s = (Integer)i$.next();
                selection[i++] = s;
            }
            this.list.setSelectedIndices(selection);
            int n = idx = selection.length > 0 ? selection[0] : -1;
            if (idx > -1) {
                this.list.scrollRectToVisible(this.list.getCellBounds(idx, idx));
            }
        }

        @Override
        void setEnabled(boolean b) {
            this.list.setEnabled(this.alwaysDisabled ? false : b);
        }
    }

    static class ComboParameter
    extends QueryParameter {
        private final JComboBox combo;

        public ComboParameter(JComboBox combo, String parameter, String encoding) {
            super(parameter, encoding);
            this.combo = combo;
            combo.setModel(new DefaultComboBoxModel());
        }

        @Override
        public ParameterValue[] getValues() {
            ParameterValue[] parameterValueArray;
            ParameterValue value = (ParameterValue)this.combo.getSelectedItem();
            if (value != null) {
                ParameterValue[] parameterValueArray2 = new ParameterValue[1];
                parameterValueArray = parameterValueArray2;
                parameterValueArray2[0] = value;
            } else {
                parameterValueArray = EMPTY_PARAMETER_VALUE;
            }
            return parameterValueArray;
        }

        public void setParameterValues(ParameterValue[] values) {
            this.combo.setModel(new DefaultComboBoxModel<ParameterValue>(values));
        }

        @Override
        public void setValues(ParameterValue[] values) {
            assert (values.length < 2);
            if (values.length == 0) {
                return;
            }
            ParameterValue pv = values[0];
            int idx = ((DefaultComboBoxModel)this.combo.getModel()).getIndexOf(pv);
            if (idx != -1) {
                this.combo.setSelectedIndex(idx);
            }
        }

        @Override
        void setEnabled(boolean b) {
            this.combo.setEnabled(this.alwaysDisabled ? false : b);
        }
    }
}

