/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.issue;

import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.netbeans.modules.bugtracking.spi.BugtrackingController;
import org.netbeans.modules.bugtracking.util.UIUtils;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.issue.IssuePanel;
import org.openide.util.HelpCtx;

public class IssueController
extends BugtrackingController {
    private JComponent component;
    private IssuePanel issuePanel;

    public IssueController(BugzillaIssue issue) {
        IssuePanel panel = new IssuePanel();
        panel.setIssue(issue);
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.getViewport().setBackground(panel.getBackground());
        scrollPane.setBorder(null);
        Font font = UIManager.getFont("Label.font");
        if (font != null) {
            int size = (int)((double)font.getSize() * 1.5);
            scrollPane.getHorizontalScrollBar().setUnitIncrement(size);
            scrollPane.getVerticalScrollBar().setUnitIncrement(size);
        }
        this.issuePanel = panel;
        UIUtils.keepFocusedComponentVisible((JComponent)this.issuePanel);
        this.component = scrollPane;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void opened() {
        BugzillaIssue issue = this.issuePanel.getIssue();
        if (issue != null) {
            this.issuePanel.opened();
            issue.opened();
        }
    }

    public void closed() {
        BugzillaIssue issue = this.issuePanel.getIssue();
        if (issue != null) {
            issue.closed();
            this.issuePanel.closed();
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(BugzillaIssue.class);
    }

    public boolean isValid() {
        return true;
    }

    public void applyChanges() {
    }

    void refreshViewData(boolean force) {
        this.issuePanel.reloadFormInAWT(force);
    }
}

