/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.issue;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiUtil;
import org.netbeans.modules.bugtracking.spi.IssueFinder;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueSettingsStorage;
import org.netbeans.modules.bugtracking.util.HyperlinkSupport;
import org.netbeans.modules.bugtracking.util.LinkButton;
import org.netbeans.modules.bugtracking.util.SimpleIssueFinder;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.issue.AttachmentHyperlinkSupport;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.kenai.KenaiRepository;
import org.netbeans.modules.bugzilla.repository.IssueField;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CommentsPanel
extends JPanel {
    static final RequestProcessor RP = new RequestProcessor("Bugzilla Comments Panel", 5, false);
    private static final DateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final String REPLY_TO_PROPERTY = "replyTo";
    private static final String QUOTE_PREFIX = "> ";
    private static final int MAX_COMMENT_HEIGHT = 10000;
    private static final Color BLUE_BACKGROUND = new Color(15988477);
    private static final Color GREY_FOREGROUND = new Color(0x999999);
    private final JPopupMenu commentsPopup = new PopupMenu();
    private BugzillaIssue issue;
    private List<BugzillaIssue.Attachment> attachments;
    private List<String> attachmentIds;
    private NewCommentHandler newCommentHandler;
    private Set<Long> collapsedComments = Collections.synchronizedSet(new HashSet());
    private final HyperlinkSupport.Link issueLink;
    private ActionListener replyListener;
    private final JPopupMenu expandPopup = new ExpandPopupMenu();
    private Set<ExpandLabel> expandLabels = new HashSet<ExpandLabel>();
    private Set<Long> touchedCommenst = Collections.synchronizedSet(new HashSet());
    private static final Icon ei;
    private static final Icon ci;
    private static final int ICON_WIDTH;

    public CommentsPanel() {
        this.setBackground(UIManager.getColor("TextArea.background"));
        this.issueLink = new HyperlinkSupport.Link(){

            public void onClick(String linkText) {
                final String issueKey = SimpleIssueFinder.getInstance().getIssueId(linkText);
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        BugzillaIssue is = CommentsPanel.this.issue.getRepository().getIssue(issueKey);
                        if (is != null) {
                            BugzillaUtil.openIssue(is);
                        }
                    }
                });
            }
        };
    }

    void setIssue(BugzillaIssue issue, List<BugzillaIssue.Attachment> attachments) {
        this.removeAll();
        this.issue = issue;
        this.initCollapsedComments();
        this.attachments = attachments;
        this.attachmentIds = CommentsPanel.getAttachmentIds(attachments);
        GroupLayout layout = new GroupLayout(this);
        GroupLayout.ParallelGroup horizontalGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        layout.setHorizontalGroup(layout.createSequentialGroup().addContainerGap().addGroup(horizontalGroup).addContainerGap());
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup();
        verticalGroup.addContainerGap();
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(verticalGroup));
        DateFormat format = DateFormat.getDateTimeInstance(2, 3);
        String creationTxt = issue.getFieldValue(IssueField.CREATION);
        try {
            Date creation = dateTimeFormat.parse(creationTxt);
            creationTxt = format.format(creation);
        }
        catch (ParseException pex) {
            Bugzilla.LOG.log(Level.INFO, null, pex);
        }
        this.addSection(layout, new Long(0L), issue.getFieldValue(IssueField.DESCRIPTION), issue.getFieldValue(IssueField.REPORTER), issue.getFieldValue(IssueField.REPORTER_NAME), creationTxt, horizontalGroup, verticalGroup, true);
        for (BugzillaIssue.Comment comment : issue.getComments()) {
            String when = format.format(comment.getWhen());
            this.addSection(layout, comment.getNumber(), comment.getText(), comment.getAuthor(), comment.getAuthorName(), when, horizontalGroup, verticalGroup, false);
        }
        verticalGroup.addContainerGap();
        this.setLayout(layout);
    }

    private static List<String> getAttachmentIds(List<BugzillaIssue.Attachment> attachments) {
        if (attachments.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(attachments.size());
        for (BugzillaIssue.Attachment attachment : attachments) {
            result.add(attachment.getId());
        }
        return result;
    }

    public void setNewCommentHandler(NewCommentHandler handler) {
        this.newCommentHandler = handler;
    }

    private void addSection(GroupLayout layout, Long number, String text, String author, String authorName, String dateTimeString, GroupLayout.ParallelGroup horizontalGroup, GroupLayout.SequentialGroup verticalGroup, boolean description) {
        String authorTxt;
        JTextPane textPane = new JTextPane();
        this.setupTextPane(textPane, text);
        JPanel headerPanel = new JPanel();
        JPanel placeholder = this.createTextPanelPlaceholder();
        JLabel commentLabel = new JLabel();
        JLabel rightLabel = new JLabel();
        ExpandLabel iconLabel = new ExpandLabel(placeholder, textPane, headerPanel, commentLabel, number);
        JLabel leftLabel = new JLabel();
        headerPanel.addMouseListener(iconLabel);
        headerPanel.setComponentPopupMenu(this.expandPopup);
        ResourceBundle bundle = NbBundle.getBundle(CommentsPanel.class);
        String leftTxt = "";
        String string = authorTxt = authorName != null && authorName.trim().length() > 0 ? authorName : author;
        if (description) {
            String leftFormat = bundle.getString("CommentsPanel.leftLabel.format");
            leftTxt = MessageFormat.format(leftFormat, authorTxt);
        } else {
            leftTxt = authorTxt;
        }
        leftLabel.setText(leftTxt);
        leftLabel.setLabelFor(textPane);
        leftLabel.setForeground(GREY_FOREGROUND);
        leftLabel.setOpaque(false);
        leftLabel.addMouseListener(iconLabel);
        leftLabel.setComponentPopupMenu(this.expandPopup);
        commentLabel.setOpaque(false);
        commentLabel.addMouseListener(iconLabel);
        commentLabel.setComponentPopupMenu(this.expandPopup);
        rightLabel.setText(dateTimeString);
        rightLabel.setForeground(GREY_FOREGROUND);
        rightLabel.setOpaque(false);
        rightLabel.addMouseListener(iconLabel);
        rightLabel.setComponentPopupMenu(this.expandPopup);
        JLabel stateLabel = null;
        if (this.issue.getRepository() instanceof KenaiRepository) {
            int index = author.indexOf(64);
            String userName = index == -1 ? author : author.substring(0, index);
            String host = ((KenaiRepository)this.issue.getRepository()).getHost();
            stateLabel = KenaiUtil.createUserWidget((String)this.issue.getRepository().getUrl(), (String)userName, (String)host, (String)KenaiUtil.getChatLink((String)this.issue.getID()));
            if (stateLabel != null) {
                stateLabel.setText(null);
            }
        }
        LinkButton replyButton = new LinkButton(bundle.getString("Comments.replyButton.text"));
        replyButton.addActionListener(this.getReplyListener());
        replyButton.putClientProperty((Object)REPLY_TO_PROPERTY, (Object)textPane);
        replyButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommentsPanel.class, (String)"CommentsPanel.replyButton.AccessibleContext.accessibleDescription"));
        replyButton.setOpaque(false);
        LinkButton.MailtoButton mailtoButton = null;
        if (author.indexOf("@") > -1) {
            mailtoButton = new LinkButton.MailtoButton(NbBundle.getMessage(CommentsPanel.class, (String)"CommentsPanel.mailtoButton.text"), NbBundle.getMessage(CommentsPanel.class, (String)"CommentsPanel.mailtoButton.AccessibleContext.accessibleDescription"), author);
            replyButton.setOpaque(false);
        }
        JComponent pane = textPane;
        if (textPane.getPreferredSize().height > Short.MAX_VALUE) {
            pane = new JScrollPane(textPane);
            Dimension dim = new Dimension(textPane.getPreferredSize());
            dim.height = 10000;
            pane.setPreferredSize(dim);
        }
        this.layoutHeaderPanel(headerPanel, iconLabel, leftLabel, commentLabel, rightLabel, replyButton, (LinkButton)mailtoButton, stateLabel);
        iconLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        placeholder.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        leftLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        commentLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        rightLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        horizontalGroup.addComponent(headerPanel).addGroup(layout.createSequentialGroup().addComponent(placeholder, -2, -1, -2).addGap(0, 0, 0).addComponent(pane));
        if (!description) {
            verticalGroup.addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED);
        }
        verticalGroup.addComponent(headerPanel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(placeholder).addComponent(pane, -1, -1, Short.MAX_VALUE));
    }

    private void setupTextPane(JTextPane textPane, String comment) {
        String attachmentId;
        AttachmentHyperlinkSupport.Attachement a;
        textPane.setText(comment);
        HyperlinkSupport.getInstance().registerForTypes(textPane);
        HyperlinkSupport.getInstance().registerForStacktraces(textPane);
        HyperlinkSupport.getInstance().registerForURLs(textPane);
        HyperlinkSupport.getInstance().registerForIssueLinks(textPane, this.issueLink, (IssueFinder)SimpleIssueFinder.getInstance());
        Caret caret = textPane.getCaret();
        if (caret instanceof DefaultCaret) {
            ((DefaultCaret)caret).setUpdatePolicy(1);
        }
        if (!this.attachmentIds.isEmpty() && (a = AttachmentHyperlinkSupport.findAttachment(comment, this.attachmentIds)) != null && (attachmentId = a.id) != null) {
            int index = this.attachmentIds.indexOf(attachmentId);
            if (index != -1) {
                BugzillaIssue.Attachment attachment = this.attachments.get(index);
                AttachmentLink attachmentLink = new AttachmentLink(attachment);
                HyperlinkSupport.getInstance().registerLink(textPane, new int[]{a.idx1, a.idx2}, (HyperlinkSupport.Link)attachmentLink);
            } else {
                Bugzilla.LOG.log(Level.WARNING, "couldn''t find attachment id in: {0}", comment);
            }
        }
        textPane.setComponentPopupMenu(this.commentsPopup);
        textPane.setBackground(BLUE_BACKGROUND);
        textPane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        textPane.setEditable(false);
        textPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommentsPanel.class, (String)"CommentsPanel.textPane.AccessibleContext.accessibleName"));
        textPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommentsPanel.class, (String)"CommentsPanel.textPane.AccessibleContext.accessibleDescription"));
    }

    private void layoutHeaderPanel(JPanel headerPanel, JLabel iconLabel, JLabel leftLabel, JLabel commentLabel, JLabel rightLabel, LinkButton replyButton, LinkButton mailtoButton, JLabel stateLabel) {
        GroupLayout layout = new GroupLayout(headerPanel);
        headerPanel.setLayout(layout);
        GroupLayout.SequentialGroup hGroup = layout.createSequentialGroup().addComponent(iconLabel).addComponent(leftLabel);
        if (stateLabel != null) {
            hGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(stateLabel);
        }
        hGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(commentLabel, 0, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(rightLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)replyButton);
        if (mailtoButton != null) {
            hGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)mailtoButton);
        }
        layout.setHorizontalGroup(hGroup);
        GroupLayout.ParallelGroup vGroup = layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(iconLabel).addComponent(leftLabel);
        if (stateLabel != null) {
            vGroup.addComponent(stateLabel);
        }
        vGroup.addComponent(commentLabel).addComponent(rightLabel).addComponent((Component)replyButton);
        if (mailtoButton != null) {
            vGroup.addComponent((Component)mailtoButton);
        }
        layout.setVerticalGroup(vGroup);
    }

    private ActionListener getReplyListener() {
        if (this.replyListener == null) {
            this.replyListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JComponent comp;
                    Object value;
                    Object source = e.getSource();
                    if (source instanceof JComponent && (value = (comp = (JComponent)source).getClientProperty(CommentsPanel.REPLY_TO_PROPERTY)) instanceof JTextPane) {
                        JTextPane pane = (JTextPane)value;
                        String text = pane.getText();
                        StringBuilder sb = new StringBuilder();
                        StringTokenizer tokenizer = new StringTokenizer(text, "\n");
                        while (tokenizer.hasMoreElements()) {
                            String line = tokenizer.nextToken();
                            sb.append(CommentsPanel.QUOTE_PREFIX).append(line).append('\n');
                        }
                        CommentsPanel.this.newCommentHandler.append(sb.toString());
                    }
                }
            };
        }
        return this.replyListener;
    }

    private JPanel createTextPanelPlaceholder() {
        JPanel placeholder = new JPanel();
        placeholder.setBackground(BLUE_BACKGROUND);
        GroupLayout layout = new GroupLayout(placeholder);
        placeholder.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, ICON_WIDTH, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        return placeholder;
    }

    private void commentCollapsed(Long number) {
        this.collapsedComments.add(number);
    }

    private void commentExpanded(Long number) {
        if (this.collapsedComments.remove(number)) {
            this.touchedCommenst.add(number);
        }
    }

    private boolean isCollapsed(Long number) {
        return this.collapsedComments.contains(number);
    }

    private void initCollapsedComments() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                Collection s = IssueSettingsStorage.getInstance().loadCollapsedCommenst(CommentsPanel.this.issue.getRepository().getUrl(), CommentsPanel.this.issue.getID());
                for (Long l : s) {
                    if (CommentsPanel.this.touchedCommenst.contains(l)) continue;
                    CommentsPanel.this.collapsedComments.add(l);
                }
            }
        });
    }

    void storeSettings() {
        if (this.issue != null) {
            IssueSettingsStorage.getInstance().storeCollapsedComments(this.collapsedComments, this.issue.getRepository().getUrl(), this.issue.getID());
        }
    }

    static {
        JTree tv = new JTree();
        BasicTreeUI tvui = (BasicTreeUI)tv.getUI();
        ei = tvui.getExpandedIcon();
        ci = tvui.getCollapsedIcon();
        ICON_WIDTH = ei != null ? ei.getIconWidth() : 16;
    }

    private class AttachmentLink
    implements HyperlinkSupport.Link {
        private BugzillaIssue.Attachment attachment;

        public AttachmentLink(BugzillaIssue.Attachment attachment) {
            this.attachment = attachment;
        }

        public void onClick(String linkText) {
            this.attachment.open();
        }
    }

    private class ExpandLabel
    extends JLabel
    implements MouseListener {
        private final JTextPane textPane;
        private final JPanel headerPanel;
        private final JPanel placeholderPanel;
        private final JLabel commentLabel;
        private final Long number;

        public ExpandLabel(JPanel placeholderPanel, JTextPane textPane, JPanel headerPanel, JLabel commentLabel, Long number) {
            this.textPane = textPane;
            this.headerPanel = headerPanel;
            this.placeholderPanel = placeholderPanel;
            this.commentLabel = commentLabel;
            this.number = number;
            this.addMouseListener(this);
            this.setComponentPopupMenu(CommentsPanel.this.expandPopup);
            this.setState(CommentsPanel.this.isCollapsed(number));
            CommentsPanel.this.expandLabels.add(this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                this.setState(!CommentsPanel.this.isCollapsed(this.number));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private void setState(boolean collapsed) {
            if (collapsed) {
                this.textPane.setVisible(false);
                this.placeholderPanel.setVisible(false);
                this.commentLabel.setText(this.textPane.getText().replace("\n", " ").replace("\t", " "));
                this.setIcon(ci);
                this.headerPanel.setBackground(BLUE_BACKGROUND);
                CommentsPanel.this.commentCollapsed(this.number);
            } else {
                this.textPane.setVisible(true);
                this.placeholderPanel.setVisible(true);
                this.commentLabel.setText("");
                this.setIcon(ei);
                this.headerPanel.setBackground(Color.white);
                CommentsPanel.this.commentExpanded(this.number);
            }
        }
    }

    private class ExpandPopupMenu
    extends JPopupMenu {
        public ExpandPopupMenu() {
            this.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(CommentsPanel.class, (String)"LBL_ExpandAll")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (ExpandLabel l : CommentsPanel.this.expandLabels) {
                        l.setState(false);
                    }
                }
            }));
            this.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(CommentsPanel.class, (String)"LBL_CollapseAll")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (ExpandLabel l : CommentsPanel.this.expandLabels) {
                        l.setState(true);
                    }
                }
            }));
        }
    }

    public static interface NewCommentHandler {
        public void append(String var1);
    }

    class PopupMenu
    extends JPopupMenu {
        private final Point clickPoint = new Point();

        PopupMenu() {
        }

        @Override
        public void show(Component invoker, int x, int y) {
            this.clickPoint.setLocation(x, y);
            super.show(invoker, x, y);
        }

        @Override
        public void setVisible(boolean b) {
            if (b) {
                BugzillaIssue.Attachment attachment;
                JTextPane pane = (JTextPane)this.getInvoker();
                StyledDocument doc = pane.getStyledDocument();
                Element elem = doc.getCharacterElement(pane.viewToModel(this.clickPoint));
                Object l = elem.getAttributes().getAttribute("attribute.simple.link");
                if (l != null && l instanceof AttachmentLink && (attachment = ((AttachmentLink)l).attachment) != null) {
                    this.add(new JMenuItem(attachment.new BugzillaIssue.Attachment.DefaultAttachmentAction()));
                    this.add(new JMenuItem(attachment.new BugzillaIssue.Attachment.SaveAttachmentAction()));
                    if ("1".equals(attachment.getIsPatch())) {
                        this.add(attachment.new BugzillaIssue.Attachment.ApplyPatchAction());
                    }
                    super.setVisible(true);
                }
            } else {
                super.setVisible(false);
                this.removeAll();
            }
        }
    }
}

