/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.issue;

import java.util.List;
import org.netbeans.modules.bugtracking.issuetable.IssueNode;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.repository.BugzillaConfiguration;
import org.netbeans.modules.bugzilla.repository.IssueField;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class BugzillaIssueNode
extends IssueNode<BugzillaIssue> {
    public BugzillaIssueNode(BugzillaIssue issue) {
        super(BugzillaUtil.getRepository(issue.getRepository()), (Object)issue);
    }

    BugzillaIssue getBugzillaIssue() {
        return (BugzillaIssue)this.getIssueData();
    }

    protected Node.Property<?>[] getProperties() {
        return new Node.Property[]{new IDProperty(), BugzillaUtil.isNbRepository(this.getBugzillaIssue().getRepository()) ? new IssueTypeProperty() : new SeverityProperty(), new PriorityProperty(), new BugzillaFieldProperty("bugzilla.issue.status", IssueField.STATUS, "CTL_Issue_Status_Title", "CTL_Issue_Status_Desc"), new BugzillaFieldProperty("bugzilla.issue.assigned", IssueField.ASSIGNED_TO, "CTL_Issue_Assigned_Title", "CTL_Issue_Status_Desc"), new ResolutionProperty(), new IssueNode.SummaryProperty((IssueNode)this), new ModificationProperty(), new BugzillaFieldProperty("bugzilla.issue.product", IssueField.PRODUCT, "CTL_Issue_Product_Title", "CTL_Issue_Product_Desc"), new BugzillaFieldProperty("bugzilla.issue.component", IssueField.COMPONENT, "CTL_Issue_Component_Title", "CTL_Issue_Component_Desc"), new BugzillaFieldProperty("bugzilla.issue.version", IssueField.VERSION, "CTL_Issue_Version_Title", "CTL_Issue_Version_Desc"), new BugzillaFieldProperty("bugzilla.issue.os", IssueField.OS, "CTL_Issue_OS_Title", "CTL_Issue_OS_Desc"), new BugzillaFieldProperty("bugzilla.issue.platform", IssueField.PLATFORM, "CTL_Issue_Platform_Title", "CTL_Issue_Platform_Desc"), new BugzillaFieldProperty("bugzilla.issue.milestone", IssueField.MILESTONE, "CTL_Issue_Milestone_Title", "CTL_Issue_Milestone_Desc"), new BugzillaFieldProperty("bugzilla.issue.reporter", IssueField.REPORTER_NAME, "CTL_Issue_Reporter_Title", "CTL_Issue_Reporter_Desc"), new BugzillaFieldProperty("bugzilla.issue.qa_contact", IssueField.QA_CONTACT_NAME, "CTL_Issue_QA_Contact_Title", "CTL_Issue_QA_Contact_Desc"), new BugzillaFieldProperty("bugzilla.issue.keywords", IssueField.KEYWORDS, "CTL_Issue_Keywords_Title", "CTL_Issue_Keywords_Desc"), new BugzillaFieldProperty("bugzilla.issue.whiteboard", IssueField.WHITEBOARD, "CTL_Issue_Whiteboard_Title", "CTL_Issue_Whiteboard_Desc")};
    }

    public void fireDataChanged() {
        super.fireDataChanged();
    }

    private Integer getIssueTypeSortKey(String issueType) {
        BugzillaConfiguration bc = this.getBugzillaIssue().getRepository().getConfiguration();
        if (bc == null || !bc.isValid()) {
            return null;
        }
        List<String> s = bc.getIssueTypes();
        if (s == null) {
            return null;
        }
        return s.indexOf(issueType);
    }

    private Integer getSeveritySortKey(String severity) {
        BugzillaConfiguration bc = this.getBugzillaIssue().getRepository().getConfiguration();
        if (bc == null || !bc.isValid()) {
            return null;
        }
        List<String> s = bc.getSeverities();
        if (s == null) {
            return null;
        }
        return s.indexOf(severity);
    }

    private Integer getPrioritySortKey(String priority) {
        BugzillaConfiguration bc = this.getBugzillaIssue().getRepository().getConfiguration();
        if (bc == null || !bc.isValid()) {
            return null;
        }
        List<String> p = bc.getPriorities();
        if (p == null) {
            return null;
        }
        return p.indexOf(priority);
    }

    private Integer getResolutionSortKey(String resolution) {
        BugzillaConfiguration bc = this.getBugzillaIssue().getRepository().getConfiguration();
        if (bc == null || !bc.isValid()) {
            return null;
        }
        List<String> r = bc.getResolutions();
        if (r == null) {
            return null;
        }
        return r.indexOf(resolution);
    }

    private class BugzillaFieldProperty
    extends IssueNode.IssueProperty<String> {
        private final IssueField field;

        public BugzillaFieldProperty(String fieldLabel, IssueField f, String titleProp, String descProp) {
            super((IssueNode)BugzillaIssueNode.this, fieldLabel, String.class, NbBundle.getMessage(BugzillaIssue.class, (String)titleProp), NbBundle.getMessage(BugzillaIssue.class, (String)descProp));
            this.field = f;
        }

        public String getValue() {
            return BugzillaIssueNode.this.getBugzillaIssue().getFieldValue(this.field);
        }

        public int compareTo(IssueNode.IssueProperty<String> p) {
            if (p == null) {
                return 1;
            }
            String s1 = BugzillaIssueNode.this.getBugzillaIssue().getFieldValue(this.field);
            String s2 = ((BugzillaIssue)p.getIssueData()).getFieldValue(this.field);
            return s1.compareTo(s2);
        }
    }

    private class ModificationProperty
    extends IssueNode.IssueProperty<String> {
        public ModificationProperty() {
            super((IssueNode)BugzillaIssueNode.this, "bugzilla.issue.modified", String.class, NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_Modification_Title"), NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_Modification_Desc"));
        }

        public String getValue() {
            return BugzillaIssueNode.this.getBugzillaIssue().getFieldValue(IssueField.MODIFICATION);
        }

        public int compareTo(IssueNode.IssueProperty<String> p) {
            if (p == null) {
                return 1;
            }
            String s1 = BugzillaIssueNode.this.getBugzillaIssue().getFieldValue(IssueField.MODIFICATION);
            String s2 = ((BugzillaIssue)p.getIssueData()).getFieldValue(IssueField.MODIFICATION);
            return s1.compareTo(s2);
        }
    }

    private class ResolutionProperty
    extends IssueNode.IssueProperty<String> {
        public ResolutionProperty() {
            super((IssueNode)BugzillaIssueNode.this, "bugzilla.issue.resolution", String.class, NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_Resolution_Title"), NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_ID_Desc"));
        }

        public String getValue() {
            return BugzillaIssueNode.this.getBugzillaIssue().getFieldValue(IssueField.RESOLUTION);
        }

        public Object getValue(String attributeName) {
            if ("sortkey".equals(attributeName)) {
                return BugzillaIssueNode.this.getResolutionSortKey(BugzillaIssueNode.this.getBugzillaIssue().getFieldValue(IssueField.RESOLUTION));
            }
            return super.getValue(attributeName);
        }
    }

    public class PriorityProperty
    extends IssueNode.IssueProperty<String> {
        public PriorityProperty() {
            super((IssueNode)BugzillaIssueNode.this, "bugzilla.issue.priority", String.class, NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_Priority_Title"), NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_Priority_Desc"));
        }

        public String getValue() {
            return BugzillaIssueNode.this.getBugzillaIssue().getFieldValue(IssueField.PRIORITY);
        }

        public Object getValue(String attributeName) {
            if ("sortkey".equals(attributeName)) {
                return BugzillaIssueNode.this.getPrioritySortKey(BugzillaIssueNode.this.getBugzillaIssue().getFieldValue(IssueField.PRIORITY));
            }
            return super.getValue(attributeName);
        }
    }

    private class IssueTypeProperty
    extends IssueNode.IssueProperty<String> {
        public IssueTypeProperty() {
            super((IssueNode)BugzillaIssueNode.this, "bugzilla.issue.issue_type", String.class, NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_Issue_Type_Title"), NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_Issue_Type_Desc"));
        }

        public String getValue() {
            return BugzillaIssueNode.this.getBugzillaIssue().getFieldValue(IssueField.ISSUE_TYPE);
        }

        public Object getValue(String attributeName) {
            if ("sortkey".equals(attributeName)) {
                return BugzillaIssueNode.this.getIssueTypeSortKey(BugzillaIssueNode.this.getBugzillaIssue().getFieldValue(IssueField.ISSUE_TYPE));
            }
            return super.getValue(attributeName);
        }
    }

    private class SeverityProperty
    extends IssueNode.IssueProperty<String> {
        public SeverityProperty() {
            super((IssueNode)BugzillaIssueNode.this, "bugzilla.issue.severity", String.class, NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_Severity_Title"), NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_Severity_Desc"));
        }

        public String getValue() {
            return BugzillaIssueNode.this.getBugzillaIssue().getFieldValue(IssueField.SEVERITY);
        }

        public Object getValue(String attributeName) {
            if ("sortkey".equals(attributeName)) {
                return BugzillaIssueNode.this.getSeveritySortKey(BugzillaIssueNode.this.getBugzillaIssue().getFieldValue(IssueField.SEVERITY));
            }
            return super.getValue(attributeName);
        }
    }

    private class IDProperty
    extends IssueNode.IssueProperty<String> {
        public IDProperty() {
            super((IssueNode)BugzillaIssueNode.this, "bugzilla.issue.id", String.class, NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_ID_Title"), NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_ID_Desc"));
        }

        public String getValue() {
            return BugzillaIssueNode.this.getBugzillaIssue().getID();
        }

        public int compareTo(IssueNode.IssueProperty p) {
            if (p == null) {
                return 1;
            }
            Integer i1 = Integer.parseInt(this.getIssue().getID());
            Integer i2 = Integer.parseInt(p.getIssue().getID());
            return i1.compareTo(i2);
        }
    }
}

