/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.commands;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.logging.Level;
import org.apache.commons.httpclient.RedirectException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaStatus;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaUserMatchResponse;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.autoupdate.BugzillaAutoupdate;
import org.netbeans.modules.bugzilla.commands.HtmlPanel;
import org.netbeans.modules.bugzilla.repository.BugzillaConfiguration;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.netbeans.modules.mylyn.util.BugtrackingCommand;
import org.netbeans.modules.mylyn.util.PerformQueryCommand;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class BugzillaExecutor {
    private static final String HTTP_ERROR_NOT_FOUND = "http error: not found";
    private static final String EMPTY_PASSWORD = "Empty password not allowed to login";
    private static final String INVALID_USERNAME_OR_PASSWORD = "invalid username or password";
    private static final String REPOSITORY_LOGIN_FAILURE = "unable to login to";
    private static final String KENAI_LOGIN_REDIRECT = "/people/login?original_uri=";
    private static final String COULD_NOT_BE_FOUND = "could not be found";
    private static final String REPOSITORY = "repository";
    private static final String MIDAIR_COLLISION = "mid-air collision occurred while submitting to";
    private final BugzillaRepository repository;

    public BugzillaExecutor(BugzillaRepository repository) {
        this.repository = repository;
    }

    public void execute(BugtrackingCommand cmd) {
        this.execute(cmd, true);
    }

    public void execute(BugtrackingCommand cmd, boolean handleExceptions) {
        this.execute(cmd, handleExceptions, true);
    }

    public void execute(BugtrackingCommand cmd, boolean handleExceptions, boolean checkVersion) {
        this.execute(cmd, handleExceptions, checkVersion, true, true);
    }

    public void execute(BugtrackingCommand cmd, boolean handleExceptions, boolean checkVersion, boolean ensureCredentials) {
        this.execute(cmd, handleExceptions, checkVersion, ensureCredentials, true);
    }

    public void execute(BugtrackingCommand cmd, boolean handleExceptions, boolean checkVersion, boolean ensureCredentials, boolean reexecute) {
        try {
            PerformQueryCommand pqc;
            cmd.setFailed(true);
            if (checkVersion) {
                this.checkAutoupdate();
            }
            if (ensureCredentials) {
                this.repository.ensureCredentials();
            }
            Bugzilla.LOG.log(Level.FINE, "execute {0}", cmd);
            cmd.execute();
            if (cmd instanceof PerformQueryCommand && this.handleStatus(pqc = (PerformQueryCommand)cmd, handleExceptions)) {
                return;
            }
            cmd.setFailed(false);
            cmd.setErrorMessage(null);
        }
        catch (CoreException ce) {
            Bugzilla.LOG.log(Level.FINE, null, ce);
            ExceptionHandler handler = ExceptionHandler.createHandler(ce, this, this.repository, reexecute);
            assert (handler != null);
            String msg = handler.getMessage();
            cmd.setFailed(true);
            cmd.setErrorMessage(msg);
            if (handleExceptions && handler.handle()) {
                this.execute(cmd, handleExceptions, checkVersion, ensureCredentials, !handler.reexecuteOnce());
            }
            return;
        }
        catch (MalformedURLException me) {
            cmd.setErrorMessage(me.getMessage());
            Bugzilla.LOG.log(Level.SEVERE, null, me);
        }
        catch (IOException ioe) {
            cmd.setErrorMessage(ioe.getMessage());
            if (!handleExceptions) {
                Bugzilla.LOG.log(Level.FINE, null, ioe);
                return;
            }
            this.handleIOException(ioe);
        }
        catch (RuntimeException re) {
            Throwable t = re.getCause();
            if (t instanceof InterruptedException || !handleExceptions) {
                Bugzilla.LOG.log(Level.FINE, null, t);
            }
            Bugzilla.LOG.log(Level.SEVERE, null, re);
        }
    }

    private boolean handleStatus(PerformQueryCommand cmd, boolean handleExceptions) throws CoreException {
        BugzillaVersion version;
        IStatus status = cmd.getStatus();
        if (status == null || status.isOK()) {
            return false;
        }
        Bugzilla.LOG.log(Level.FINE, "command {0} returned status : {1}", new Object[]{cmd, status.getMessage()});
        if (status.getException() instanceof CoreException) {
            throw (CoreException)status.getException();
        }
        boolean isHtml = false;
        String errMsg = null;
        if (status instanceof RepositoryStatus) {
            RepositoryStatus rstatus = (RepositoryStatus)status;
            errMsg = rstatus.getHtmlMessage();
            boolean bl = isHtml = errMsg != null;
        }
        if (errMsg == null) {
            errMsg = status.getMessage();
        }
        cmd.setErrorMessage(errMsg);
        cmd.setFailed(true);
        if (!handleExceptions) {
            return true;
        }
        BugzillaConfiguration conf = this.repository.getConfiguration();
        if (conf.isValid() && (version = conf.getInstalledVersion()).compareMajorMinorOnly(BugzillaAutoupdate.SUPPORTED_BUGZILLA_VERSION) > 0) {
            boolean ua = BugzillaAutoupdate.getInstance().isUpdateAvailable(this.repository);
            BugzillaExecutor.notifyErrorMessage(NbBundle.getMessage(BugzillaExecutor.class, (String)"MSG_BUGZILLA_ERROR_WARNING", (Object)status.getMessage()) + "\n\n" + NbBundle.getMessage(BugzillaExecutor.class, (String)"MSG_BUGZILLA_VERSION_WARNING1", (Object)version) + "\n" + NbBundle.getMessage(BugzillaExecutor.class, (String)"MSG_BUGZILLA_VERSION_WARNING2"));
            return true;
        }
        if (isHtml) {
            BugzillaExecutor.notifyHtmlMessage(errMsg, this.repository, true);
        } else {
            BugzillaExecutor.notifyErrorMessage(NbBundle.getMessage(BugzillaExecutor.class, (String)"MSG_BUGZILLA_ERROR_WARNING", (Object)errMsg));
        }
        return true;
    }

    static void notifyErrorMessage(String msg) {
        if ("true".equals(System.getProperty("netbeans.t9y.throwOnClientError", "false"))) {
            Bugzilla.LOG.info(msg);
            throw new AssertionError((Object)msg);
        }
        NotifyDescriptor nd = new NotifyDescriptor((Object)msg, NbBundle.getMessage(BugzillaExecutor.class, (String)"LBLError"), -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notify(nd);
    }

    private static boolean notifyHtmlMessage(String html, BugzillaRepository repository, boolean htmlTextIsAllYouGot) throws MissingResourceException {
        if (html != null && !html.trim().equals("")) {
            if ((html = BugzillaExecutor.parseHtmlMessage(html, htmlTextIsAllYouGot)) == null) {
                return false;
            }
            HtmlPanel p = new HtmlPanel();
            String label = NbBundle.getMessage(BugzillaExecutor.class, (String)"MSG_ServerResponse", (Object[])new Object[]{repository.getDisplayName()});
            p.setHtml(repository.getUrl(), html, label);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)p, NbBundle.getMessage(BugzillaExecutor.class, (String)"CTL_ServerResponse"), true, new Object[]{NotifyDescriptor.CANCEL_OPTION}, NotifyDescriptor.CANCEL_OPTION, 0, new HelpCtx(p.getClass()), null);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            return true;
        }
        return false;
    }

    private static String parseHtmlMessage(String html, boolean htmlTextIsAllYouGot) {
        int idxS = html.indexOf("<div id=\"bugzilla-body\">");
        if (idxS < 0) {
            return html;
        }
        int idx = idxS;
        int idxE = html.indexOf("</div>", idx);
        if (!htmlTextIsAllYouGot && idxE < 0) {
            return null;
        }
        int levels = 1;
        while ((idx = html.indexOf("<div", idx + 1)) >= 0 && idx <= idxE) {
            ++levels;
        }
        idxE = idxS;
        for (int i = 0; i < levels; ++i) {
            idxE = html.indexOf("</div>", idxE + 1);
        }
        idxE = idxE > 6 ? idxE + 6 : html.length();
        html = html.substring(idxS, idxE);
        html = html.replaceAll("Please press \\<b\\>Back\\</b\\> and try again.", "");
        return html;
    }

    public boolean handleIOException(IOException io) {
        Bugzilla.LOG.log(Level.SEVERE, null, io);
        return true;
    }

    private void checkAutoupdate() {
        try {
            BugzillaAutoupdate.getInstance().checkAndNotify(this.repository);
        }
        catch (Throwable t) {
            Bugzilla.LOG.log(Level.SEVERE, "Exception in Bugzilla autoupdate check.", t);
        }
    }

    private static abstract class ExceptionHandler {
        protected String errroMsg;
        protected CoreException ce;
        protected BugzillaExecutor executor;
        protected BugzillaRepository repository;

        protected ExceptionHandler(CoreException ce, String msg, BugzillaExecutor executor, BugzillaRepository repository) {
            this.errroMsg = msg;
            this.ce = ce;
            this.executor = executor;
            this.repository = repository;
        }

        static ExceptionHandler createHandler(CoreException ce, BugzillaExecutor executor, BugzillaRepository repository, boolean forRexecute) {
            String errormsg = ExceptionHandler.getLoginError(ce);
            if (errormsg != null) {
                return new LoginHandler(ce, errormsg, executor, repository);
            }
            errormsg = ExceptionHandler.getKenaiRedirectError(ce);
            if (errormsg != null) {
                return new LoginHandler(ce, errormsg, executor, repository);
            }
            errormsg = ExceptionHandler.getNotFoundError(ce);
            if (errormsg != null) {
                return new NotFoundHandler(ce, errormsg, executor, repository);
            }
            errormsg = ExceptionHandler.getMidAirColisionError(ce);
            if (errormsg != null) {
                if (forRexecute) {
                    return new MidAirHandler(ce, errormsg, executor, repository);
                }
                errormsg = MessageFormat.format(errormsg, repository.getDisplayName());
                return new DefaultHandler(ce, errormsg, executor, repository);
            }
            return new DefaultHandler(ce, null, executor, repository);
        }

        abstract boolean handle();

        boolean reexecuteOnce() {
            return false;
        }

        private static String getLoginError(CoreException ce) {
            String msg = ExceptionHandler.getMessage(ce);
            if (msg != null) {
                if (BugzillaExecutor.INVALID_USERNAME_OR_PASSWORD.equals(msg = msg.trim().toLowerCase()) || msg.contains(BugzillaExecutor.INVALID_USERNAME_OR_PASSWORD) || msg.contains(BugzillaExecutor.EMPTY_PASSWORD)) {
                    Bugzilla.LOG.log(Level.FINER, "returned error message [{0}]", msg);
                    return NbBundle.getMessage(BugzillaExecutor.class, (String)"MSG_INVALID_USERNAME_OR_PASSWORD");
                }
                if (msg.startsWith(BugzillaExecutor.REPOSITORY_LOGIN_FAILURE) || msg.startsWith(BugzillaExecutor.REPOSITORY) && msg.endsWith(BugzillaExecutor.COULD_NOT_BE_FOUND)) {
                    Bugzilla.LOG.log(Level.FINER, "returned error message [{0}]", msg);
                    return NbBundle.getMessage(BugzillaExecutor.class, (String)"MSG_UNABLE_LOGIN_TO_REPOSITORY");
                }
            }
            return null;
        }

        private static String getKenaiRedirectError(CoreException ce) {
            String msg;
            IStatus status = ce.getStatus();
            if (status == null) {
                return null;
            }
            Throwable cause = status.getException();
            if (cause != null && cause instanceof RedirectException && (msg = cause.getMessage()).contains(BugzillaExecutor.KENAI_LOGIN_REDIRECT)) {
                Bugzilla.LOG.log(Level.FINER, "returned error message [{0}]", msg);
                return NbBundle.getMessage(BugzillaExecutor.class, (String)"MSG_INVALID_USERNAME_OR_PASSWORD");
            }
            return null;
        }

        private static String getMidAirColisionError(CoreException ce) {
            String msg = ExceptionHandler.getMessage(ce);
            if (msg != null && (msg = msg.trim().toLowerCase()).startsWith(BugzillaExecutor.MIDAIR_COLLISION)) {
                Bugzilla.LOG.log(Level.FINER, "returned error message [{0}]", msg);
                return NbBundle.getMessage(BugzillaExecutor.class, (String)"MSG_MID-AIR_COLLISION");
            }
            return null;
        }

        private static String getNotFoundError(CoreException ce) {
            IStatus status = ce.getStatus();
            Throwable t = status.getException();
            if (t instanceof UnknownHostException) {
                Bugzilla.LOG.log(Level.FINER, null, t);
                return NbBundle.getMessage(BugzillaExecutor.class, (String)"MSG_HOST_NOT_FOUND");
            }
            String msg = ExceptionHandler.getMessage(ce);
            if (msg != null && BugzillaExecutor.HTTP_ERROR_NOT_FOUND.equals(msg = msg.trim().toLowerCase())) {
                Bugzilla.LOG.log(Level.FINER, "returned error message [{0}]", msg);
                return NbBundle.getMessage(BugzillaExecutor.class, (String)"MSG_HOST_NOT_FOUND");
            }
            return null;
        }

        static String getMessage(CoreException ce) {
            String msg = ce.getMessage();
            if (msg != null && !msg.trim().equals("")) {
                return msg;
            }
            IStatus status = ce.getStatus();
            msg = status != null ? status.getMessage() : null;
            return msg != null ? msg.trim() : null;
        }

        String getMessage() {
            return this.errroMsg;
        }

        private static void notifyError(CoreException ce, BugzillaRepository repository) {
            RepositoryStatus rs;
            String html;
            BugzillaStatus bs;
            BugzillaUserMatchResponse res;
            String msg = ExceptionHandler.getMessage(ce);
            IStatus status = ce.getStatus();
            if (status instanceof BugzillaStatus && (res = (bs = (BugzillaStatus)status).getUserMatchResponse()) != null) {
                String assignedMsg = res.getAssignedToMsg();
                String newCCMsg = res.getNewCCMsg();
                String qaContactMsg = res.getQaContactMsg();
                StringBuilder sb = new StringBuilder();
                if (msg != null) {
                    sb.append(msg);
                }
                if (assignedMsg != null) {
                    sb.append('\n');
                    sb.append(assignedMsg);
                }
                if (newCCMsg != null) {
                    sb.append('\n');
                    sb.append(newCCMsg);
                }
                if (qaContactMsg != null) {
                    sb.append('\n');
                    sb.append(qaContactMsg);
                }
                msg = sb.toString();
            }
            if (msg == null && status instanceof RepositoryStatus && BugzillaExecutor.notifyHtmlMessage(html = (rs = (RepositoryStatus)status).getHtmlMessage(), repository, msg == null)) {
                return;
            }
            BugzillaExecutor.notifyErrorMessage(msg);
        }

        private static class DefaultHandler
        extends ExceptionHandler {
            public DefaultHandler(CoreException ce, String msg, BugzillaExecutor executor, BugzillaRepository repository) {
                super(ce, msg, executor, repository);
            }

            @Override
            String getMessage() {
                return this.errroMsg;
            }

            @Override
            protected boolean handle() {
                if (this.errroMsg != null) {
                    BugzillaExecutor.notifyErrorMessage(this.errroMsg);
                } else {
                    ExceptionHandler.notifyError(this.ce, this.repository);
                }
                return false;
            }
        }

        private static class NotFoundHandler
        extends ExceptionHandler {
            public NotFoundHandler(CoreException ce, String msg, BugzillaExecutor executor, BugzillaRepository repository) {
                super(ce, msg, executor, repository);
            }

            @Override
            String getMessage() {
                return this.errroMsg;
            }

            @Override
            protected boolean handle() {
                boolean ret = BugtrackingUtil.editRepository((Repository)BugzillaUtil.getRepository(this.executor.repository), (String)this.errroMsg);
                if (!ret) {
                    BugzillaExecutor.notifyErrorMessage(NbBundle.getMessage(BugzillaExecutor.class, (String)"MSG_ActionCanceledByUser"));
                }
                return ret;
            }
        }

        private static class MidAirHandler
        extends ExceptionHandler {
            public MidAirHandler(CoreException ce, String msg, BugzillaExecutor executor, BugzillaRepository repository) {
                super(ce, msg, executor, repository);
            }

            @Override
            String getMessage() {
                return this.errroMsg;
            }

            @Override
            protected boolean handle() {
                this.repository.refreshConfiguration();
                BugzillaConfiguration bc = this.repository.getConfiguration();
                return bc != null && bc.isValid();
            }

            @Override
            boolean reexecuteOnce() {
                return true;
            }
        }

        private static class LoginHandler
        extends ExceptionHandler {
            public LoginHandler(CoreException ce, String msg, BugzillaExecutor executor, BugzillaRepository repository) {
                super(ce, msg, executor, repository);
            }

            @Override
            String getMessage() {
                return this.errroMsg;
            }

            @Override
            protected boolean handle() {
                boolean ret = this.repository.authenticate(this.errroMsg);
                if (!ret) {
                    BugzillaExecutor.notifyErrorMessage(NbBundle.getMessage(BugzillaExecutor.class, (String)"MSG_ActionCanceledByUser"));
                }
                return ret;
            }
        }
    }
}

