/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.autoupdate;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.ui.api.PluginManager;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.BugzillaConfig;
import org.netbeans.modules.bugzilla.autoupdate.AutoupdatePanel;
import org.netbeans.modules.bugzilla.repository.BugzillaConfiguration;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class BugzillaAutoupdate {
    public static final BugzillaVersion SUPPORTED_BUGZILLA_VERSION;
    static final String BUGZILLA_MODULE_CODE_NAME = "org.netbeans.modules.bugzilla";
    private static Map<String, Long> lastChecks;
    private static final Pattern VERSION_PATTERN;
    private static BugzillaAutoupdate instance;
    private Map<String, Boolean> updateAvailableMap = new HashMap<String, Boolean>();
    private boolean wrongVersionAlreadyNotified;

    private BugzillaAutoupdate() {
    }

    public static BugzillaAutoupdate getInstance() {
        if (instance == null) {
            instance = new BugzillaAutoupdate();
        }
        return instance;
    }

    public boolean isUpdateAvailable(BugzillaRepository repository) {
        Boolean ret = this.updateAvailableMap.get(repository.getUrl());
        return ret != null ? ret : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAndNotify(BugzillaRepository repository) {
        Bugzilla.LOG.finest("BugzillaAutoupdate.checkAndNotify start");
        try {
            UpdateElement ue;
            if (this.wasCheckedToday(this.getLastCheck(repository))) {
                boolean bl = true;
                return bl;
            }
            if (!BugzillaConfig.getInstance().getCheckUpdates()) {
                boolean bl = true;
                return bl;
            }
            if (!this.checkSupportedBugzillaServerVersion(repository) && (ue = this.checkNewBugzillaPluginAvailable()) != null) {
                this.updateAvailableMap.put(repository.getUrl(), Boolean.TRUE);
                AutoupdatePanel panel = new AutoupdatePanel();
                if (BugzillaUtil.show(panel, NbBundle.getMessage(BugzillaAutoupdate.class, (String)"CTL_AutoupdateTitle"), NbBundle.getMessage(BugzillaAutoupdate.class, (String)"CTL_Yes"), new HelpCtx(BugzillaAutoupdate.class))) {
                    OperationContainer oc = OperationContainer.createForUpdate();
                    if (oc.canBeAdded(ue.getUpdateUnit(), ue)) {
                        oc.add(ue);
                        PluginManager.openInstallWizard((OperationContainer)oc);
                    } else {
                        BugzillaAutoupdate.notifyError(NbBundle.getMessage(BugzillaAutoupdate.class, (String)"MSG_CannotBeInstalled"), NbBundle.getMessage(BugzillaAutoupdate.class, (String)"LBL_Error"));
                    }
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            Bugzilla.LOG.finest("BugzillaAutoupdate.checkAndNotify finish");
        }
        return true;
    }

    private static void notifyError(String message, String title) {
        BugzillaAutoupdate.notifyInDialog(message, title, 0, true);
    }

    private static void notifyInDialog(String message, String title, int messageType, boolean cancelVisible) {
        Object[] objectArray;
        if (cancelVisible) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = NotifyDescriptor.OK_OPTION;
            objectArray = objectArray2;
            objectArray2[1] = NotifyDescriptor.CANCEL_OPTION;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = NotifyDescriptor.OK_OPTION;
        }
        NotifyDescriptor nd = new NotifyDescriptor((Object)message, title, -1, messageType, objectArray, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notifyLater(nd);
    }

    UpdateElement checkNewBugzillaPluginAvailable() {
        List units = UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
        for (UpdateUnit u : units) {
            if (!u.getCodeName().equals(BUGZILLA_MODULE_CODE_NAME)) continue;
            List elements = u.getAvailableUpdates();
            if (elements != null) {
                for (UpdateElement updateElement : elements) {
                    String desc = updateElement.getDescription();
                    BugzillaVersion version = this.getVersion(desc);
                    if (version != null) {
                        if (SUPPORTED_BUGZILLA_VERSION.compareTo(version) >= 0) continue;
                        return updateElement;
                    }
                    return elements.size() > 0 ? updateElement : null;
                }
                continue;
            }
            return null;
        }
        return null;
    }

    boolean checkSupportedBugzillaServerVersion(BugzillaRepository repository) {
        BugzillaConfiguration conf = repository.getConfiguration();
        if (!conf.isValid()) {
            return true;
        }
        BugzillaVersion version = conf.getInstalledVersion();
        if (version == null) {
            return true;
        }
        boolean ret = this.isSupportedVersion(version);
        if (!ret && !this.wrongVersionAlreadyNotified) {
            Bugzilla.LOG.log(Level.INFO, "Bugzilla repository [{0}] has version {1}. ", new Object[]{repository.getUrl(), version});
            this.wrongVersionAlreadyNotified = true;
        }
        return ret;
    }

    boolean isSupportedVersion(BugzillaVersion version) {
        return version.compareTo(SUPPORTED_BUGZILLA_VERSION) <= 0;
    }

    boolean wasCheckedToday(long lastCheck) {
        if (lastCheck < 0L) {
            return false;
        }
        Calendar c = Calendar.getInstance();
        c.add(13, c.get(13) * -1);
        c.add(12, c.get(12) * -1);
        c.add(10, c.get(10) * -1);
        return lastCheck > c.getTime().getTime();
    }

    private long getLastCheck(BugzillaRepository repository) {
        Long l;
        if (lastChecks == null) {
            lastChecks = new HashMap<String, Long>(1);
        }
        if ((l = lastChecks.get(repository.getUrl())) == null) {
            lastChecks.put(repository.getUrl(), System.currentTimeMillis());
            return -1L;
        }
        return l;
    }

    BugzillaVersion getVersion(String desc) {
        Matcher m = VERSION_PATTERN.matcher(desc);
        if (m.matches()) {
            return new BugzillaVersion(m.group(1));
        }
        return null;
    }

    static {
        String version = System.getProperty("netbeans.t9y.bugzilla.supported.version");
        SUPPORTED_BUGZILLA_VERSION = version != null ? new BugzillaVersion(version) : BugzillaVersion.BUGZILLA_4_0;
        lastChecks = null;
        VERSION_PATTERN = Pattern.compile("^.*version ((\\d+?\\.\\d+?\\.\\d+?)|(\\d+?\\.\\d+?)).*$");
    }
}

