/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.api;

import java.io.File;
import java.net.URL;
import java.util.regex.Pattern;
import org.netbeans.modules.bugtracking.api.Issue;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.repository.NBRepositorySupport;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;

public class NBBugzillaUtils {
    private static Pattern netbeansUrlPattern = Pattern.compile("(https|http)://(([a-z]|\\d)+\\.)*([a-z]|\\d)*netbeans([a-z]|\\d)*(([a-z]|\\d)*\\.)+org(.*)");

    public static void openIssue(String issueID) {
        Repository nbRepo = NBRepositorySupport.getInstance().getNBRepository();
        assert (nbRepo != null);
        if (nbRepo == null) {
            Bugzilla.LOG.warning("No bugzilla repository available for netbeans.org");
            return;
        }
        Issue.open((Repository)nbRepo, (String)issueID);
    }

    public static String getNBUsername() {
        return BugtrackingUtil.getNBUsername();
    }

    public static char[] getNBPassword() {
        return BugtrackingUtil.getNBPassword();
    }

    public static void saveNBUsername(String username) {
        BugtrackingUtil.saveNBUsername((String)username);
    }

    public static void saveNBPassword(char[] password) {
        BugtrackingUtil.saveNBPassword((char[])password);
    }

    public static boolean isNbRepository(URL url) {
        assert (url != null);
        boolean ret = netbeansUrlPattern.matcher(url.toString()).matches();
        if (ret) {
            return true;
        }
        String nbUrl = System.getProperty("netbeans.bugzilla.url");
        if (nbUrl == null || nbUrl.equals("")) {
            return false;
        }
        return url.toString().startsWith(nbUrl);
    }

    public static Repository findNBRepository() {
        return NBRepositorySupport.getInstance().getNBRepository();
    }

    public static void attachFiles(String id, String comment, String[] desc, String[] contentType, File[] files) {
        assert (id != null);
        assert (desc != null);
        assert (files != null);
        assert (contentType != null);
        assert (desc.length == files.length);
        assert (contentType.length == files.length);
        BugzillaRepository nbRepo = NBRepositorySupport.getInstance().getNBBugzillaRepository();
        BugzillaIssue issue = nbRepo.getIssue(id);
        if (issue == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            issue.addAttachment(files[i], comment, desc[i], contentType[i], false);
        }
        BugzillaUtil.openIssue(issue);
    }
}

