/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.query.BugzillaQuery;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.netbeans.modules.bugzilla.util.FileUtils;
import org.openide.modules.Places;
import org.openide.util.ImageUtilities;
import org.openide.util.NbPreferences;

public class BugzillaConfig {
    private static BugzillaConfig instance = null;
    private static final String LAST_CHANGE_FROM = "bugzilla.last_change_from";
    private static final String QUERY_NAME = "bugzilla.query_";
    private static final String QUERY_REFRESH_INT = "bugzilla.query_refresh";
    private static final String QUERY_AUTO_REFRESH = "bugzilla.query_auto_refresh_";
    private static final String ISSUE_REFRESH_INT = "bugzilla.issue_refresh";
    private static final String DELIMITER = "<=>";
    private static final String CHECK_UPDATES = "jira.check_updates";
    private static final String ATTACH_LOG = "bugzilla.attach_log";
    private static final String TASKLISTISSUES_STORAGE_FILE = "tasklistissues.data";
    private static final Level LOG_LEVEL = BugzillaUtil.isAssertEnabled() ? Level.SEVERE : Level.INFO;
    public static final int DEFAULT_QUERY_REFRESH = 30;
    public static final int DEFAULT_ISSUE_REFRESH = 15;
    private Map<String, Icon> priorityIcons;

    private BugzillaConfig() {
    }

    public static BugzillaConfig getInstance() {
        if (instance == null) {
            instance = new BugzillaConfig();
        }
        return instance;
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(BugzillaConfig.class);
    }

    public void setQueryRefreshInterval(int i) {
        this.getPreferences().putInt(QUERY_REFRESH_INT, i);
    }

    public void setIssueRefreshInterval(int i) {
        this.getPreferences().putInt(ISSUE_REFRESH_INT, i);
    }

    public void setQueryAutoRefresh(String queryName, boolean refresh) {
        this.getPreferences().putBoolean(QUERY_AUTO_REFRESH + queryName, refresh);
    }

    public void setCheckUpdates(boolean bl) {
        this.getPreferences().putBoolean(CHECK_UPDATES, bl);
    }

    public int getQueryRefreshInterval() {
        return this.getPreferences().getInt(QUERY_REFRESH_INT, 30);
    }

    public int getIssueRefreshInterval() {
        return this.getPreferences().getInt(ISSUE_REFRESH_INT, 15);
    }

    public boolean getQueryAutoRefresh(String queryName) {
        return this.getPreferences().getBoolean(QUERY_AUTO_REFRESH + queryName, false);
    }

    public boolean getCheckUpdates() {
        return this.getPreferences().getBoolean(CHECK_UPDATES, true);
    }

    public boolean getAttachLogFile() {
        return this.getPreferences().getBoolean(ATTACH_LOG, true);
    }

    public void putAttachLogFile(boolean attach) {
        this.getPreferences().putBoolean(ATTACH_LOG, attach);
    }

    public void putQuery(BugzillaRepository repository, BugzillaQuery query) {
        this.getPreferences().put(this.getQueryKey(repository.getID(), query.getDisplayName()), query.getUrlParameters() + DELIMITER + DELIMITER + query.isUrlDefined());
    }

    public void removeQuery(BugzillaRepository repository, BugzillaQuery query) {
        this.getPreferences().remove(this.getQueryKey(repository.getID(), query.getDisplayName()));
    }

    public BugzillaQuery getQuery(BugzillaRepository repository, String queryName) {
        String value = this.getStoredQuery(repository, queryName);
        if (value == null) {
            return null;
        }
        String[] values = value.split(DELIMITER);
        assert (values.length >= 2);
        String urlParams = values[0];
        boolean urlDef = values.length > 2 ? Boolean.parseBoolean(values[2]) : false;
        return new BugzillaQuery(queryName, repository, urlParams, true, urlDef, true);
    }

    public String getUrlParams(BugzillaRepository repository, String queryName) {
        String value = this.getStoredQuery(repository, queryName);
        if (value == null) {
            return null;
        }
        String[] values = value.split(DELIMITER);
        assert (values.length >= 2);
        return values[0];
    }

    public String[] getQueries(String repoID) {
        return this.getKeysWithPrefix(QUERY_NAME + repoID + DELIMITER);
    }

    private String[] getKeysWithPrefix(String prefix) {
        String[] keys = null;
        try {
            keys = this.getPreferences().keys();
        }
        catch (BackingStoreException ex) {
            Bugzilla.LOG.log(Level.SEVERE, null, ex);
        }
        if (keys == null || keys.length == 0) {
            return new String[0];
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (String key : keys) {
            if (!key.startsWith(prefix)) continue;
            ret.add(key.substring(prefix.length()));
        }
        return ret.toArray(new String[ret.size()]);
    }

    private String getQueryKey(String repositoryID, String queryName) {
        return QUERY_NAME + repositoryID + DELIMITER + queryName;
    }

    private String getStoredQuery(BugzillaRepository repository, String queryName) {
        String value = this.getPreferences().get(this.getQueryKey(repository.getID(), queryName), null);
        return value;
    }

    public void setLastChangeFrom(String value) {
        this.getPreferences().put(LAST_CHANGE_FROM, value);
    }

    public String getLastChangeFrom() {
        return this.getPreferences().get(LAST_CHANGE_FROM, "");
    }

    public Icon getPriorityIcon(String priority) {
        if (this.priorityIcons == null) {
            this.priorityIcons = new HashMap<String, Icon>();
            this.priorityIcons.put("P1", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/p1.png", (boolean)true));
            this.priorityIcons.put("P2", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/p2.png", (boolean)true));
            this.priorityIcons.put("P3", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/p3.png", (boolean)true));
            this.priorityIcons.put("P4", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/p4.png", (boolean)true));
            this.priorityIcons.put("P5", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/p5.png", (boolean)true));
        }
        return this.priorityIcons.get(priority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskListIssues(HashMap<String, List<String>> issues) {
        Bugzilla.LOG.fine("setTaskListIssues: saving issues");
        File f = new File(BugzillaConfig.getNBConfigPath());
        f.mkdirs();
        if (!f.canWrite()) {
            Bugzilla.LOG.warning("setTaskListIssues: Cannot create perm storage");
            return;
        }
        ObjectOutputStream out = null;
        File file = new File(f, "tasklistissues.data.tmp");
        boolean success = false;
        try {
            out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            out.writeInt(issues.size());
            for (Map.Entry<String, List<String>> entry : issues.entrySet()) {
                out.writeUTF(entry.getKey());
                out.writeInt(entry.getValue().size());
                for (String issueAttributes : entry.getValue()) {
                    out.writeUTF(issueAttributes);
                }
            }
            success = true;
        }
        catch (IOException ex) {
            Bugzilla.LOG.log(LOG_LEVEL, null, ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
        if (success) {
            File newFile = new File(f, TASKLISTISSUES_STORAGE_FILE);
            try {
                FileUtils.renameFile(file, newFile);
            }
            catch (IOException ex) {
                Bugzilla.LOG.log(LOG_LEVEL, null, ex);
                success = false;
            }
        }
        if (!success) {
            Bugzilla.LOG.warning("setTaskListIssues: could not save issues");
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> getTaskListIssues() {
        Bugzilla.LOG.fine("loadTaskListIssues: loading issues");
        File f = new File(BugzillaConfig.getNBConfigPath());
        ObjectInputStream ois = null;
        File file = new File(f, TASKLISTISSUES_STORAGE_FILE);
        if (!file.canRead()) {
            Bugzilla.LOG.fine("loadTaskListIssues: no saved data");
            return Collections.emptyMap();
        }
        try {
            ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            int size = ois.readInt();
            Bugzilla.LOG.fine("loadTaskListIssues: loading " + size + " records");
            HashMap<String, List<String>> issuesPerRepo = new HashMap<String, List<String>>(size);
            while (size-- > 0) {
                String repoUrl = ois.readUTF();
                Bugzilla.LOG.fine("loadTaskListIssues: loading issues for " + repoUrl);
                int issueCount = ois.readInt();
                Bugzilla.LOG.fine("loadTaskListIssues: loading " + issueCount + " issues");
                LinkedList<String> issues = new LinkedList<String>();
                while (issueCount-- > 0) {
                    issues.add(ois.readUTF());
                }
                issuesPerRepo.put(repoUrl, issues);
            }
            HashMap<String, List<String>> hashMap = issuesPerRepo;
            return hashMap;
        }
        catch (IOException ex) {
            Bugzilla.LOG.log(LOG_LEVEL, null, ex);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {}
            }
        }
        return Collections.emptyMap();
    }

    private static String getNBConfigPath() {
        String t9yNbConfigPath = System.getProperty("netbeans.t9y.bugzilla.nb.config.path");
        if (t9yNbConfigPath != null && t9yNbConfigPath.length() > 0) {
            return t9yNbConfigPath;
        }
        String nbHome = Places.getUserDirectory().getAbsolutePath();
        return nbHome + "/config/issue-tracking/org-netbeans-modules-bugzilla";
    }
}

