/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla;

import java.net.MalformedURLException;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClientManager;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.netbeans.modules.bugtracking.spi.BugtrackingFactory;
import org.netbeans.modules.bugtracking.util.UndoRedoSupport;
import org.netbeans.modules.bugzilla.BugzillaIssueProvider;
import org.netbeans.modules.bugzilla.BugzillaQueryProvider;
import org.netbeans.modules.bugzilla.BugzillaRepositoryProvider;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.issue.BugzillaTaskListProvider;
import org.netbeans.modules.bugzilla.query.BugzillaQuery;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.openide.util.RequestProcessor;

public class Bugzilla {
    private BugzillaRepositoryConnector brc = new BugzillaRepositoryConnector();
    private static Bugzilla instance;
    public static final Logger LOG;
    private RequestProcessor rp;
    private BugzillaClientManager clientManager = this.brc.getClientManager();
    private BugtrackingFactory<BugzillaRepository, BugzillaQuery, BugzillaIssue> bf;
    private BugzillaIssueProvider bip;
    private BugzillaQueryProvider bqp;
    private BugzillaRepositoryProvider brp;

    private Bugzilla() {
        this.getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                BugzillaTaskListProvider.getInstance();
            }
        });
    }

    public static synchronized Bugzilla getInstance() {
        if (instance == null) {
            instance = new Bugzilla();
        }
        return instance;
    }

    static synchronized void init() {
        Bugzilla.getInstance();
    }

    public BugzillaRepositoryConnector getRepositoryConnector() {
        return this.brc;
    }

    public RepositoryConfiguration getRepositoryConfiguration(BugzillaRepository repository, boolean forceRefresh) throws CoreException, MalformedURLException {
        this.getClient(repository);
        RepositoryConfiguration rc = this.brc.getRepositoryConfiguration(repository.getTaskRepository(), forceRefresh, (IProgressMonitor)new NullProgressMonitor());
        return rc;
    }

    public BugzillaClient getClient(BugzillaRepository repository) throws MalformedURLException, CoreException {
        return this.clientManager.getClient(repository.getTaskRepository(), (IProgressMonitor)new NullProgressMonitor());
    }

    public final RequestProcessor getRequestProcessor() {
        if (this.rp == null) {
            this.rp = new RequestProcessor("Bugzilla", 1, true);
        }
        return this.rp;
    }

    public BugtrackingFactory<BugzillaRepository, BugzillaQuery, BugzillaIssue> getBugtrackingFactory() {
        if (this.bf == null) {
            this.bf = new BugtrackingFactory();
        }
        return this.bf;
    }

    public BugzillaIssueProvider getIssueProvider() {
        if (this.bip == null) {
            this.bip = new BugzillaIssueProvider();
        }
        return this.bip;
    }

    public BugzillaQueryProvider getQueryProvider() {
        if (this.bqp == null) {
            this.bqp = new BugzillaQueryProvider();
        }
        return this.bqp;
    }

    public BugzillaRepositoryProvider getRepositoryProvider() {
        if (this.brp == null) {
            this.brp = new BugzillaRepositoryProvider();
        }
        return this.brp;
    }

    public UndoRedoSupport getUndoRedoSupport(BugzillaIssue issue) {
        return this.getBugtrackingFactory().getUndoRedoSupport(BugzillaUtil.getRepository(issue.getRepository()), (Object)issue);
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.bugzilla.Bugzilla");
    }
}

