/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.samples;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.samples.MavenSamplesWizardPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class MavenSamplesWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator {
    private int index;
    private WizardDescriptor.Panel[] panels;
    protected WizardDescriptor wiz;
    private final String title;

    public MavenSamplesWizardIterator(String title) {
        this.title = title;
    }

    public static MavenSamplesWizardIterator createCalculatorIterator() {
        return new MavenSamplesWizardIterator(NbBundle.getMessage(MavenSamplesWizardIterator.class, (String)"Templates/Project/Samples/Maven/MavenCalculator"));
    }

    public static MavenSamplesWizardIterator createCalculatorClientIterator() {
        return new MavenSamplesWizardIterator(NbBundle.getMessage(MavenSamplesWizardIterator.class, (String)"Templates/Project/Samples/Maven/MavenCalculatorClient"));
    }

    public static MavenSamplesWizardIterator createScrumToysIterator() {
        return new MavenSamplesWizardIterator(NbBundle.getMessage(MavenSamplesWizardIterator.class, (String)"Templates/Project/Samples/Maven/MavenScrumToys"));
    }

    protected WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new MavenSamplesWizardPanel(true)};
    }

    protected String[] createSteps() {
        return new String[]{NbBundle.getMessage(MavenSamplesWizardIterator.class, (String)"LBL_CreateProjectStep")};
    }

    public Set instantiate(ProgressHandle handle) throws IOException {
        NbMavenProject mvn;
        handle.start(5);
        LinkedHashSet<FileObject> resultSet = new LinkedHashSet<FileObject>();
        File dirF = FileUtil.normalizeFile((File)((File)this.wiz.getProperty("projdir")));
        MavenSamplesWizardIterator.createFolder(dirF);
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wiz);
        FileObject dir = FileUtil.toFileObject((File)dirF);
        MavenSamplesWizardIterator.unZipFile(template.getInputStream(), dir);
        this.configureProject(dir);
        ProjectManager.getDefault().clearNonProjectCache();
        resultSet.add(dir);
        handle.progress(1);
        Project prj = ProjectManager.getDefault().findProject(dir);
        if (prj != null && (mvn = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class)) != null) {
            mvn.downloadDependencyAndJavadocSource(false);
        }
        handle.progress(3);
        Enumeration e = dir.getFolders(true);
        while (e.hasMoreElements()) {
            FileObject subfolder = (FileObject)e.nextElement();
            if (!ProjectManager.getDefault().isProject(subfolder) || (prj = ProjectManager.getDefault().findProject(subfolder)) == null) continue;
            NbMavenProject mvn2 = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
            if (mvn2 != null) {
                mvn2.downloadDependencyAndJavadocSource(false);
            }
            resultSet.add(subfolder);
        }
        handle.progress(4);
        File parent = dirF.getParentFile();
        if (parent != null && parent.exists()) {
            ProjectChooser.setProjectsFolder((File)parent);
        }
        return resultSet;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        wiz.putProperty("NewProjectWizard_Title", (Object)this.title);
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
        FileObject template = Templates.getTemplate((WizardDescriptor)wiz);
        wiz.putProperty("name", (Object)template.getName());
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wiz.putProperty("projdir", null);
        this.wiz.putProperty("name", null);
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return NbBundle.getMessage(MavenSamplesWizardIterator.class, (String)"LBL_Order", (Object[])new Object[]{new Integer(this.index + 1), new Integer(this.panels.length)});
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unZipFile(InputStream source, FileObject projectRoot) throws IOException {
        try {
            ZipEntry entry;
            ZipInputStream str = new ZipInputStream(source);
            while ((entry = str.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    FileUtil.createFolder((FileObject)projectRoot, (String)entry.getName());
                    continue;
                }
                FileObject fo = FileUtil.createData((FileObject)projectRoot, (String)entry.getName());
                OutputStream out = fo.getOutputStream();
                try {
                    FileUtil.copy((InputStream)str, (OutputStream)out);
                }
                finally {
                    out.close();
                }
            }
        }
        finally {
            source.close();
        }
    }

    private static FileObject createFolder(File dir) throws IOException {
        Stack<String> stack = new Stack<String>();
        while (!dir.exists()) {
            stack.push(dir.getName());
            dir = dir.getParentFile();
        }
        FileObject dirFO = FileUtil.toFileObject((File)dir);
        if (dirFO == null) {
            MavenSamplesWizardIterator.refreshFileSystem(dir);
            dirFO = FileUtil.toFileObject((File)dir);
        }
        assert (dirFO != null);
        while (!stack.isEmpty()) {
            dirFO = dirFO.createFolder((String)stack.pop());
        }
        return dirFO;
    }

    private static void refreshFileSystem(File dir) throws FileStateInvalidException {
        File rootF = dir;
        while (rootF.getParentFile() != null) {
            rootF = rootF.getParentFile();
        }
        FileObject dirFO = FileUtil.toFileObject((File)rootF);
        assert (dirFO != null) : "At least disk roots must be mounted! " + rootF;
        dirFO.getFileSystem().refresh(false);
    }

    public Set instantiate() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void configureProject(FileObject dir) throws IOException {
    }
}

