/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.testng.ui.TypeNameIdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TestMethodNameGenerator {
    private static final int MAX_SUFFIX_TYPES = 2;
    private Collection<String> reservedNames;
    private final WorkingCopy workingCopy;
    private final List<ExecutableElement> srcMethods;
    private final TypeElement tstClassElem;
    private final List<ExecutableElement> existingMethods;
    private final String[] testMethodNames;

    private TestMethodNameGenerator(List<ExecutableElement> srcMethods, TypeElement tstClassElem, WorkingCopy workingCopy) {
        this.srcMethods = srcMethods;
        this.tstClassElem = tstClassElem;
        this.workingCopy = workingCopy;
        this.existingMethods = tstClassElem != null ? TestMethodNameGenerator.getExistingMethods(tstClassElem) : Collections.emptyList();
        this.reservedNames = new HashSet<String>((this.existingMethods.size() * 3 + 1) / 2);
        this.testMethodNames = new String[srcMethods.size()];
    }

    static List<String> getTestMethodNames(List<ExecutableElement> srcMethods, TypeElement tstClassElem, Collection<String> reservedMethodNames, WorkingCopy workingCopy) {
        TestMethodNameGenerator inst = new TestMethodNameGenerator(srcMethods, tstClassElem, workingCopy);
        if (reservedMethodNames != null) {
            inst.reservedNames.addAll(reservedMethodNames);
        }
        return inst.getTestMethodNames();
    }

    private List<String> getTestMethodNames() {
        int testedCount;
        if (this.tstClassElem != null) {
            this.collectExistingMethodNames(this.tstClassElem, this.reservedNames);
        }
        int methodsCount = this.srcMethods.size();
        String[] result = new String[methodsCount];
        HashMap<String, Object> namesUsage = new HashMap<String, Object>(methodsCount * 3 + 0);
        BitSet conflicting = new BitSet(methodsCount);
        int conflictingCount = 0;
        int index = -1;
        assert (namesUsage.isEmpty());
        for (ExecutableElement srcMethod : this.srcMethods) {
            String testMethodName;
            String srcMethodName = srcMethod.getSimpleName().toString();
            this.testMethodNames[++index] = testMethodName = TestMethodNameGenerator.buildTestMethodName(srcMethodName);
            conflictingCount += this.registerTestMethodName(testMethodName, index, namesUsage, conflicting);
        }
        namesUsage.clear();
        assert (conflictingCount <= methodsCount);
        assert (conflictingCount == conflicting.cardinality());
        int uniqueCount = methodsCount - conflictingCount;
        if (uniqueCount > 0) {
            index = conflicting.nextClearBit(0);
            while (index >= 0 && index < methodsCount) {
                String name;
                result[index] = name = this.testMethodNames[index];
                this.reservedNames.add(name);
                index = conflicting.nextClearBit(index + 1);
            }
        }
        int[] paramsCount = null;
        Collection<TypeMirror> paramTypes = null;
        if (conflictingCount > 0) {
            paramsCount = new int[this.srcMethods.size()];
            paramTypes = this.collectParamTypes(paramsCount);
            BitSet tested = TestMethodNameGenerator.findNoArgMethods(paramsCount, conflicting);
            BitSet noArgConflicting = new BitSet(this.srcMethods.size());
            int testedCount2 = tested.cardinality();
            assert (namesUsage.isEmpty());
            int noArgConflictingCount = 0;
            index = tested.nextSetBit(0);
            while (index >= 0) {
                noArgConflictingCount += this.registerTestMethodName(this.testMethodNames[index], index, namesUsage, noArgConflicting);
                index = tested.nextSetBit(index + 1);
            }
            namesUsage.clear();
            assert (noArgConflictingCount <= testedCount2);
            assert (noArgConflictingCount == noArgConflicting.cardinality());
            int noArgUniqueCount = methodsCount - conflictingCount;
            if (noArgUniqueCount > 0) {
                BitSet noArgUnique = new BitSet(tested.size());
                noArgUnique.or(tested);
                noArgUnique.andNot(noArgConflicting);
                index = noArgUnique.nextSetBit(0);
                while (index >= 0) {
                    String name;
                    result[index] = name = this.testMethodNames[index];
                    this.reservedNames.add(name);
                    index = noArgUnique.nextSetBit(index + 1);
                }
            }
            if (noArgConflictingCount > 0) {
                HashMap<String, Integer> usageNumbers = new HashMap<String, Integer>((noArgConflictingCount + 1) * 3 / 2);
                noArgConflicting = tested;
                index = noArgConflicting.nextSetBit(0);
                while (index >= 0) {
                    String numberedName;
                    int suffix;
                    String simpleName = this.testMethodNames[index];
                    Integer oldValue = (Integer)usageNumbers.get(simpleName);
                    int n = suffix = oldValue == null ? 0 : oldValue;
                    while (this.reservedNames.contains(numberedName = simpleName + ++suffix)) {
                    }
                    usageNumbers.put(simpleName, suffix);
                    result[index] = numberedName;
                    this.reservedNames.add(numberedName);
                    index = noArgConflicting.nextSetBit(index + 1);
                }
            }
            conflicting.andNot(noArgConflicting);
            assert ((conflictingCount -= noArgConflictingCount) + (uniqueCount += noArgConflictingCount) == methodsCount);
        }
        String[] typeIdSuffixes = null;
        String[] parCntSuffixes = null;
        if (conflictingCount > 0) {
            BitSet tested = (BitSet)conflicting.clone();
            testedCount = conflictingCount;
            conflicting.clear();
            conflictingCount = 0;
            assert (paramsCount != null);
            assert (paramTypes != null);
            TypeNameIdGenerator typeIdGenerator = null;
            if (!paramTypes.isEmpty()) {
                typeIdGenerator = TypeNameIdGenerator.createFor(paramTypes, this.workingCopy.getElements(), this.workingCopy.getTypes());
            }
            assert (namesUsage.isEmpty());
            String[] methodNames = new String[methodsCount];
            typeIdSuffixes = new String[methodsCount];
            parCntSuffixes = new String[methodsCount];
            index = tested.nextSetBit(0);
            while (index >= 0) {
                String suffix;
                int parCount = paramsCount[index];
                if (parCount > 2) {
                    suffix = parCntSuffixes[index] = TestMethodNameGenerator.makeParamCountSuffix(parCount);
                } else {
                    List<? extends VariableElement> params = this.srcMethods.get(index).getParameters();
                    StringBuilder buf = new StringBuilder(40);
                    for (int i = 0; i < parCount; ++i) {
                        buf.append('_');
                        buf.append(typeIdGenerator.getParamTypeId(params.get(i).asType()));
                    }
                    suffix = typeIdSuffixes[index] = buf.toString();
                }
                String methodName = methodNames[index] = this.testMethodNames[index] + suffix;
                conflictingCount += this.registerTestMethodName(methodName, index, namesUsage, conflicting);
                index = tested.nextSetBit(index + 1);
            }
            namesUsage.clear();
            uniqueCount = testedCount - conflictingCount;
            if (uniqueCount > 0) {
                BitSet unique = (BitSet)tested.clone();
                unique.andNot(conflicting);
                assert (unique.cardinality() == uniqueCount);
                index = unique.nextSetBit(0);
                while (index >= 0) {
                    String methodName;
                    result[index] = methodName = methodNames[index];
                    this.reservedNames.add(methodName);
                    index = unique.nextSetBit(index + 1);
                }
            }
        }
        if (conflictingCount > 0) {
            assert (typeIdSuffixes != null);
            assert (parCntSuffixes != null);
            BitSet tested = (BitSet)conflicting.clone();
            testedCount = conflictingCount;
            conflicting.clear();
            conflictingCount = 0;
            assert (namesUsage.isEmpty());
            String[] methodNames = new String[methodsCount];
            index = tested.nextSetBit(0);
            while (index >= 0) {
                String parCntSuffix;
                int parCount = paramsCount[index];
                StringBuilder buf = new StringBuilder(60);
                buf.append(this.testMethodNames[index]);
                if (parCount <= 2) {
                    assert (typeIdSuffixes[index] != null);
                    buf.append(typeIdSuffixes[index]);
                }
                if ((parCntSuffix = parCntSuffixes[index]) == null) {
                    assert (parCount <= 2);
                    parCntSuffix = parCntSuffixes[index] = TestMethodNameGenerator.makeParamCountSuffix(parCount);
                }
                buf.append(parCntSuffix);
                String methodName = methodNames[index] = buf.toString();
                conflictingCount += this.registerTestMethodName(methodName, index, namesUsage, conflicting);
                index = tested.nextSetBit(index + 1);
            }
            namesUsage.clear();
            uniqueCount = testedCount - conflictingCount;
            if (uniqueCount > 0) {
                BitSet unique = (BitSet)tested.clone();
                unique.andNot(conflicting);
                assert (unique.cardinality() == uniqueCount);
                index = unique.nextSetBit(0);
                while (index >= 0) {
                    String methodName;
                    result[index] = methodName = methodNames[index];
                    this.reservedNames.add(methodName);
                    index = unique.nextSetBit(index + 1);
                }
            }
        }
        if (conflictingCount > 0) {
            HashMap<String, Integer> usageNumbers = new HashMap<String, Integer>((conflictingCount * 3 + 1) / 2);
            assert (parCntSuffixes != null);
            index = conflicting.nextSetBit(0);
            while (index >= 0) {
                String methodName;
                int suffix;
                String noNumMethodName = this.testMethodNames[index] + parCntSuffixes[index] + '_';
                Integer oldValue = (Integer)usageNumbers.get(noNumMethodName);
                int n = suffix = oldValue == null ? 0 : oldValue;
                while (this.reservedNames.contains(methodName = noNumMethodName + ++suffix)) {
                }
                usageNumbers.put(methodName, suffix);
                result[index] = methodName;
                this.reservedNames.add(methodName);
                index = conflicting.nextSetBit(index + 1);
            }
        }
        return Arrays.asList(result);
    }

    private static final String makeParamCountSuffix(int paramCount) {
        return new StringBuilder(8).append('_').append(paramCount).append("args").toString();
    }

    private int registerTestMethodName(String testMethodName, int index, Map<String, Object> namesUsage, BitSet conflictingNamesIndices) {
        boolean nameConflict;
        Object oldValue = namesUsage.put(testMethodName, index);
        boolean bl = nameConflict = oldValue != null || this.reservedNames != null && this.reservedNames.contains(testMethodName);
        assert (!conflictingNamesIndices.get(index));
        int rv = 0;
        if (nameConflict) {
            if (oldValue != null && oldValue != Boolean.TRUE) {
                assert (oldValue.getClass() == Integer.class);
                int conflictingNameIndex = (Integer)oldValue;
                assert (!conflictingNamesIndices.get(conflictingNameIndex));
                conflictingNamesIndices.set(conflictingNameIndex);
                ++rv;
            }
            conflictingNamesIndices.set(index);
            namesUsage.put(testMethodName, Boolean.TRUE);
            ++rv;
        }
        return rv;
    }

    private void collectExistingMethodNames(TypeElement clazz, Collection<String> reservedMethodNames) {
        Elements elements = this.workingCopy.getElements();
        List<? extends Element> allMembers = elements.getAllMembers(clazz);
        List<ExecutableElement> methods = ElementFilter.methodsIn(allMembers);
        if (!methods.isEmpty()) {
            for (ExecutableElement method : methods) {
                if (!method.getParameters().isEmpty()) continue;
                reservedMethodNames.add(method.getSimpleName().toString());
            }
        }
    }

    private Collection<TypeMirror> collectParamTypes(int[] paramsCount) {
        ArrayList<TypeMirror> paramTypes = new ArrayList<TypeMirror>(this.srcMethods.size());
        int index = -1;
        for (ExecutableElement srcMethod : this.srcMethods) {
            int parCount;
            ++index;
            List<? extends VariableElement> params = srcMethod.getParameters();
            if (params.isEmpty()) {
                paramsCount[index] = 0;
                continue;
            }
            paramsCount[index] = parCount = params.size();
            if (parCount > 2) continue;
            for (int i = 0; i < parCount; ++i) {
                paramTypes.add(params.get(i).asType());
            }
        }
        return !paramTypes.isEmpty() ? paramTypes : Collections.emptyList();
    }

    private static List<ExecutableElement> getExistingMethods(TypeElement classElem) {
        List<? extends Element> elements = classElem.getEnclosedElements();
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        List<ExecutableElement> methods = ElementFilter.methodsIn(elements);
        return !methods.isEmpty() ? methods : Collections.emptyList();
    }

    private static String buildTestMethodName(String srcMethodName) {
        int length = srcMethodName.length();
        StringBuilder buf = new StringBuilder(length + 4);
        buf.append("test");
        buf.append(Character.toUpperCase(srcMethodName.charAt(0)));
        if (length != 1) {
            buf.append(srcMethodName.substring(1));
        }
        return buf.toString();
    }

    private static BitSet findNoArgMethods(int[] paramsCount, BitSet conflicting) {
        BitSet result = new BitSet(paramsCount.length);
        for (int index = 0; index < paramsCount.length; ++index) {
            if (paramsCount[index] != 0 || !conflicting.get(index)) continue;
            result.set(index);
        }
        return result;
    }
}

